/*------------------------------------------------
   BACKTAB.C -- Extension DLL for E! - version 1.0

   To compile: nmake backtab.mak

   Once compiled, copy BACKTAB.EWD to your USER directory.

   To use this DLL simply load it from the user menu or add its name to the
   list of autoloaded Extension DLLs by using the Autoload dialog box from
   the User Menu of EW. That's all.

   This extension DLL adds a new function to E!. It erases all text between
   the current cursor position and the previous tab position, shifting all
   the text after the cursor to the left.

   You can assign this extension to a keystroke (Ctrl Bsp would be nice).
   See the documentation for a description of how to assign DLL execution
   to a keystroke. Once assigned to a keystroke, an extension DLL needs not
   be explicitly loaded. EW takes care of this for you.
  ------------------------------------------------*/

#include <windows.h>
#include <string.h>
#include "ewapi.h"

int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize,
			LPSTR lpszCmdLine)
{
  if (wHeapSize > 0)
    UnlockData (0) ;
  return 1 ;
}

int FAR PASCAL EWExecute(unsigned int RoutineId)
{
  WORD	xPos1, xPos2, yPos;
  long	CaretPos1, CaretPos2;
  char	LineBuffer[256];
  HWND	H;

  CaretPos1 = EWGetCaretPos();		     // Get current caret position
  xPos1 = LOWORD(CaretPos1);
  yPos = HIWORD(CaretPos1);
  if ((xPos1 != 0) && (!EWGotoPrevTab())) {  // Go to previous Tab position
    CaretPos2 = EWGetCaretPos();
    xPos2 = LOWORD(CaretPos2);
    _fstrcpy(LineBuffer, EWGetLineAt(yPos)); // Get current line
    _fmemmove(LineBuffer + xPos2,	     // Erase unwanted characters
	      LineBuffer + xPos1,
	      _fstrlen(LineBuffer + xPos1) + 1);
    EWSetLineAt(LineBuffer, yPos);	     // Move new line to actual text
    H = EWGetTextWindowHandle();
    InvalidateRect(H, NULL, FALSE);	     // Repaint window
    UpdateWindow(H);
    EWSetModified();			     // Tell E! that the text has been modified
    return(0);
  }
  else
    return(ewerr_EXTFAILED);
}
