#if !defined (TWINDOW)               // Prevents multiple declarations errors
#define TWINDOW


/*
   Module        : TWINDOW.HPP
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : Header file of {twindow} class.
*/


// Headers ------------------------------------------------------------------

#include <conio.h>                                     // System's librairies
#include <stdio.h>
#include <values.h>

#include "tinput.hpp"                                        // Other modules


// Macros -------------------------------------------------------------------

#include "stdmacro.h"                           // Standard macro definitions


// TypeDefs -----------------------------------------------------------------

#include "stdtype.h"                             // Standard type definitions


struct tbutton                                         // Button's definition
{
   char    huge *buttonname ;                                // Button's name
   int          buttonkey ;              // Key code that 'pushes' the button
   int          buttonrow ;                         // Button's row in window
   int          buttoncol ;                         // Button's col in window
   bool         buttonavail ;                    // TRUE: Button is available
   char    huge *buttonsltext ;                   // Button's statusline text
   int          buttonhlpctx ;                // Button's help context number
   tbutton huge *buttonnext ;                   // Ptr to next button in link
   tbutton huge *buttonprevious ;           // Ptr to previous button in link
} ;


struct tfield                                     // Input field's definition
{
   int          fieldnumber ;                   // Input field's ID # ([1..[)
   char   huge  *fieldanswer ;                      // Ptr to answer's buffer
   int          fieldanswerlength ;                    // Answer's max length
   int          fieldlength ;                         // Input field's length
   int          fieldrow ;                           // Field's row in window
   int          fieldcol ;                           // Field's col in window
   int          fieldftr ;                     // Filter used for input (0-4)
   char   huge  *fieldxtraftr ;               // Extra chars to use as filter
   bool         fieldcapsflag ;             // If TRUE, switches to uppercase
   bool         fieldnullflag ;           // If TRUE, can enter a null string
   char   huge  *fieldsltext ;                     // Field's statusline text
   int          fieldhlpctx ;                  // Field's help context number
   tfield huge  *fieldnext ;                     // Ptr to next field in link
   tfield huge  *fieldprevious ;             // Ptr to previous field in link
} ;


// Prototypes ---------------------------------------------------------------

class twindow
{
   char    huge *winunder ;     // Ptr to buffer to saved screen under window
   char    huge *winrshadow ;       // Ptr to buffer to saved right of window
   char    huge *winrshadowd ;             // Ptr to buffer with right shadow
   char    huge *winbshadow ;       // Ptr to buffer to save bottom of window
   char    huge *winbshadowd ;            // Ptr to buffer with bottom shadow
   char    huge *winfront ;       // Ptr to save window's content when hidden
   char    huge *wintitle ;                          // Ptr to window's title
   int          winhlpctx ;         // Window's context sensitive help number
   twindow huge *winnext ;                             // Next window in link
   twindow huge *winprevious ;                     // Previous window in link
   int          winrow ;                // Window's position (topleft corner)
   int          wincol ;                // Window's position (topleft corner)
   int          winheight ;                        // Window's height in rows
   int          winwidth ;                       // Window's width in columns
   int          winbackcolor ;                   // Window's background color
   int          winforecolor ;                   // Window's foreground color
   int          wincurrow ;                    // Cursor's position in window
   bool         winmovable ;                     // TRUE: Window can be moved
   int          winstatus ;                       // 0:closed 1:open 2:hidden

               // The following attributes apply to all existing input fields

   int          dfieldbackcolor ;         // Default field's background color
   int          dfieldforecoloron ;       // Default field's foreground color
   int          dfieldforecoloroff ;
   int          fieldcount ;                // Number of input fields created
   tfield  huge *fieldfirst ;                          // First field in link
   tfield  huge *fieldlast ;                            // Last field in link

                    // The following attributes apply to all existing buttons

   int          buttonbackcolor ;                // Buttons' background color
   int          buttonforecoloron ;       // Active buttons' foreground color
   int          buttonforecoloroff ;    // Inactive buttons' foreground color
   int          buttonhighcolor ;                 // Button's highlight color
   tbutton huge *buttonfirst ;                        // First button in link
   tbutton huge *buttonlast ;                          // Last button in link

   int          screenheight ;                        // Current screenheight
   int          screenwidth ;                          // Current screenwidth


   public:

far twindow () ;                                               // Constructor

far ~twindow () ;                                               // Destructor

void far twindow::winsetpos                  // Sets window's screen position
(
   int  row,                                         // Top left corner's row
   int  col,                                         // Top left corner's col
   bool movable=EV_MAYBE  // TRUE: Window can be moved.  Default is no change
) ;

int far twindow::wingetrow () ;                   // Returns window's row pos

int far twindow::wingetcol () ;                   // Returns window's col pos

void far twindow::winsetsize                            // Sets window's size
(
   int height=MAXINT,                     // Window's height including frames
   int width=MAXINT                        // Window's width including frames
) ;

int far twindow::wingetheight () ;                 // Returns window's height

int far twindow::wingetwidth () ;                   // Returns window's width

void far twindow::winsetcolors                        // Sets window's colors
(
   int back=LIGHTGRAY,                           // Window's background color
   int fore=WHITE                                // Window's foreground color
) ;

void far twindow::winsettitle                          // Sets window's title
(
   char huge *title                                  // Ptr to window's title
) ;

void far twindow::winsethlpctx          // Sets general help context's number
(
   int hlpctx=EV_NOHLPCTX                            // Help context's number
) ;

void far twindow::winopen () ;          // Opens window with current settings

void far twindow::winclose () ;                   // Closes and resets window

void far twindow::winclear                        // Clears an area in window
(
   int left=1,                                             // Top left corner
   int top=1,
   int right=MAXINT,                                   // Bottom right corner
   int bottom=MAXINT
) ;

void far twindow::winwrite                           // Writes text to window
(
   char huge *text,                              // Ptr to text to be written
   int  row=EV_DEF,                              // Text's position in window
   int  col=1,
   int  format=0,          // Justification  0:none 1:left 2:centered 3:right
   int  fore=EV_DEF,                                          // Text's color
   int  back=EV_DEF
) ;

void far twindow::wintext                 // Displays text with word wrapping
(
   char huge *textptr,                         // Ptr to text to be displayed
   int       fore=EV_DEF,                   // Text's normal foreground color
   int       high=YELLOW                            // Text's highlight color
) ;

void far twindow::wintextfile                         // Displays a text file
(
   char huge *path,                                           // Path to file
   int       fore=EV_DEF,                          // Foreground color to use
   int       high=YELLOW                            // Highlight color to use
) ;

void far twindow::winmove                     // Moves window to new position
(
   int row,                                  // Topleft corner's new position
   int col
) ;

void far twindow::winscroll                      // Moves window 1 space only
(
   char direction                        // U: up  D: down  L: left  R: right
) ;

bool far twindow::winonedges       // Checks if position is on window's edges
(
   int      row,                                                  // Position
   int      col,
   int huge *offsetrow=NULL,            // Offset to window's top left corner
   int huge *offsetcol=NULL
) ;

bool far twindow::wininside         // Checks if position is in window's area
(
   int      row,                                                  // Position
   int      col,
   int huge *offsetrow=NULL,            // Offset to window's top left corner
   int huge *offsetcol=NULL
) ;

input_info far twindow::wininput // Gets input from window fields and buttons
(
   input_info ii                                         // input_info struct
) ;

void far twindow::fieldsetcolors                       // Sets fields' colors
(
   int back=BLUE,                                 // Fields' background color
   int foreon=WHITE,                  // Fields' foreground color when active
   int foreoff=LIGHTCYAN            // Fields' foreground color when inactive
) ;

void far twindow::fieldcreate                       // Creates an input field
(
   int       row,                                        // Input field's row
   int       col,                                        // Input field's col
   int       answerlength,                         // Answers' maximum length
   int       length,                        // Input field's length in window
   int       ftr,                        // Input field's filter number (0-4)
   char huge *xtraftr,                      // Extra chars to use with filter
   bool      capsflag,         // If TRUE, all input is switched to uppercase
   bool      nullflag,                    // If TRUE, can enter a null string
   char huge *defaultasw,                                   // Default answer
   char huge *sltext,                       // Statusline text for this field
   int       hlpctx=EV_NOHLPCTX                        // Help context number
) ;

void far twindow::fieldsetasw               // Sets default answer in a field
(
   char huge *answer,                        // Default answer for this field
   int       fieldnb                                     // Field's ID number
) ;

void far twindow::fieldgetasw                        // Gets a field's answer
(
   char huge *dest,                        // Destination to copy answer's to
   int       fieldnb                                     // Field's ID number
) ;

input_info far twindow::fieldinput               // Gets input from one field
(
   int fieldnb                           // Field's number, to get input from
) ;

void far twindow::buttonsetcolors                    // Sets buttons's colors
(
   int back=GREEN,                               // Button's background color
   int foreon=WHITE,                 // Button's foreground color when active
   int foreoff=BLACK,              // Button's foreground color when inactive
   int high=YELLOW                       // Button's highlight color (hotkey)
) ;

void far twindow::buttoncreate               // Creates and displays a button
(
   int       row,                                             // Button's row
   int       col,                                             // Button's col
   char huge *name,                                          // Button's name
   int       buttonkey,                                    // Button's hotkey
   char huge *sltext=NULL,             // Button's associated statusline text
   int       hlpctx=EV_NOHLPCTX                        // Help context number
) ;

void far twindow::buttonsetavail        // Sets availability flag of a button
(
   int  buttonkey,                                         // Button's hotkey
   bool available=TRUE               // TRUE: available  FALSE: not available
) ;

input_info far twindow::buttoninput        // Waits for a button to be pushed
(
   input_info userinput,                              // User's initial input
   bool       first=TRUE                      // TRUE: Makes 1st button alive
) ;


private:

void far twindow::winreset () ;                 // Resets window's attributes

void twindow::winsavescreen () ; // Saves screen under window and its shadows

void far twindow::winrestorescreen () ;// Restores scr & shadows under window

void twindow::winhide () ;                        // Temporarily hides window

void twindow::winunhide () ;                               // Unhides windows

tbutton huge* twindow::buttonexist            // Checks if this button exists
(
   int buttonkey                                              // Button's key
) ;

void far twindow::buttondraw                                // Draws a button
(
   int  buttonkey,                                         // Button's hotkey
   bool alive=FALSE,                         // TRUE: Alive  FALSE: Not Alive
   bool pushed=FALSE                        // TRUE: Pushed FALSE: Normal pos
) ;

void far twindow::buttondrawall () ;               // Redraws all the buttons

void far twindow::buttonpush                     // Pushes one of the buttons
(
   int buttonkey                                           // Button's hotkey
) ;

} ;


// End Header File ----------------------------------------------------------

#endif
