#if !defined (TIMEFCTS)           /* Prevents multiple declarations errors */
#define TIMEFCTS

/*
   Module        : TIMEFCTS.H
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Rmy Gendron

   Description   : Time related functions.
*/


/* Macros ---------------------------------------------------------------- */

#include "stdmacro.h"


/* Typedefs -------------------------------------------------------------- */

#include "stdtype.h"


/* Prototypes ------------------------------------------------------------ */

#ifdef __cplusplus                     /* Enables linking with C++ modules */
extern "C" {
#endif

void far ticktimer_install (void) ;          /* Installs/De-installs timer */

void far ticktimer_reset (void) ;                   /* Resets tick counter */

dword far ticktimer_read (void) ;            /* Returns current tick count */

dword far diffdate            /* Computes number of days between two dates */
(
   int day1,                                      /* 1st date: day  (1-31) */
   int month1,                                   /* 1st date: month (1-12) */
   int year1,                                     /* 1st date: year (xxxx) */
   int day2,                                      /* 2nd date: day  (1-31) */
   int month2,                                   /* 2nd date: month (1-12) */
   int year2                                      /* 2nd date: year (xxxx) */
) ;


#ifdef __cplusplus
}
#endif


/* End Source File ------------------------------------------------------- */

#endif
