#if !defined (STDFCTS)            /* Prevents multiple declarations errors */
#define STDFCTS


/*
   Module        : STDFCTS.H
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Rmy Gendron

   Description   : General purpose, often used functions.
*/


/* Macros ---------------------------------------------------------------- */

#include "stdmacro.h"


/* TypeDefs -------------------------------------------------------------- */

#include "stdtype.h"


/* Global Variables References ------------------------------------------- */

extern char huge *msg_stderr[] ;             /* Error messages definitions */
extern bool assert_err ;              /* TRUE if assert terminated program */


/* Prototypes ------------------------------------------------------------ */

#ifdef __cplusplus                     /* Enables linking with C++ modules */
extern "C" {
#endif

void far assert                                  /* Validates an assertion */
(
   bool             condition,         /* If FALSE, prg will be terminated */
   char       huge *fctname,       /* Name of currently executing function */
   const char huge *errortext,                            /* Error message */
   int              exitcode                    /* Dos ErrorLevel for exit */
) ;

int far arg_exist                    /* Checks for a command line argument */
(
   char huge *string                             /* Argument to search for */
) ;

int far arg_iexist  /* Case insensitive checks for a command line argument */
(
   char huge *string                             /* Argument to search for */
) ;

void huge * far heapalloc                       /* Allocates from far heap */
(
   dword nbytes                          /* Asks for a block <nbytes> long */
) ;

void far heapfree                     /* Deallocates a block from far heap */
(
   void huge *block                                /* Ptr to block to free */
) ;

int far to_upper               /* Converts a lowercase letter to uppercase */
(
   int ch                                     /* Character to be converted */
) ;

int far to_lower              /* Converts an uppercase letter to lowercase */
(
   int ch                                     /* Character to be converted */
) ;


#ifdef __cplusplus
}
#endif


/* End Source File ------------------------------------------------------- */

#endif
