/*
   Module        : TDISK.CPP
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : tdisk's member functions.
*/


// Headers ------------------------------------------------------------------

#include <conio.h>                                      // System's libraries
#include <dos.h>
#include <stdio.h>
#pragma hdrstop

#include "main.hpp"                                          // Other modules
#include "stdfcts.h"

#include "tdisk.hpp"                             // This module's header file


// --------------------------------------------------------------------------

tdisk::tdisk                                                   // Constructor
(
   int           did,                                            // Disk's id
   int           drow,                             // Initial disk's position
   int           dcol,
   twindow huge *twinptr                                // Ptr to work window
)

{
   assert ( (did>0)&&(did<11),"tdisk::tdisk","Invalid disk's id",1) ;

   id = did ;                                     // Initialises disk's infos
   row = drow ;
   col = dcol ;
   winptr = twinptr ;

   switch (id)                                           // Chooses its color
   {
      case 1 : color = BLUE ; break ;
      case 2 : color = GREEN ; break ;
      case 3 : color = CYAN ; break ;
      case 4 : color = RED ; break ;
      case 5 : color = MAGENTA ; break ;
      case 6 : color = LIGHTBLUE ; break ;
      case 7 : color = LIGHTGREEN ; break ;
      case 8 : color = LIGHTCYAN ; break ;
      case 9 : color = LIGHTMAGENTA ; break ;
      case 10: color = YELLOW ; break ;
   }


   return ;                                      // Disk has been initialised
}                                                          // End constructor


// --------------------------------------------------------------------------

tdisk::~tdisk ()                                                // Destructor

{
   return ;                                                  // Nothing to do
}                                                           // End Destructor


// --------------------------------------------------------------------------

void tdisk::show ()                      // Displays disk at current position

{
   switch (id)
   {
      case 1 : winptr->winwrite (" ۲ ",row,col-1,0,color) ;
               break ;
      case 2 : winptr->winwrite (" ۲ ",row,col,0,color) ;
               break ;
      case 3 : winptr->winwrite ("  ۲  ",row,col,0,color) ;
               break ;
      case 4 : winptr->winwrite ("   ۲   ",row,col,0,color) ;
               break ;
      case 5 : winptr->winwrite ("    ۲    ",row,col,0,color) ;
               break ;
      case 6 : winptr->winwrite ("     ۲     ",row,col,0,color) ;
               break ;
      case 7 : winptr->winwrite ("            ",row,col,0,color) ;
               break ;
      case 8 : winptr->winwrite ("              ",row,col,0,color) ;
               break ;
      case 9 : winptr->winwrite ("                ",row,col,0,color) ;
               break ;
      case 10: winptr->winwrite ("                  ",row,col,0,color) ;
               break ;
   }


   return ;                                        // Disk has been displayed
}                                                                 // End show


// --------------------------------------------------------------------------

void tdisk::erase                        // Erases disk from current position
(
   int towercolor                                            // Tower's color
)

{
   if (row >= 5)
      winptr->winwrite ("                    ",row,col,0,towercolor) ;
   else
      winptr->winwrite ("                      ",row,col) ;


   return ;                                           // Disk has been erased
}                                                                // End erase


// --------------------------------------------------------------------------

void tdisk::moveto                     // Moves disk from on tower to another
(
   int target_row,                                         // Destination row
   int target_col,                                         // Destination col
   int source_color,                                  // Source tower's color
   int target_color,                             // Destination tower's color
   int speed                                             // Animation's speed
)

{
   while (row > 2)                                           // Moves disk up
   {
      erase (source_color) ;                                   // Erases disk
      row-- ;                                                   // Up one row
      show () ;                                              // Displays disk
      delay (4 * (9-speed)) ;
   }

   while (col != target_col)                             // Moves horizontaly
   {
      if (target_col > col) col++ ;                            // Moves right
      else col-- ;                                              // Moves left
      show () ;                                              // Displays disk
      delay (3 * (9-speed)) ;
   }

   while (row < target_row)                                // Moves disk down
   {
      erase (target_color) ;                                   // Erases disk
      row++ ;                                                 // Down one row
      show () ;                                              // Displays disk
      delay (4 * (9-speed)) ;
   }


   return ;                            // Disk has been moved to target tower
}                                                               // End moveto


// End source file ----------------------------------------------------------
