#if !defined (MODULE)                // Prevents multiple declarations errors
#define MODULE


/*
   Module        : MODULE.HPP
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : Functions header file.
*/


// Headers ------------------------------------------------------------------

#include "ttower.hpp"
#include "twindow.hpp"


// Macros -------------------------------------------------------------------

#include "stdmacro.h"                           // Standard macro definitions


// TypeDefs -----------------------------------------------------------------

#include "stdtype.h"                             // Standard type definitions
#include "prjtype.h"                       // This project's type definitions


// Prototypes ---------------------------------------------------------------

#ifdef __cplusplus                        // Enables linking with C++ modules
extern "C" {
#endif

void about () ;                             // Displays infos on this program

config_info configuration                             // Configure the puzzle
(
   config_info config                         // Ptr to configuration's infos
) ;

void animation                                       // Animates the solution
(
   config_info config                           // Configuration informations
) ;

void hanoi                    // Finds solution for the current configuration
(
   int            nb_disks,                        // Number of disks to move
   ttower   huge *source,                                 // Moves from tower
   ttower   huge *target,                                   // Moves to tower
   ttower   huge *temporary,                               // Temporary tower
   twindow  huge *winptr2                             // Ptr to status window
) ;

void pause () ;                                     // Pauses after animation

void anim_input () ;                        // Checks inputs during animation


#ifdef __cplusplus
}
#endif


// End Header File ----------------------------------------------------------

#endif
