' PRIME SIEVE BENCHMARK

DEFINT A-Z  'only 16-bit integers, but runs faster than DEFLNG A-Z

DECLARE FUNCTION sieve()

'Constants
CONST BATCH = 5
CONST BENCHTIME = 15

CONST TRUE = -1
CONST FALSE = NOT TRUE
CONST SIZE = 8191

'Global Variables
DIM SHARED flags(SIZE)

PRINT "prime sieve benchmark ..."

cycles& = 0
t# = TIMER
WHILE TIMER < t# + BENCHTIME
    FOR b = 1 TO BATCH
        IF sieve <> 1899 THEN
	    PRINT "whoops"
	END IF
    NEXT b
    cycles& = cycles& + BATCH
WEND
t# = TIMER - t#
PRINT USING "###.## sieves per second"; cycles& / t#


FUNCTION sieve
    count = 0
    FOR f = 1 TO SIZE
        flags(f) = TRUE
    NEXT f
    FOR i = 1 TO SIZE
        IF flags(i) THEN
            prime = i + i + 1
            'PRINT prime;
	    FOR k = i + prime TO SIZE STEP prime
		flags(k) = FALSE
	    NEXT k
	    count = count + 1
	END IF
    NEXT i
    sieve = count
END FUNCTION

