REM QBasic Array (Sequence) Benchmarks

DEFINT A-Z  ' makes it faster, but integers are only 16-bits

CONST BENCHTIME = 15
CONST SIZE = 100
CONST INITBATCH = 2000
CONST ADDBATCH = 1000
CONST LOOKUPBATCH = 2000
CONST SLICEBATCH = 5
CONST CONCATBATCH = 5
CONST CONCATSIZE = 5000

DIM x(SIZE)
DIM y(SIZE)
DIM z(SIZE)
DIM states$(50)

PRINT
PRINT "                QBasic Array Benchmarks"
PRINT
PRINT "* Initializing a length -"; SIZE; "array ---> ";
cycles& = 0
t# = TIMER
WHILE TIMER < t# + BENCHTIME
    FOR j = 1 TO INITBATCH
	FOR k = 1 TO SIZE 
	    z(k) = 999
	NEXT k
    NEXT j
    cycles& = cycles& + INITBATCH
WEND
t# = TIMER - t#
n = cycles& / t# 
PRINT n; " initializations per second"

PRINT
PRINT "* Adding two length -"; SIZE; "arrays ---> ";

FOR i = 1 TO SIZE
    x(i) = RND(1000)
    y(i) = RND(1000)
NEXT i

cycles& = 0
t# = TIMER
WHILE TIMER < t# + BENCHTIME
    FOR j = 1 TO ADDBATCH
	FOR k = 1 TO SIZE   ' one-at-a-time loop
	    z(k) = x(k) + y(k)
	NEXT k
    NEXT j
    cycles& = cycles& + ADDBATCH
WEND
t# = TIMER - t#
n = cycles& / t# 
PRINT n; " array-adds per second"

PRINT
PRINT "* String concatenation ---> ";

cycles& = 0
t# = TIMER
WHILE TIMER < t# + BENCHTIME
    FOR i = 1 to CONCATBATCH
        S$ = ""
        FOR j = 1 TO CONCATSIZE
	    S$ = S$ + "*"
        NEXT j
    NEXT i
    x& = CONCATBATCH
    x& = x& * CONCATSIZE
    cycles& = cycles& + x&
WEND
t# = TIMER - t#
n = cycles& / t# 
PRINT n; " concatenations per second"

PRINT
PRINT "* Substring selection ---> ";

cycles& = 0
t# = TIMER
WHILE TIMER < t# + BENCHTIME
    FOR i = 1 to SLICEBATCH
	partial$ = s$
	WHILE LEN(partial$) >= 2
	    partial$ = MID$(partial$, 2, LEN(partial$)-2)
	WEND
    NEXT i
    x& = SLICEBATCH
    x& = x& * LEN(s$) / 2
    cycles& = cycles& + x&
WEND
t# = TIMER - t#
n = cycles& / t# 
PRINT n; " substrings per second"

DATA "Kentucky", "Alabama", "California", "Washington", "Ohio", "Texas"
DATA "Nevada", "Florida", "Wyoming", "New York", "Maine", "Massachusetts"
DATA "North Carolina", "South Carolina", "North Dakota", "South Dakota"
DATA "Mississippi", "Arizona", "Hawaii", "Alaska", "Oregon", "Michigan"
DATA "Illinois", "Pennsylvania", "Kansas", "Virginia", "New Mexico" 
DATA "Rhode Island", "New Hampshire", "Delaware", "Tennessee", "Colorado"
DATA "Wisconsin", "Vermont", "Indiana", "Maryland", "Connecticut", "Louisiana"
DATA "Missouri", "Minnesota", "Iowa", "Idaho", "Arkansas", "Montana"
DATA "Nebraska", "Georgia", "West Virginia", "Utah", "New Jersey", "Oklahoma"

FOR i = 1 TO 50
    READ states$(i)
NEXT i

PRINT
PRINT "* Name look-up ---> ";
cycles& = 0
t# = TIMER
WHILE TIMER < t# + BENCHTIME  
    FOR j = 1 TO LOOKUPBATCH
	FOR k = 1 TO 50
	    IF states$(k) = "Oklahoma" THEN
		EXIT FOR
	    END IF
	NEXT k
	IF k <> 50 THEN
	    PRINT "whoops!"
	END IF
    NEXT j
    cycles& = cycles& + LOOKUPBATCH
WEND
t# = TIMER - t#
n = cycles& / t# 
PRINT n; " look-ups per second"


