/* Convert Quicken ascii text to E-Teller format

   Does not take into account non-transaction information
   so be sure to delete all unnecessary info. first
*/

parse arg arg1 arg2
if arg1 = '' then
   signal error
if arg2 = '' then
   signal error

ClearFile = arg2||'.clr'
File = arg2||'.ldg'

if( stream( arg1, 'c', 'query exists' ) = '' )then do
   say ''
   say 'File 'arg1' does not exist.'
   exit
end
if( stream( ClearFile, 'c', 'query exists' ) = '' )then do
   say 'Account file 'arg2'.clr does not exist.'
   say ''
   say 'You must first create an account file in E-Teller'
   say 'and use the actual filename (without extension) as'
   say 'the second argument to Q2ET.cmd, '
   say ''
   say '    e.g. q2et e:\quicken\quicken.txt d:\e-teller\account'
   say ''
   exit
end
ok = 1
call linein arg, 1, 0
ok = 1
do until ok = 0
   value = linein( arg1 )
   date = SubStr( value, 1, 9 )        /* get date */
   value = DelStr( value, 1, 9 )
   date = Strip( date, 'T' )
   date = Translate( date, '0', ' ' )
   parse var date one '/' two '/' three
   date = three'/'one'/'two

   number = SubStr( value, 1, 3 )      /* get number */
   if number = '' then do
      number = ''
      value = Strip( value, 'L' )
   end
   if number <> '' then do
      parse var value number.
      length = Length( number )
      value = DelStr( value, 1, length )
      value = Strip( value, 'L' )
   end

   pos = Pos( '     ', value )      /* get info */
   info = SubStr( value, 1, pos )
   length = Length( info )
   value = DelStr( value, 1, length )
   value = Strip( value, 'L' )

   pos = Pos( '     ', value )      /* get memo */
   memo = SubStr( value, 1, pos )
   length = Length( memo )
   value = DelStr( value, 1, length )
   value = Strip( value, 'L' )

   pos = Pos( '     ', value )      /* get category */
   if pos <> 0 then do
      cat = SubStr( value, 1, pos )
      length = Length( cat )
      value = DelStr( value, 1, length )
      value = Strip( value, 'L' )
   end
   if pos = 0 then
      cat = ''

   parse var value amount clear .
   length = Length( clear )         /* ensure that clear is not an amount */
   if length > 1 then
      clear = ''

   if clear <> '' then do            /* write information to file */
      call lineout ClearFile, date
      call lineout ClearFile, number
      call lineout ClearFile, info
      call lineout ClearFile, amount
      call lineout ClearFile, memo
      call lineout ClearFile, cat
      call lineout ClearFile, '----------'
   end
   if clear = '' then do
      call lineout File, date
      call lineout File, number
      call lineout File, info
      call lineout File, amount
      call lineout File, memo
      call lineout File, cat
      call lineout File, '----------'
   end
   ok = lines( arg1 )
end
call stream arg1, 'c', 'close'
call stream File, 'c', 'close'
call stream ClearFile, 'c', 'close'
say ''
say 'Conversion complete.'
exit

Error:
say ''
say 'SYNTAX:  Q2ET quicken.txt account'
exit
