/* Convert E-Teller file format from 1.x to 1.4

   To run, enter filename as parameter  or drag
    a valid account.ini on to 'fixacct.cmd'
*/

'@echo off'
parse arg arg
if arg = '' then
   signal Error
parse var arg file '.' ext
if ext = '' then
   arg = file||'.ini'

if Pos( 'ET_FIX', arg ) <> 0 then
   signal Error

if Pos( 'ET_FIXED', arg ) <> 0 then
   signal Error

if Pos( 'E-TELLER', arg ) <> 0 then
   signal Error

ClrFile = file||'.clr'
UnClrFile = file||'.ldg'
LineAdded = 0

if RxFuncQuery( 'SysIni' )then do
    call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'
end

/* Get Account Information */
Account = SysIni( arg, 'Main', 'Account' )
Number = SysIni( arg, 'Main', 'AccountNumber' )
Balance = SysIni( arg, 'Main', 'StartingBalance' )
Type = SysIni( arg, 'Main', 'Type' )
Date = SysIni( arg, 'Main', 'Date' )
Cleared = SysIni( arg, Account, 'Cleared' )
Uncleared = SysIni( arg, Account, 'Uncleared' )
ClrBalance = SysIni( arg, Account, 'ClearedBalance' )
if Type = 'CreditCard' then
   ClrBalance = Strip( ClrBalance, 'L', '-' )


/* Write Account information to the cleared *.CLR file */
call lineout ClrFile, '[Account]'
call lineout ClrFile, 'Account='||Account
call lineout ClrFile, 'Number='||Number
call lineout ClrFile, 'StartingBalance='||Balance
call lineout ClrFile, 'Type='||Type
call lineout ClrFile, 'Date='||Date
call lineout ClrFile, 'ClearedBalance='||ClrBalance
call lineout ClrFile, ''
call lineout ClrFile, '[Cleared]'

InitPos = 1
do until EndPos = 0
    call vrset 'Window1', 'StatusText', 'Reading...'
    EndPos = Pos( '0d0a'x, cleared, InitPos )
    if EndPos = 0 then
            leave
    substring  = SubStr( cleared, InitPos, EndPos )
        parse var substring date '","' number '","' info '","' credit '","' debit '","' memo '"' .
        date = Strip( date, 'l', '"' )
        memo = Strip( memo, 't', '"' )
   call lineout ClrFile, date
   call lineout ClrFile, number
   call lineout ClrFile, info
   if credit <> '' then do
      if credit >= 1 then do
         call lineout ClrFile, credit
         LineAdded = 1
      end
   end
   if debit <> '' then do
      if debit >= 1 then do
         call lineout ClrFile, '-'||debit
         LineAdded = 1
      end
   end
   if LineAdded = 0 then
      call lineout ClrFile, '0.00'
   LineAdded = 0
   call lineout ClrFile, memo
   call lineout ClrFile, ''     /* used for the new category entry */
   call lineout ClrFile, '----------'
    InitPos = EndPos + 2
end
call lineout ClrFile

InitPos = 1
do until EndPos = 0
    call vrset 'Window1', 'StatusText', 'Reading...'
    EndPos = Pos( '0d0a'x, Uncleared, InitPos )
    if EndPos = 0 then
            leave
    substring  = SubStr( Uncleared, InitPos, EndPos )
        parse var substring date '","' number '","' info '","' credit '","' debit '","' memo '"' .
        date = Strip( date, 'l', '"' )
        memo = Strip( memo, 't', '"' )
   call lineout UnClrFile, date
   call lineout UnClrFile, number
   call lineout UnClrFile, info
   if credit <> '' then do
      if credit >= 1 then do
         call lineout UnClrFile, credit
         LineAdded = 1
      end
   end
   if debit <> '' then do
      if debit >= 1 then do
         call lineout UnClrFile, '-'||debit
         LineAdded = 1
      end
   end
   if LineAdded = 0 then
      call lineout UnClrFile, '0.00'
   LineAdded = 0
   call lineout UnClrFile, memo
   call lineout UnClrFile, ''   /* used for the new category entry */
   call lineout UnClrFile, '----------'
    InitPos = EndPos + 2
end
call lineout UnClrFile
say ''
say 'File conversion complete.'
say 'Before deleting the ini, ensure that the data contained'
say 'in the new '
say '     'ClrFile
say ' and '
say '     'UnClrFile
say ' is complete and accurate.'
say ''
exit

Error:
say ''
say 'Syntax:'
say '       FIXACCT account[.ini]'
say ''
say 'To convert ET_Fix or ET_Fixed, use the fix_fix.cmd rexx script.'
say 'To convert Quicken ascii files, use the q2et.cmd rexx script.'
exit
