#include "ERROR.CH"
#include "SET.CH"
#include "SIXCDX.CH"
* --------------------------------------------------------------------------
*  Description: Use this function as a replacement for ErrorSys(), errors
*             : are written to the file ERROR.LOG for after-the-fact
*             : reference.
*  Syntax.....: ErrorBlock( {|oErr| Error501( oErr, cExeName )} )
*  Parameters.: oErr     = Error Object (passed by Clipper)
*             : cExeName = Name of the Executible (your exe name)
* --------------------------------------------------------------------------
* Pseudo-Functions to Center text, Get User Name, Date and YOUR library ver
* --------------------------------------------------------------------------
#xcommand DEFAULT <uVar1> TO <uVal1> ;
               [, <uVarN> TO <uValN> ] => ;
                  <uVar1> := IF( ValType( <uVar1> ) == ValType( <uVal1> ), ;
                                 <uVar1>, <uVal1> ) ;;
                [ <uVarN> := IF( ValType( <uVarN> ) == ValType( <uValN> ), ;
                                 <uVarN>, <uValN> ); ]

#define Center( nRow, cText)  @nRow, Int(80 - Len(cText)) / 2 SAY cText

// The Function NetName() is in DBFNTX.LIB - go figure ! 
*#define User()                IF( Empty( NetName()), '(USER1)', '(' + ;
*                              AllTrim( SubStr( NetName(), 1, 8 )) + ')')
#define User()                'NETUSER1'
#define ErrDate()             AllTrim( CMonth( Date())) + ' ' + ;
                              AllTrim( Str( Day( Date()), 2)) + ',' + ;
                              Str(Year( Date()), 5 )
#define LibVer()              'My Lib v1.00  -  ' + Version()
* --------------------------------------------------------------------------
* Function Name.: Error501() --> lRetryDefaultOrQUIT
* Syntax........: ErrorBlock( {|oErr| Error501(oErr, cMyExeName)} )
* Parameter.....: oErr       = Error object
*               : cMyExeName = Optional EXE File name, defaults to ProcName(2)
* Return........: .T. if oErr:canRetry, .F. if oErr:canDefault, else QUIT
* Description...: Replace the default ErrorSys() Error Handler
* Notes.........: By passing the EXE Name, the File Date/Size can be 
*               : retrieved making it easy to check against the lastest ver.
* --------------------------------------------------------------------------
FUNCTION Error501( oErr, cExeName )
MEMVAR aCOMMON
LOCAL cScreen  := SaveScreen( 0, 0, 24, 79 )
LOCAL xRet     := .F.                       // In case oErr:canDefault = .T.
LOCAL cColor   := SetColor()                // In case we go back
LOCAL nCursor  := SetCursor( 0 )            // In case we go back
LOCAL cCurDev  := Set( _SET_DEVICE )        // In case they are printing
LOCAL nErrLine1:= ProcLine( 2 )             // Line the Error occured on
LOCAL nErrLine2:= ProcLine( 3 )             // Func Line that called this Func
LOCAL nErrLine3:= ProcLine( 4 )             // Line that called Line that ...
LOCAL cErrProc1:= ProcName( 2 )             // Function Error occured in
LOCAL cErrProc2:= ProcName( 3 )             // Function that called this Func
LOCAL cErrProc3:= ProcName( 4 )             // Func that called Func that ...
LOCAL aDOSErr  := DosErr()                  // Retrieve DOS Error Desc Array
LOCAL cFile    := IF(Empty(oErr:fileName),;
                  IF(Empty(Alias()), '', ;
                  'Area '+ Ltrim(Str(Select())) + ' - ' + Alias()) ,;
                  oErr:fileName)

LOCAL cSubSys  := oErr:subSystem            // BASE or other System Name
LOCAL cSubCode := LTrim(Str(oErr:subCode))  // Sub System Code
LOCAL cErrScrn                              // If QUIT leave Error Msg on Scrn
LOCAL cArg1, cArg2, cArg3                   // First 3 oErr:args Array Elemnts
LOCAL cLine24  := 'ERROR RECOVERY IS '+ ;
                  IF( oErr:canDefault .OR. ; // Can we Default
                      oErr:canRetry .OR.   ; // Can we Retry
                      oErr:canSubstitute,  ; // Can we Substitute
                  'POSSIBLE    <Enter>=Retry, <Esc>=Cancel, <P>=Print Error',;
                  'NOT POSSIBLE    <Esc>=Cancel, <P>=Print Error' )
LOCAL nHandle                                // Dos File Handle for Log File
LOCAL cErrStr := ''                          // Error string for FWrite()
LOCAL cCRLF    := Chr( 13 ) + Chr( 10 )      // For the Error Log File
LOCAL nKey     := 0

DEFAULT cExeName TO 'UNKNOWN.EXE'
SetColor( 'W+/N' )

AltD( 1 )                                    // Turn Debugger
ErrorBlock( {|oErr| Err501Err(oErr)})        // Error501() Error Handler
Tone(100, 1)                                 // Sound Warning Tone

SET DEVICE TO SCREEN
SET CONSOLE OFF

/* Display the Screen */
DispEnd()                                    // In case we're in the middle

SET COLOR TO
CLS
SetColor( IF(IsColor(), 'N/BG', 'N/W' ))

DispBox( 0, 0, 3, 79, 2 )                    // Heading Box
Scroll( 1, 1, 2, 78 )
Scroll( 24, 0 )
Center( 1, '- ERROR INFORMATION -' )         // Display Title
Center( 2, LibVer() )                        // Display Your Lib Version
Center( 24, cLine24 )                        // Line 24

SetColor( 'GR+/N' )
Center( 5, 'ERROR CONDITION: ' + AllTrim(Str( oErr:genCode )) + ' - ' + ;
            AllTrim( oErr:description ) + IF( oErr:genCode == 11, ;
            ' (Free: ' + Ltrim(Str(Memory(0))) + ;
            '  Block: ' + Ltrim(Str(Memory(1))) + ')',''))

SetColor( 'W+/N' )
DispBox( 4, 0, 9, 79 )                       // Instructions Box
DispBox( 10, 0, 23, 79 )                     // Status Detail Box
@6, 0 SAY ' PROCEDURE ' + Replicate('', 66) + ''
@ 7, 2 SAY ' 1. Write down the Information shown in the STATUS box below.'
@ 8, 2 SAY ' 2. Write down the events that led up to this error.'

@10, 2 SAY ' ERROR STATUS '


/* Validate cExeName */
IF ValType( cExeName ) <> 'C'               // Didn't Pass cExeName
   cExeName := cErrProc1                    // Default to ProcName(2)
ELSE
   IF File( cExeName )                      // Find the Exe we're in
      cExeName += '  '+FileInfo( cExeName ) // Retrieve the Exe's Date/Size
   ENDIF
ENDIF

IF oErr:args <> NIL                         // Arguments exist
   cArg1 := ErrStr( oErr:args[1] )          // Must be one
   cArg2 := IF( Len( oErr:args ) > 1, ErrStr( oErr:args[2] ), '')
   cArg3 := IF( Len( oErr:args ) > 2, ErrStr( oErr:args[3] ), '') + ;
            IF( Len( oErr:args ) > 3, '....', '')

ELSE
   cArg1 := cArg2 := cArg3 := ''
ENDIF

/* Display the Error Status Information */
@11,  2 SAY ' Program Name   : ' + cExeName
@12,  2 SAY ' Function Name  : ' + cErrProc1
@13,  2 SAY ' Function Line  : ' + LTrim(Str( nErrLine1 ))
@14,  2 SAY ' SubSystem Code : ' + cSubSys + '/' + cSubCode
@15,  2 SAY ' Operation      : ' + oErr:operation
@16,  2 SAY ' Argument 1     : ' + cArg1
@17,  2 SAY ' Argument 2     : ' + cArg2
@18,  2 SAY ' Argument 3     : ' + cArg3
@19,  2 SAY ' DOS Error Code : ' + IF(oErr:osCode<>0,LTrim(Str(oErr:osCode))+;
                                   ' - ' + aDOSErr[oErr:osCode],'')
@20,  2 SAY ' DOS File Name  : ' + cFile
@21,  2 SAY '                  '
@22,  2 SAY ' Date/Time/User : ' + ErrDate() + '  '+AmPm(Time())+'  '+User()

IF !Empty( cErrProc2 )                      // Function that called Bunk Func
   @13, 32 SAY '- ' + cErrProc2 + '(' + LTrim(Str( nErrLine2 )) + ')' +;
   IF( !Empty( cErrProc3 ), ' - ' + cErrProc3 + '(' + ;
   LTrim(Str( nErrLine3 )) + ')', '')
ENDIF

/********************* Write to the Error Log File ************************/
IF File( 'ERROR.LOG' )                    // Look for the Error Log File
   nHandle := FOpen( 'ERROR.LOG', 2)      // Open the Error Log File
   FSeek( nHandle, 0, 2)                  // Position at End of File
ELSE                                      // Doesn't Exist
   nHandle := FCreate( 'ERROR.LOG' )      // Create the Error Log File
ENDIF

IF nHandle > 0                            // An FError Returns -1
   /* Build the Error String */
   cErrStr := ;
   ' Program Name    : ' + cExeName                               + cCRLF +;
   ' Error Condition : ' + AllTrim(Str( oErr:genCode )) + ' - ' + ;
                           AllTrim( oErr:description ) + ;
                           IF( oErr:genCode == 11, ;
                           '  (Free: ' + Ltrim(Str(Memory(0))) + ;
                           '  Block: ' +Ltrim(Str(Memory(1)))+')','')+cCRLF +;
   ' Error Date      : ' + ErrDate()+'  '+AmPm(Time())+'  '+User()+ cCRLF +;
   ' Function Name   : ' + cErrProc1                              + ;
                           IF(!Empty(cErrProc2), ' <-- ' + cErrProc2 + '(' +;
                           LTrim(Str(nErrLine2)) + ')', '') +;
                           IF(!Empty(cErrProc3), ' <-- ' + cErrProc3 + '(' +;
                           LTrim(Str(nErrLine3)) + ')', '')       + cCRLF +;
   ' Function Line   : ' + LTrim(Str( nErrLine1 ))                + cCRLF +;
   ' Sub System Code : ' + cSubSys + '/' + cSubCode               + cCRLF +;
   ' Operation       : ' + oErr:operation                         + cCRLF +;
   ' Argument 1      : ' + cArg1                                  + cCRLF +;
   ' Argument 2      : ' + cArg2                                  + cCRLF +;
   ' Argument 3      : ' + cArg3                                  + cCRLF +;
   ' DOS Error Code  : ' + IF(oErr:osCode <> 0, LTrim(Str(oErr:osCode)) + ;
                           ' - ' + aDOSErr[oErr:osCode], '' )     + cCRLF +;
   ' DOS File Name   : ' + cFile                                  + cCRLF +;
   ' Library Version : ' + LibVer()+cCRLF+' '+Replicate('=', 78)+ cCRLF
   
   FWrite( nHandle, cErrStr, Len(cErrStr) )
   FClose( nHandle )
ENDIF

/* See what the User wants to do */
DO WHILE .T.
   nKey := InKey( 0 )

   IF Upper( Chr( nKey )) == 'P'       // Send Error Info to Printer
      IF IsPrinter()
         @24, 0 SAY PadC('* Printing Error Information *', 80) COLOR '*N/W'
         SET DEVICE TO PRINT
         SET PRINT TO LPT1
         SET PRINT ON
         QOut( PadC( 'ERROR INFORMATION  -  ' + ErrDate(), 80))
         QOut( PadC( AllTrim( Str( oErr:genCode )) + ' - ' + ;
                     AllTrim( oErr:description ), 80))
         QOut( PadC( Replicate( '=', 78 ), 80))
         QOut( cErrStr )
         EJECT
         SET PRINT OFF
         SET DEVICE TO SCREEN
         @24, 0 SAY PadC(cLine24, 80) COLOR 'N/BG' // Line 24
      ELSE                                         // Printer Not Listening
         Tone(100, 1)
         @24, 0 SAY PadC( '* Printer Not Available *', 80 ) COLOR '*N/W'
         InKey( 3 )
         @24, 0 SAY PadC( cLine24, 80 ) COLOR 'N/BG' // Line 24
      ENDIF
   ELSEIF nKey == 27 .OR. nKey == -49
      cErrScrn := SaveScreen( 10, 0, 23, 79 )
      SET COLOR TO
      Scroll( 0, 0, 24, 79 )
      RestScreen( 1, 0, 14, 79, cErrScrn )
      @1, 2 SAY ' Error Condition: ' + ;
                AllTrim(Str( oErr:genCode )) + ' - ' + ;
                AllTrim( oErr:description ) + ;
                IF( oErr:genCode == 11, ;
                     '  (Free: ' + Ltrim(Str(Memory(0))) + ;
                     '  Block: ' +Ltrim(Str(Memory(1)))+')','') + ' ' ;
                     COLOR 'GR+/N'
      @16, 0 
      CLOSE DATABASES
      SET CURSOR ON
      QUIT
   ELSEIF nKey == 13 .OR. nKey == -51  // Wants to keep going
      RestScreen( 0, 0, 24, 79, cScreen )
      IF     oErr:canDefault           // Try to Default
         xRet := .F.
      ELSEIF oErr:canRetry             // Try to Retry
         xRet := .T.
      ELSE                             // If we can't Substitute, Quit
         IF !oErr:canSubstitute
            cErrScrn := SaveScreen( 10, 0, 23, 79 )
            CLS
            RestScreen( 1, 0, 14, 79, cErrScrn )
            @1, 2 SAY ' Error Condition: ' + ;
                      AllTrim(Str( oErr:genCode )) + ' - ' + ;
                      AllTrim( oErr:description ) + ;
                     IF( oErr:genCode == 11, ;
                           '  (Free: ' + Ltrim(Str(Memory(0))) + ;
                           '  Block: ' +Ltrim(Str(Memory(1)))+')','') + ' ' ;
                           COLOR 'GR+/N'
            @16, 0 
            CLOSE DATABASES
            SET COLOR TO
            SET CURSOR ON
            QUIT
         ELSE                          // Send back substituted data
            //  Default Division by 0 or Number to big to zero
	         IF oErr:genCode == EG_ZERODIV .OR. ;
		         oErr:genCode == EG_NUMOVERFLOW .OR. ;
               oErr:genCode == EG_DATAWIDTH
               xRet := 0
            ENDIF
         ENDIF
      ENDIF
      ErrorBlock( {|oErr| Error501( oErr, cExeName )} ) // My Error Handler
      EXIT
   ENDIF
ENDDO
SetColor( cColor )
SetCursor( nCursor )
Set( _SET_DEVICE, cCurDev )
Return( xRet )
* --------------------------------------------------------------------------
* Function Name.: DosErr() --> aT1DosErrorArray
* Syntax........: aT1DosErr := DosErr()
* Parameter.....: NONE
* Return........: Array [88] of Dos Error Descriptions
* Description...: oErr:osCode Descriptions for Error()
* --------------------------------------------------------------------------
FUNCTION DosErr()
LOCAL aErr[88]

/* Establish the DOS Error Array */
aErr[01] := "Invalid Function Number"
aErr[02] := "File Not Found"
aErr[03] := "Path Not Found"
aErr[04] := "Too Many Files Open"
aErr[05] := "Access Denied"
aErr[06] := "Invalid Handle"
aErr[07] := "Memory Control Blocks Destroyed"
aErr[08] := "Insufficient Memory"
aErr[09] := "Invalid Memory Block Address"
aErr[10] := "Invalid Environment Size Specified"
aErr[11] := "Invalid Format File"
aErr[12] := "Invalid Access Code"
aErr[13] := "Invalid Data"
aErr[14] := "<14 - Reserved>"
aErr[15] := "Invalid Drive Specified"
aErr[16] := "Cannot Remove Current Directory"
aErr[17] := "Not Same Device"
aErr[18] := "No More Files"
aErr[19] := "Attempted Write Protect Violation"
aErr[20] := "Bad Unit (Bummer)"
aErr[21] := "Drive Not Ready"
aErr[22] := "Bad Command"
aErr[23] := "Data CRC Error"
aErr[24] := "Bad Request Structure Length"
aErr[25] := "Seek Error"
aErr[26] := "Unknown Media Type"
aErr[27] := "Sector Not Found"
aErr[28] := "No Paper"
aErr[29] := "Write Fault"
aErr[30] := "Read Fault"
aErr[31] := "General Failure"
aErr[32] := "Sharing Violation"
aErr[33] := "Lock Violation"
aErr[34] := "Invalid Disk Change"
aErr[35] := "FCB Unavailable"
aErr[36] := "Sharing Buffer Overflow"
aErr[37] := "<37 - Reserved>"
aErr[38] := "<38 - Reserved>"
aErr[39] := "<39 - Reserved>"
aErr[40] := "<40 - Reserved>"
aErr[41] := "<41 - Reserved>"
aErr[42] := "<42 - Reserved>"
aErr[43] := "<43 - Reserved>"
aErr[44] := "<44 - Reserved>"
aErr[45] := "<45 - Reserved>"
aErr[46] := "<46 - Reserved>"
aErr[47] := "<47 - Reserved>"
aErr[48] := "<48 - Reserved>"
aErr[49] := "<49 - Reserved>"
aErr[50] := "Network Request Not Supported"
aErr[51] := "Requested Device Not Listening"
aErr[52] := "Duplicate Name On Network"
aErr[53] := "Network Name Not Found"
aErr[54] := "Network Busy"
aErr[55] := "Network Device No Longer Exists"
aErr[56] := "Network BIOS Command Limit Exceeded"
aErr[57] := "Network Adapter Hardware Error"
aErr[58] := "Incorrect Response From Network"
aErr[59] := "Unexpected Network Error"
aErr[60] := "Incompatible Remoter Adapter"
aErr[61] := "Print Queue Full"
aErr[62] := "Not Enough Space For Print File"
aErr[63] := "Print File Deleted"
aErr[64] := "Network Name Deleted"
aErr[65] := "Network Access Denied"
aErr[66] := "Network Device Type Incorrect"
aErr[67] := "Network Name Not Found"
aErr[68] := "Network Name Limit Exceeded"
aErr[69] := "Network BIOS Session Limit Exceeded"
aErr[70] := "Temporarily Paused"
aErr[71] := "Network Request Not Accepted"
aErr[72] := "Print Or Disk Redirection Paused"
aErr[73] := "<73 - Reserved>"
aErr[74] := "<74 - Reserved>"
aErr[75] := "<75 - Reserved>"
aErr[76] := "<76 - Reserved>"
aErr[77] := "<77 - Reserved>"
aErr[78] := "<78 - Reserved>"
aErr[79] := "<79 - Reserved>"
aErr[80] := "Duplicate File Name Or File Not Found"
aErr[81] := "<81 - Reserved>"
aErr[82] := "Cannot Make Directory Entry"
aErr[83] := "Fail on INT 24H"
aErr[84] := "Too Many Redirections"
aErr[85] := "Duplicate Redirection"
aErr[86] := "Invalid Password"
aErr[87] := "Invalid Parameter"
aErr[88] := "Network Device Fault"

Return( aErr )
* --------------------------------------------------------------------------
* Function Name.: ErrStr() --> cStringifiedParameter
* Syntax........: ErrStr( xData )
* Parameter.....: xData = Number, Character, Date or Logical Type Data
* Return........: Stringified version of the Parameter Passed plus a 1 Chr
*               : Data Type Id inclosed in parenthesis.
* Description...: Converts any data type to a string.
* --------------------------------------------------------------------------
STATIC FUNCTION ErrStr( xData )
LOCAL cSData := ''
LOCAL cType  := ValType(xData)

IF cType <> 'C'
   DO CASE
      CASE cType == 'N'
         cSData := LTrim( Str( xData, 12, 2 ))
      CASE cType == 'D'
         cSData := Dtoc( xData )
      CASE cType == 'L'
         cSData := IF( xData, '.T.' , '.F.')
      CASE cType == 'M'
         cSData := 'Memo'
      CASE cType == 'A'
         cSData := '{....}'
      CASE cType == 'B'
         cSData := '{|| ... }'
      CASE cType == 'U'
         cSData := 'NIL'
      CASE cType == 'O'
         cSData := 'Object'
      OTHERWISE
         cSData := '<Unknown Data Type>'
   ENDCASE
ELSE
   cSData := '"' + xData + '"'         // Enclose String in quotes
ENDIF

Return( cSData + ' (' + cType + ')' )  // Add the Data Type in Parenthesis
* --------------------------------------------------------------------------
* Function Name.... FileInfo()
* Syntax........... FileInfo(cFile)
* Return........... Date, Size & Time for cFile
* Description...... Accesses DOS directory data to return the file creation
*                   date, time & size of the input file                                 
* --------------------------------------------------------------------------
STATIC FUNCTION FileInfo( cFile )      // declare function, Param
LOCAL cRetStr := ''                    // No Find Return
LOCAL aFName[1]                        // Not going to use, but get anyway
LOCAL aFDate[1]
LOCAL aFTime[1]                        // Not going to use, but get anyway
LOCAL aFSize[1]
LOCAL nFnum := 0
IF ValType( cFile ) == "C"             // check param types
   nFnum := ADir( cFile, aFName, aFSize, aFDate, aFTime )

   IF nFnum == 1                       // 0 = no file to match input string
                                       // > 1 = non unique input string
      cRetStr := Dtoc( aFDate[1] ) + '  ' + ;
                 LTrim( Str( aFSize[1] )) + ' bytes'
   ENDIF
ENDIF
Return( SubStr( cRetStr, 1, 58 ))
* --------------------------------------------------------------------------
* Function Name.: Err501Err() --> .F. 
* Syntax........: bErr := ErrorBlock( {|oErr| Err501Err(oErr)} )
* Parameter.....: NONE
* Return........: .F. - DOS
* Description...: Error Handler for Errors in Error501()
* --------------------------------------------------------------------------
STATIC FUNCTION Err501Err( oEr )
SET COLOR TO
SET DEVICE TO SCREEN
CLOSE DATABASES
DispEnd()
? ''
? "Error (" + Trim( oEr:description ) + ") in " + Trim( ProcName( 2 )) + ;
  " (" + LTrim( Str( ProcLine( 2 ))) + ")"
? ''

ErrorLevel( 1 )
SetCursor( 1 )
QUIT
Return( .F. )
