-- This Macro shows how to send information from EPM back to the
-- client application in a DDE conversation. EPM_EDIT_DDE_POST_MSG has the
-- parameters mp1 being set to the item name, and mp2 set to the data both
-- corresponding to the item and data fields of the DDESTRUCT type defined
-- in the OS/2 2.0 toolkit. EPM Accepts this message and packages the
-- parameters into a DDESTRUCT and sends it back to the client application
-- with a WM_DDE_DATA message.

-- To demonstrate DDE interaction start DDESAMP.exe and EPM version 6.
-- In DDESAMP initiate a DDE conversation. When DDESAMP is communicating with
-- EPM you should hear a beep. Next send EPM the command 'link post.ex' which
-- will link this macro post.ex. Now that post.ex is linked send the
-- command post 'string1' 'string2', where string1 and string2 are two
-- arbitrary strings. EPM will receive the message and execute the post
-- macro. The post macro appends * characters to both of the strings
-- and sends them back to DDESAMP with a WM_DDE_DATA message.
-- When DDESAMP receives the WM_DDE_DATA message it will pop up a message
-- box with the data sent back in the item and data fields of DDESTRUCT.

include 'stdconst.e'  -- Needed for EPMINFO_EDITCLIENT constant

defc post =  -- Sample command
     sayerror 'POST command called.'
     parse value arg(1) with NameString DataString
     mp1_str = '****'NameString'****'\0  -- Append \0 for an ASCIIZ string.
     mp2_str = '****'DataString'****'\0
     windowmessage(1,  getpminfo(EPMINFO_EDITCLIENT),
                   5478,    -- EPM_EDIT_DDE_POST_MSG
                   ltoa(offset(mp1_str) || selector(mp1_str), 10),
                   ltoa(offset(mp2_str) || selector(mp2_str), 10));
