/******************************************************************************
*																										*
*         System / User Environment Control Panel Applet Source Code			   *
*																										*
*	Since DLL implementation is essentially version specific, no attempt has	*
*     been made to make this "Windows 3.1 Friendly". Well, that and there's	*
*     no registry stuff like this in Windows 3.1 anyway. Note: Remove         *
*     references to CTL3D.H here and CTL3D.LIB in ENVIRON.MAK if you don't    *
*     want the CTL3D effects to appear.													*
*																										*
*  This program was written by Mark Gamber and may be freely distributed as   *
*     long as the disclaimer is included. (ENVIRON.TXT)                      	*
*																										*
******************************************************************************/


#include "windows.h"
#include "shellapi.h"
#include "cpl.h"
#include "environ.h"
#include "ctl3d.h"  //  ..............................Optional, if you have it.


HINSTANCE hInst;
char *TITLE = "Environment";
char *HELPFILE = "environ.hlp";
BOOL HelpLoaded;


// ---- DLL Entry Point for Windows NT ----------------------------------------

BOOL WINAPI DLLEntryPoint( HINSTANCE hInstance, DWORD dwReason, 
                           LPVOID lpvReserved )
{
	return( TRUE );
}

// ---- Control Panel Applet Entry Point --------------------------------------

LONG CALLBACK CPlApplet( HWND hWnd, UINT uMsg, LPARAM lParam1, LPARAM lParam2 )
{
   switch( uMsg )
   {
      case CPL_INIT: 
         hInst = GetModuleHandle( "environ.cpl" );        //  Find our instance
         return TRUE;

      case CPL_GETCOUNT: 
         return( 1 );									      //  We support one applet

      case CPL_NEWINQUIRE:				   //  Tell Control Panel about this applet
		{
			LPNEWCPLINFO lpNewCPlInfo;

         lpNewCPlInfo = (LPNEWCPLINFO)lParam2;

         lpNewCPlInfo->dwSize = (DWORD)sizeof(NEWCPLINFO);
         lpNewCPlInfo->dwFlags = 0;
         lpNewCPlInfo->dwHelpContext = 0;
         lpNewCPlInfo->lData = 0;
         lpNewCPlInfo->hIcon = LoadIcon( hInst, MAKEINTRESOURCE( 100 ) );
         lpNewCPlInfo->szHelpFile[ 0 ] = '\0';
         LoadString( hInst, IDM_NAMESTRING, lpNewCPlInfo->szName, 32 );
         LoadString( hInst, IDM_DESCSTRING, lpNewCPlInfo->szInfo, 64 );
         break;
		}

      case CPL_DBLCLK:                        //  If applet icon is selected...
			Ctl3dRegister( hInst );			  //  If you have CTL3D32, register here
			Ctl3dAutoSubclass( hInst );
			HelpLoaded = FALSE;				                //  Initialize help flag
													               //  Start main dialog box
         DialogBox( hInst, MAKEINTRESOURCE( 10001 ), hWnd, EnvironDlgProc );
			Ctl3dUnregister( hInst );			                  //  Kill CTL3D here
         break;

		default:
			break;
	}
   return( 0 );
}

// ---- One Size Fits All "Oops" Message Box ---------------------------------

BOOL ErrorMessageBox( LPSTR lpszText, LPSTR lpszTitle )
{

   LPSTR lpFormatMessageBuffer;
   DWORD  dwFormatMessage;
   DWORD  dwGetLastError;
   HLOCAL hMessageBoxBuffer;
   LPVOID lpMessageBoxBuffer;

   dwGetLastError = GetLastError();                        //  Get system error

   hMessageBoxBuffer  = LocalAlloc( LMEM_FIXED, 1024 );	   //  Get some memory
   lpMessageBoxBuffer = LocalLock( hMessageBoxBuffer );		    //  for strings
								                        //  Get the system error string
   dwFormatMessage = FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER |
                                    FORMAT_MESSAGE_FROM_SYSTEM, NULL, 
										      dwGetLastError, LANG_NEUTRAL,
                                    (LPSTR)&lpFormatMessageBuffer, 0, NULL );
   if( ! dwFormatMessage )
		return( FALSE );
										                    //  Initialize display string
   wsprintf( lpMessageBoxBuffer, "%s %s", lpszText, lpFormatMessageBuffer );

   MessageBox( NULL, lpMessageBoxBuffer, lpszTitle, 
					MB_ICONEXCLAMATION | MB_OK );

   if( dwFormatMessage )
      LocalFree( (HLOCAL) lpFormatMessageBuffer );

   LocalFree( (HLOCAL) hMessageBoxBuffer );	             //  Clean up and exit
   return( TRUE );
}

// ---- Main Dialog Box displaying Listboxes ----------------------------------

BOOL WINAPI EnvironDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:         //  If unable to access registry, exit dialog
		{
			int h;
											   	  //  Make listbox items 6 pixels taller
			h = SendMessage( GetDlgItem( hDlg, 100 ), LB_GETITEMHEIGHT, 
								  0, 0 );
			h += 6;

			SendMessage( GetDlgItem( hDlg, 100 ), LB_SETITEMHEIGHT, 
							 0, (LPARAM)h );
			SendMessage( GetDlgItem( hDlg, 101 ), LB_SETITEMHEIGHT, 
							 0, (LPARAM)h );
											              //  Display environments or exit
			if( ! DisplayEnvironment( GetDlgItem( hDlg, 100 ) ) )
				EndDialog( hDlg, FALSE );

			if( ! DisplayUserEnvironment( GetDlgItem( hDlg, 101 ) ) )
				EndDialog( hDlg, FALSE );

			CheckRadioButton( hDlg, 107, 108, 107 );    //  Set to System Settings

			SendMessage( GetDlgItem( hDlg, 100 ), LB_SETCURSEL, 0, 0 );
			SetFocus( GetDlgItem( hDlg, 100 ) );
			return( FALSE );
		}

		case WM_MEASUREITEM:		//  Tell Windows how big the listbox elements are
		{
			LPMEASUREITEMSTRUCT lpMs = (LPMEASUREITEMSTRUCT)lParam;
			RECT Rect;

			GetClientRect( GetDlgItem( hDlg, 100 ), &Rect );
			lpMs->itemWidth = Rect.right;
			lpMs->itemHeight = Rect.bottom / 6;   //  Total of 6 items per listbox
			return( TRUE );						   //  (Rounded down to 4 internally)
		}

		case WM_DRAWITEM:                   //  Draw listbox elements as required
		{
			LPDRAWITEMSTRUCT lpDs = (LPDRAWITEMSTRUCT)lParam;
			char str[ 256 ];

			if( lpDs->itemID == -1 )              //  If nothing to draw yet, exit
				return( FALSE );

			SendMessage( lpDs->hwndItem, LB_GETTEXT, lpDs->itemID, 
							 (LPARAM)(LPSTR)str );

			SelectObject( lpDs->hDC,	                //  Use dialog default font
							  (HFONT)SendMessage( hDlg, WM_GETFONT, 0, 0 ) );
							  						       //  Print text in solid rectangle
			ExtTextOut( lpDs->hDC, 2, 3 + lpDs->rcItem.top, 
							ETO_CLIPPED | ETO_OPAQUE, (LPRECT)&lpDs->rcItem,
							str, lstrlen( str ), (int *)0 );

			if( lpDs->itemState & ODS_SELECTED )      //  Invert color if selected
				InvertRect( lpDs->hDC, &lpDs->rcItem );

			return( TRUE );
		}

		case WM_COMMAND:                                 //  User interface stuff
		{
			if( HIWORD( wParam ) == (WORD)LBN_SETFOCUS )        //  Focus changing 
			{																 //  between listboxes
				CheckRadioButton( hDlg, 107, 108,         //  Designate current box 
										107 + ( LOWORD( wParam ) == 101 ) );
				break;
			}

			if( wParam == 106 )                             //  Start Windows Help
			{
				HelpLoaded = WinHelp( hDlg, HELPFILE, HELP_CONTENTS, 0 );
				break;
			}

			if( wParam == IDCANCEL )	           		             //  Time to go?
			{
				if( HelpLoaded )			   //  If Windows Help was started, kill it
				{
					WinHelp( hDlg, HELPFILE, HELP_QUIT, 0 );
					HelpLoaded = FALSE;
				}
				EndDialog( hDlg, FALSE );
				return( TRUE );
			}

			if( wParam == 103 )							 //  Adding a new key and value
			{							//  If "Add New" dialog is OK, attempt to add key
				DialogBox( hInst, MAKEINTRESOURCE( 10005 ), hDlg, 
							  NewEnvDlgProc );

				if( IsDlgButtonChecked( hDlg, 107 ) )       //  Reflect environment
					DisplayEnvironment( GetDlgItem( hDlg, 100 ) );     //  change in
				else															//  correct listbox
					DisplayUserEnvironment( GetDlgItem( hDlg, 101 ) );

				break;
			}

			if( wParam == 104 )											 //  Deleting a key
			{				                     //  If delete worked, refresh display
				if( IsDlgButtonChecked( hDlg, 107 ) )
				{
					if( DeleteEnvironment( GetDlgItem( hDlg, 100 ) ) )
						DisplayEnvironment( GetDlgItem( hDlg, 100 ) );
				}
				else
				{
					if( DeleteEnvironment( GetDlgItem( hDlg, 101 ) ) )
						DisplayUserEnvironment( GetDlgItem( hDlg, 101 ) );
				}
				break;
			}

			if( wParam == 105 )									 //  Apply value to a key
			{
				HWND hList;
				int item, w, i, len;
				char str[ 300 ];
													      //  Determine which listbox to use
				w = 100 + ( IsDlgButtonChecked( hDlg, 108 ) == TRUE );
				item = (int)SendMessage( GetDlgItem( hDlg, w ), LB_GETCURSEL, 
												 0, 0 );	//  Get selected item from listbox
				if( item == (int)LB_ERR )
					break;							        //  If nothing selected, exit
												   //  Start edit box that overlays listbox
				if( DialogBoxParam( hInst, MAKEINTRESOURCE( 10004 ), hDlg,
										  LEditDlgProc, 
										  (LPARAM)MAKELONG( item, (WORD)w ) ) )
				{						             //  If Enter pressed in edit control
					if( SendMessage( GetDlgItem( hDlg, (WORD)w ),
										  LB_GETTEXT, item, (LPARAM)(LPSTR)str ) )
					{
						len = lstrlen( str );	       //  Get new listbox string and

						for( i = 0; i < len; i++ )	      //  find the field separator
							if( str[ i ] == '=' )
								break;

						str[ i - 1 ] = '\0';		    //  Add modified item to registry
						if( ApplyEnvironment( hDlg, str, str + i + 2 ) )
							if( IsDlgButtonChecked( hDlg, 107 ) )
								DisplayEnvironment( GetDlgItem( hDlg, 100 ) );
							else
								DisplayUserEnvironment( GetDlgItem( hDlg, 101 ) );
					}
				}
				break;
			}

			if( HIWORD( wParam ) == (WORD)LBN_DBLCLK )   //  If list item selected
			{
				int item, i, len;
				HWND hEdit;
				RECT Rect;
				char str[ 300 ];
														        //  Get current item and pass
				item = (int)SendMessage( GetDlgItem( hDlg, LOWORD( wParam ) ),
												 LB_GETCURSEL, 0, 0 );
				if( item == (int)LB_ERR )
					break;								   	   //  to a dialog box which
														//  exactly overlays the listbox item
				if( DialogBoxParam( hInst, MAKEINTRESOURCE( 10004 ), hDlg,
									 LEditDlgProc, 
									 (LPARAM)MAKELONG( item, LOWORD( wParam ) ) ) )
				{
					if( SendMessage( GetDlgItem( hDlg, LOWORD( wParam ) ),
										  LB_GETTEXT, item, (LPARAM)(LPSTR)str ) )
					{
						len = lstrlen( str );

						for( i = 0; i < len; i++ )
							if( str[ i ] == '=' )
								break;

						str[ i - 1 ] = '\0';
						if( ApplyEnvironment( hDlg, str, str + i + 2 ) )
							if( IsDlgButtonChecked( hDlg, 107 ) )
								DisplayEnvironment( GetDlgItem( hDlg, 100 ) );
							else
								DisplayUserEnvironment( GetDlgItem( hDlg, 101 ) );
					}
				}
				break;
			}
		}
	}
	return( FALSE );
}

// ---- Dialog box to Accept New Value Entry ----------------------------------

BOOL WINAPI NewEnvDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			return( TRUE );

		case WM_COMMAND:
			if( wParam == IDCANCEL )                   //  If cancelled, just quit
			{
				EndDialog( hDlg, FALSE );
				return( TRUE );
			}
			if( wParam == IDOK )       //  If OK pressed, add value to environment
			{
				HANDLE hMem;
				LPSTR lpStr;
				char szKey[ 256 ];

				hMem = GlobalAlloc( GHND, 1024 );
				if( ! hMem )
					return( FALSE );

				lpStr = GlobalLock( hMem );
				if( GetDlgItemText( hDlg, 100, szKey, 256 ) )
				{
					if( GetDlgItemText( hDlg, 101, lpStr, 1024 ) )
						ApplyEnvironment( GetParent( hDlg ), szKey, lpStr );
				}
				GlobalUnlock( hMem );
				GlobalFree( hMem );
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			break;
	}
	return( FALSE );
}

// ---- Display System Environment in Specified Listbox -----------------------

BOOL DisplayEnvironment( HWND hList )
{
	HKEY hKey;
	char str[ 64 ];
	HANDLE hMem;
	LPSTR lpszString;
	LPSTR lpszReg;
	LPSTR lpszValue;
	LONG lStatus;
	DWORD dwSize, dwIndex, dwType;


	hMem = GlobalAlloc( GHND, 2248 );
	if( ! hMem )
		return( FALSE );

	while( SendMessage( hList, LB_GETCOUNT, 0, 0 ) )    //  Kill off all listbox
		SendMessage( hList, LB_DELETESTRING, 0, 0 );		      //  items lingering

	lpszReg = GlobalLock( hMem );			              //  Make some string space
	lpszString = lpszReg + 200;
	lpszValue = lpszString + 1024;
											     //  Load system environment registry path
	LoadString( hInst, IDM_ENVIRONREG, lpszReg, 200 );
												                   //  Attempt to open path
	lStatus = RegOpenKeyEx( HKEY_LOCAL_MACHINE, lpszReg, (DWORD)0,
									KEY_ALL_ACCESS, &hKey );

	if( lStatus != ERROR_SUCCESS )	   	      //  If an error occurred, later
	{
		LoadString( hInst, 1000, str, 64 );
		ErrorMessageBox( str, TITLE );
		return( FALSE );
	}

	dwIndex = 0;

	while( lStatus == ERROR_SUCCESS )      //  Loop through items until an error
	{													 //  comes up, at which time we leave
		dwSize = 1024;								    //  Get a new value from registry
		lStatus = RegEnumValue( hKey, dwIndex, lpszString, &dwSize, (LPDWORD)0,
										&dwType, (LPBYTE)0, (LPDWORD)0 );
		if( lStatus == ERROR_SUCCESS )	        //  If valid response from query
		{
			dwSize = 1024;					                    //  Get the key's value
			lStatus = RegQueryValueEx( hKey, lpszString, (LPDWORD)0, &dwType, 
												lpszValue, &dwSize );
			if( lStatus == ERROR_SUCCESS )
			{
				lstrcat( lpszString, " = " );	     //  Add value to key and display
				lstrcat( lpszString, lpszValue );
				SendMessage( hList, LB_ADDSTRING, 0, (LPARAM)lpszString );

				++dwIndex;
				lStatus = ERROR_SUCCESS;
			}
		}
	}
	RegCloseKey( hKey );                                   //  Clean up and exit
	GlobalUnlock( hMem );
	GlobalFree( hMem );
	return( TRUE );
}

// ---- Display User Environment in Specified Listbox -------------------------

//  Note: This could easily be made part of the function above as they are both
//     basically the same thing with only a registry path difference.

BOOL DisplayUserEnvironment( HWND hList )
{
	HKEY hKey;
	HANDLE hMem;
	LPSTR lpszString;
	LPSTR lpszReg;
	LPSTR lpszValue;
	LONG lStatus;
	char str[ 64 ];
	DWORD dwSize, dwIndex, dwType;


	hMem = GlobalAlloc( GHND, 2248 );
	if( ! hMem )
		return( FALSE );

	while( SendMessage( hList, LB_GETCOUNT, 0, 0 ) )
		SendMessage( hList, LB_DELETESTRING, 0, 0 );

	lpszReg = GlobalLock( hMem );
	lpszString = lpszReg + 200;
	lpszValue = lpszString + 1024;

	LoadString( hInst, IDM_NAMESTRING, lpszReg, 200 );
	lStatus = RegOpenKeyEx( HKEY_CURRENT_USER, lpszReg, (DWORD)0,
									KEY_ALL_ACCESS, &hKey );

	if( lStatus != ERROR_SUCCESS )
	{
		LoadString( hInst, 1000, str, 64 );
		ErrorMessageBox( str, TITLE );
		return( FALSE );
	}

	dwIndex = 0;

	while( lStatus == ERROR_SUCCESS )
	{
		dwSize = 1024;
		lStatus = RegEnumValue( hKey, dwIndex, lpszString, &dwSize, (LPDWORD)0,
										&dwType, (LPBYTE)0, (LPDWORD)0 );
		if( lStatus == ERROR_SUCCESS )
		{
			dwSize = 1024;
			lStatus = RegQueryValueEx( hKey, lpszString, (LPDWORD)0, &dwType, 
												lpszValue, &dwSize );
			if( lStatus == ERROR_SUCCESS )
			{
				lstrcat( lpszString, " = " );
				lstrcat( lpszString, lpszValue );
				SendMessage( hList, LB_ADDSTRING, 0, (LPARAM)lpszString );

				++dwIndex;
				lStatus = ERROR_SUCCESS;
			}
		}
	}
	RegCloseKey( hKey );
	GlobalUnlock( hMem );
	GlobalFree( hMem );
	return( TRUE );
}

// ---- Applies a new Key and Value to the Environment ------------------------

BOOL ApplyEnvironment( HWND hDlg, LPSTR lpKey, LPSTR lpValue )
{
	HKEY hKey;
	BOOL bType;
	LONG lStatus;
	HANDLE hMem;
	LPSTR lpszReg;
	DWORD dwStatus, dwSize;
	char str[ 64 ];
	
	hMem = GlobalAlloc( GHND, 1024 );
	if( ! hMem )
		return( FALSE );

	bType = IsDlgButtonChecked( hDlg, 107 );   //  Save which environment to use

	lpszReg = GlobalLock( hMem );
	if( bType )						          //  Load path based on environment type
	{
		LoadString( hInst, IDM_ENVIRONREG, lpszReg, 200 );
		lStatus = RegCreateKeyEx( HKEY_LOCAL_MACHINE, lpszReg, (DWORD)0,
										  (LPSTR)0, REG_OPTION_NON_VOLATILE, 
										  KEY_ALL_ACCESS, (LPSECURITY_ATTRIBUTES)0,
										  &hKey, &dwStatus );
	}
	else
	{
		LoadString( hInst, IDM_NAMESTRING, lpszReg, 200 );
		lStatus = RegOpenKeyEx( HKEY_CURRENT_USER, lpszReg, (DWORD)0,
										KEY_ALL_ACCESS, &hKey );
	}

	if( lStatus != ERROR_SUCCESS )
	{
		LoadString( hInst, 1001, str, 64 );
		ErrorMessageBox( str, TITLE );
		GlobalUnlock( hMem );
		GlobalFree( hMem );
		return( FALSE );
	}

	dwSize = lstrlen( lpValue ) + 1;         //  Create new value in environment
	lStatus = RegSetValueEx( hKey, lpKey, (DWORD)0, REG_EXPAND_SZ, 
									 lpValue, dwSize );
	if( lStatus != ERROR_SUCCESS )
	{
		LoadString( hInst, 1002, str, 64 );
		ErrorMessageBox( str, TITLE );
	}

	RegCloseKey( hKey );					                //  Clean up on the way out
	GlobalUnlock( hMem );
	GlobalFree( hMem );

	if( lStatus == ERROR_SUCCESS )
		return( TRUE );

	return( FALSE );
}

// ---- Removes an Item from an Environment -----------------------------------

BOOL DeleteEnvironment( HWND hList )
{
	HKEY hKey;
	LONG lStatus;
	HANDLE hMem;
	HWND hDlg;
	BOOL bType;
	LPSTR lpszReg;
	char szItem[ 256 ];
	LRESULT index;
	int i, len;
	
	hMem = GlobalAlloc( GHND, 1024 );
	if( ! hMem )
		return( FALSE );

	lpszReg = GlobalLock( hMem );

	hDlg = GetParent( hList );
	bType = IsDlgButtonChecked( hDlg, 107 );   //  Save which environment to use
															 //  Get current listbox selection
	index = SendMessage( hList, LB_GETCURSEL, 0, 0 );
	if( index != (LRESULT)LB_ERR )				   //  If valid selection received
	{												     //  Get the associated listbox text
		if( SendMessage( hList, LB_GETTEXT, (WPARAM)index, 
							  (LPARAM)lpszReg ) )
		{
			len = lstrlen( lpszReg );
			for( i = 0; i < len; i++ )
			{
				if( *( lpszReg + i ) == '=' )
				{
					--i;
					*( lpszReg + i ) = '\0';
					lstrcpy( szItem, lpszReg );     //  Extract key name from string
					if( bType )      //  Load environment path based on radio button
					{
						LoadString( hInst, IDM_ENVIRONREG, lpszReg, 200 );

						lStatus = RegOpenKeyEx( HKEY_LOCAL_MACHINE, lpszReg, 
														(DWORD)0, KEY_ALL_ACCESS, &hKey );
					}
					else
					{
						LoadString( hInst, IDM_NAMESTRING, lpszReg, 200 );
						lStatus = RegOpenKeyEx( HKEY_CURRENT_USER, lpszReg, (DWORD)0,
														KEY_ALL_ACCESS, &hKey );
					}

					if( lStatus == ERROR_SUCCESS )
					{									  //  Make sure user wants to do this
						LoadString( hInst, IDM_DELKEYWARN, lpszReg, 1024 );
						MessageBeep( MB_ICONQUESTION );
															          //  And if so, delete it
						if( MessageBox( GetParent( hList ), lpszReg, TITLE,
											 MB_YESNO | MB_ICONQUESTION ) == IDYES )
							lStatus = RegDeleteValue( hKey, szItem );
						else
							lStatus = ERROR_SUCCESS;

						if( lStatus != ERROR_SUCCESS )
						{
							LoadString( hInst, 1003, szItem, 256 );
							ErrorMessageBox( szItem, TITLE );
						}
						RegCloseKey( hKey );
					}
					else
					{
						LoadString( hInst, 1004, szItem, 256 );
						ErrorMessageBox( szItem, TITLE );
					}
				}
			}
		}
	}
	GlobalUnlock( hMem );
	GlobalFree( hMem );

	return( TRUE );
}

// ---- Listbox "Edit" dialog window ------------------------------------------

BOOL WINAPI LEditDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
		{
			RECT Rect;
			char str[ 256 ];
			char Name[ 128 ];
			SIZE Size;
			HDC hDC;
			HBRUSH hBrush;
			int i, len;
											              //  Get text from parent listbox
			if( ! SendMessage( GetDlgItem( GetParent( hDlg ), HIWORD( lParam ) ),
									 LB_GETTEXT, LOWORD( lParam ), (LPARAM)(LPSTR)str ) )
			{
				EndDialog( hDlg, FALSE );
				return( TRUE );
			}

			len = lstrlen( str );
			for( i = 0; i < len; i++ )
				if( str[ i ] == '=' )	        //  Extract value from listbox text
					break;							             //  (Also, the key name)

			str[ i + 1 ] = '\0';

			hDC = GetDC( hDlg );				   //  Determine pixel length of "key ="
			GetTextExtentPoint( hDC, str, lstrlen( str ), &Size );
			ReleaseDC( hDlg, hDC );
												     //  Put value text in our edit control
			SetDlgItemText( hDlg, 100, str + i + 2 );
							//  Get location of listbox item and adjust X and Y values
			SendMessage( GetDlgItem( GetParent( hDlg ), HIWORD( lParam ) ), 
							 LB_GETITEMRECT, LOWORD( lParam ), (LPARAM)(LPRECT)&Rect );
			ClientToScreen( GetDlgItem( GetParent( hDlg ), HIWORD( lParam ) ), 
								 (LPPOINT)&Rect );

			Rect.left = Rect.left + Size.cx;	 	   //  Size the dialog and edit so
			Rect.right = Rect.right - Size.cx;		  //  the "key =" isn't covered
									  //  Position the dialog and edit control over item
			Rect.bottom = SendMessage( GetDlgItem( GetParent( hDlg ), 
												HIWORD( lParam ) ), LB_GETITEMHEIGHT, 0, 0 );
			SetWindowPos( hDlg, HWND_TOP, Rect.left, Rect.top, Rect.right,
							  Rect.bottom, SWP_NOZORDER );
			SetWindowPos( GetDlgItem( hDlg, 100 ), HWND_TOP, 0, 0, Rect.right, 
							  Rect.bottom, SWP_NOMOVE | SWP_NOZORDER );
									             //  Save listbox and item values passed
			SetProp( hDlg, MAKEINTATOM( 1001 ), (HANDLE)lParam );

			SendMessage( GetDlgItem( hDlg, 100 ), EM_SETSEL, -1, 1 );
			return( TRUE );
		}

		case WM_COMMAND:
			if( wParam == IDOK || wParam == IDCANCEL )
			{
				char str[ 256 ];
				char szNew[ 256 ];
				int item, id, len, i;

				if( wParam == IDOK )
				{		                   //  Retrieve id and item values of listbox
					item = LOWORD( (DWORD)GetProp( hDlg, MAKEINTATOM( 1001 ) ) );
					id = HIWORD( (DWORD)GetProp( hDlg, MAKEINTATOM( 1001 ) ) );
												               //  Get current listbox text
					SendMessage( GetDlgItem( GetParent( hDlg ), id ), LB_GETTEXT,
									 item, (LPARAM)(LPSTR)str );
					len = lstrlen( str );
					if( len )
					{
						for( i = 0; i < len; i++ )
							if( str[ i ] == '=' )	  //  Extract key name from string
								break;
												         //  Get text from our edit control
						GetDlgItemText( hDlg, 100, szNew, 256 );
						lstrcpy( str + i + 2, szNew );         //  to form new string
						SendMessage( GetDlgItem( GetParent( hDlg ), id ), 
										 LB_DELETESTRING, item, 0 );
						SendMessage( GetDlgItem( GetParent( hDlg ), id ),
										 LB_ADDSTRING, 0, (LPARAM)(LPSTR)str );
						SendMessage( GetDlgItem( GetParent( hDlg ), id ),
										 LB_SETCURSEL, item, 0 );
					}
				}

				RemoveProp( hDlg, MAKEINTATOM( 1001 ) );	    //  Clean up and exit

				EndDialog( hDlg, wParam == IDOK ); //  FALSE aborts regsitry access
				return( TRUE );			    //  TRUE causes a write to the registry
			}
			break;
	}
	return( FALSE );
}

