/* sys/newthrea.c (emx+gcc) -- Copyright (c) 1993-1996 by Eberhard Mattes */

#if defined (__MT__)

#include <errno.h>
#define INCL_DOS
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"

/* Also used by 386/systhrea.s */

int __sys_newthread (int tid, int *errnop)
{
  ULONG rc;
  void *data;

  if (tid >= MAX_THREADS)
    {
      if (errnop != NULL)
        *errnop = EAGAIN;
      return -1;
    }
  rc = DosSubAllocMem (_sys_private_heap, &data, sizeof (thread_data));
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return -1;
    }
  _sys_thread_table[tid] = data;
  _sys_init_thread (data);
  return 0;
}


int __newthread (int tid)
{
  return __sys_newthread (tid, &errno);
}

#endif
