/* cpp.c */

#include <stdlib.h>
#include <io.h>

typedef void (*vfp)(void);

static void default_new_handler (void);

vfp __new_handler = default_new_handler;

static void default_new_handler (void)
{
  static char msg[] = "Virtual memory exhausted in `new'\n";

  write (2, msg, sizeof (msg) - 1);
  _exit (255);
}


void *__builtin_new (size_t size)
{
  void *p;

  /* Don't assume that malloc(0) does not return NULL, in case someone
     replaces malloc(). */

  if (size == 0) size = 1;

  p = malloc (size);
  while (p == NULL)
    {
      __new_handler ();
      p = malloc (size);
    }
  return (p);
}


void *__builtin_vec_new (size_t size)
{
  return (__builtin_new (size));
}


void __builtin_delete (void *p)
{
  free (p);
}


void __builtin_vec_delete (void *p)
{
  __builtin_delete (p);
}


vfp set_new_handler (vfp handler)
{
  vfp prev_handler;

  prev_handler = __new_handler;
  if (handler == NULL)
    handler = default_new_handler;
  __new_handler = handler;
  return (prev_handler);
}
