/* Rexx script fr ZOC MausTausch */

/* Variablen setzen */
zocdir = '' /* Verzeichnis, in dem ZOC installiert ist (z.B. f:\com\zocd) */
zocupload = zocdir || '\upload' /* UPLOAD-Verzeichnis von ZOC */
zocdownload = zocdir || '\download' /* DOWNLOAD-Verzeichnis von ZOC */
mmdir = '' /* Verzeichnis, in dem Emis/PM installiert ist (z.B. f:\emis) */

/* Variablen prfen */
if zocdir = "" | mmdir = "" Then do
  Call beep 440, 1000
  say "Die Variablen am Anfang dieser Datei mssen noch gesetzt werden!"
  '@pause'
  exit 2
end

/* Ins MausMail Verzeichnis wechseln und OUTFILE lschen */
call directory mmdir
'del outfile.*'

/* 
infile Einpacken und nach <zocupload> kopieren, outfile.* im
<zocdownload> Verzeichnis lschen, zoc aufrufen und outfile entpacken.
*/
'del infile.zip'
'zip infile infile.txt'
if rc \= 0 Then Error("Infile kann nicht gepackt werden")
'copy infile.zip' zocupload
if rc \= 0 Then Error("Infile kann nicht ins ZOC Verzeichnis kopiert werden")
'del' zocdownload || '\outfile.*'

/* Starte ZOC */
call directory zocdir 
'zoc /u /s:' || mmdir || '\zocmt.scr'
call directory mmdir 
'copy' zocdownload || '\outfile.zip'
'del' zocdownload || '\outfile.zip'
'unzip outfile'
if rc \= 0 Then Error("Outfile kann nicht ausgepackt werden")
Say "MausTausch erfolgreich durchgefhrt"
Exit 0

/* Fehlerbehandlung */
Error:
parse arg str
Say "FEHLER:" str
Exit 1