/* system.c  -- OS/2 version */

#include "config.h"
#include "vi.h"

#include <stdio.h>
#include <process.h>

#define	INCL_DOSPROCESS
#include <os2.h>

void raw_set_stdio(rawstate)
	int rawstate;
{
  	static int buffered = 0;

	if (!buffered)
	{
	  buffered = 1;
	  setvbuf(stdout, NULL, _IOFBF, BUFSIZ);
	}

	if (rawstate)
	  setmode(fileno(stdout), O_BINARY);
	else
	  setmode(fileno(stdout), O_TEXT);
}

int system(cmd)
	const	char	*cmd;	/* a command to run */
{
	int	status;	/* exit status of the command */

	if (cmd == o_shell)
	  status = spawnl(P_WAIT, o_shell, o_shell, 0);
	else
	  status = spawnl(P_WAIT, o_shell, o_shell, "/c", cmd, 0);

	return status;
}

static int pid[64];

int rpipe(cmd, in)
	char	*cmd;	/* the filter command to use */
	int	in;	/* the fd to use for stdin */
{
	int	r0w1[2];/* the pipe fd's */
	int 	old1;

	if (pipe(r0w1) < 0)
		return -1;

	old1 = dup(1);
	fcntl(old1, F_SETFD, 1);
	dup2(r0w1[1], 1);
	close(r0w1[1]);
	fcntl(r0w1[0], F_SETFD, 1);

	pid[r0w1[0]] = spawnl(P_NOWAIT, o_shell, o_shell, "/c", cmd, 0);

	dup2(old1, 1);
	close(old1);

	return r0w1[0];
}

int rpclose(fd)
	int	fd;
{
  	int	status;

	close(fd);
	waitpid(pid[fd], &status, 0);

	return status;
}

char *gethome(exe)
	char	*exe;	/* full pathname of the ELVIS.EXE file */
{
	static char	*home;

	if (!home)
	{
	  home = getenv("HOME");

	  if (!home)
	  {
	    PTIB pptib;
	    PPIB pppib;
	    char *path;

	    DosGetInfoBlocks(&pptib, &pppib);

	    path = pppib -> pib_pchenv;

	    while (*path)
	      path = strchr(path, 0) + 1;

	    home = path + 1;
	  }
	}

	return home;
}
