;;; TEMPLATE.LSP - Generic ELF application template
;;; Copyright 1992,93 by Mountain Software
;;;
;;; This program requires ELF, the Extended List Function library
;;;
;;; Template.Lsp creates a screen header and footer, fills the screen,
;;; defines a help screen, and then executes a menu. Change the menu
;;; labels and function names to your own function names and include
;;; those functions in this file (rename the file and functions if you wish).

(Princ "\nLoading Template.Lsp")
(Load"ELF")                             ;load ELF.EXP, color and key symbols

;;;*----- The Main Function

(DeFun C:TEMPLATE( / menu_strmenu_fun  help_screen mitems i key bcolor
		     done video vcols vrows)
  (TextScr)
  (SetQ menu_str	'("Function 1" "Function 2" "Function 3")
	menu_fun	'(FUNCTION1 FUNCTION2 FUNCTION3)
	mitems		(length menu_str)
	old_error	*error*
        *error*         MyError
	bcolor		(| white lgrey_bg)
	attr		(| lgrey blue_bg)
	col		(| black lgrey_bg)
	done		nil
	video		(Get_Video)
	vcols		(Car video)
	vrows		(Cadr video))
  (Set_Color attr)
  (Set_Menu_Help '("Help Title" "User Defined" "Help Message"))
  (Scr_Fill 0 3 vcols (- vrows 2) 176 bcolor)

  ;;;*----- Top title bar

  (Wopen 0 0 vcols 3 col col (| single_bd tlhl_bd))
  (WputCen "ELF Program Template")

  ;;;*----- Create a status line on the bottom row

  (Scr_Fill 0 (1- vrows) vcols 1 32 (| black lgrey_bg))
  (Prts 2 (1- vrows) "[F1] - Help  [Esc] - Quit")

  ;;;*----- Loop until done

  (While (Not done) (Progn
    (Wopen -1 -1 20 (+ mitems 6) (| white cyan_bg) (| lcyan cyan_bg) (| no_bd shadow_bd))
    (Wtitle "Template Menu" 1 (| black cyan_bg))
    (Wtitle "Select" 4 (| yellow cyan_bg))
    (SetQ ans (Wmenu menu_str -1 -1 (| white cyan_bg) (| black cyan_bg)
		     (| white black_bg) (| single_bd tlhl_bd))
          key (Cadr ans)
	  i   (Car ans))
    (Wclose)
    (Wpopup Vcols Vrows 7 7 0)
    (If(= key Esc_Key)
      (SetQ done T)
    ;else
      (Eval (List(nth i menu_fun)))	;Execute the selected function
    )
    (Wclose)
  ))
  (Wclose)
  (Cls 7)
  (SetQ *error* old_error old_error nil)
  (Princ)
)

(DeFun FUNCTION1()
  (Wmsg "Function 1 Selected")
)

(DeFun FUNCTION2()
  (Wmsg "Function 2 Selected")
)

(DeFun FUNCTION3()
  (Wmsg "Function 3 Selected")
)

;;;*----- Our Error Routine

(DeFun MyError(s)
  (beep)
  (Wmsg (strcat "Template ERROR\n" s) 1 (| white red_bg))
  (WcloseAll)
  (Cls 7)
  (SetQ *error* old_error old_error nil)
  (princ)
)

(Princ "\nTemplate.Lsp loaded, Enter \"TEMPLATE\" to run...")
(Princ)

;;;*----- End of Template.Lsp
