unit Testmini;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, EIniFile, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    Label1: TLabel;
    Edit1: TEdit;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure	FillListBox;
    function	GetName : string;
    procedure FormCreate(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
  Section	: string;
  Line		: string;
  Msg			: string;



function	TForm1.GetName : string;
var
	winDir	: array[0..127] of char;
begin
	{ Get filename }
  Result	:= Edit1.Text;

  { Check to see if it has a full path. If not then assume windows directory }
	if Pos('\',Result) = 0 then
   	begin
	    GetWindowsDirectory( winDir, 127 );
   		Result	:= StrPas( winDir );
	    Result	:= Result + '\' + Edit1.Text;
		end;
end;

procedure	TForm1.FillListBox;
var
	Name		: string;
  Line		: string;
 	iniFile	: System.text;

begin
	{ Clear the list }
	ListBox1.Clear;

  { Get the name }
  Name	:= GetName;

  try
	 	{ Point to the file and open it }
  	AssignFile( iniFile, Name );
		Reset( iniFile );

	  repeat
		 	{ Read a line }
			readln( iniFile, Line );

	    { Add to the list box }
	    ListBox1.Items.Add(Line);
		until	eof(iniFile);

    { Done with the file }
  	CloseFile(iniFile);
	except
  	on EInOutError do MessageDlg( 'Error handling .INI file', mtError, [mbOK], 0 );
  end;
end;


procedure TForm1.Button1Click(Sender: TObject);
var
	LocIni	: TEIniFile;
	Search	: string;
begin
	LocIni	:= TEIniFile.Create( Edit1.Text );

	if InputQuery( 'Search', 'Search text', Search ) then
  	begin
		  if LocIni.ItemExists( Search, Section, Line ) then
	  	begin
  	  	Msg	:= 'Found it! '+'Section: '+Section+' Line: '+Line;
		  	MessageDlg( Msg, mtConfirmation, [mbOK], 0 );
			end
		else
  		MessageDlg( 'No find!', mtConfirmation, [mbOK], 0 );
    end;

	{ Done with .INI }
	LocIni.Free;

  { Re-show the listbox }
  FillListBox;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
	FillListBox;
end;

procedure TForm1.Edit1Exit(Sender: TObject);
begin
		FillListBox;
end;

end.

