unit Unit1;

interface

uses
     Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     {$IFNDEF VER80 }
     Windows, ComCtrls,
     {$ELSE }
     wintypes, winprocs,
     {$ENDIF }
     StdCtrls, Buttons, EnhImage, ExtCtrls, Menus;

type
  TForm1 = class(TForm)
    img: TEnhImage;
    original: TEnhImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    SatLab: TLabel;
    LigLab: TLabel;
    ConLab: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    temp: TEnhImage;
    Label4: TLabel;
    Label5: TLabel;
    BitBtn1: TBitBtn;
    Panel1: TPanel;
    PaintBox1: TPaintBox;
    Panel2: TPanel;
    PaintBox2: TPaintBox;
    Label6: TLabel;
    MainMenu1: TMainMenu;
    Loadpicture1: TMenuItem;
    Loadpicture2: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    OpenDlg: TOpenDialog;
    saturation: TScrollBar;
    lightness: TScrollBar;
    contrast: TScrollBar;
    Effects: TMenuItem;
    FlipHorizontal1: TMenuItem;
    Flipvertical1: TMenuItem;
    Togray2: TMenuItem;
    Invert1: TMenuItem;
    procedure saturationChange(Sender: TObject);
    procedure LightnessChange(Sender: TObject);
    procedure ContrastChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure PaintBox2Paint(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Loadpicture2Click(Sender: TObject);
    procedure invertClick(Sender: TObject);
    procedure FlipHorizontalClick(Sender: TObject);
    procedure FlipVerticalClick(Sender: TObject);
    procedure ToGrayClick(Sender: TObject);
  private
    { Private declarations }
    LastChange:integer;
    LastSat   :integer;
    LastCon   :integer;
    LastLig   :integer;
    procedure UpdateFrequencies;
  public
    { Public declarations }
    procedure AssignOriginal(ABitmap:graphics.TBitmap);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.UpdateFrequencies;
begin
img.DrawFrequency(1,true,PaintBox1.canvas,0,0,PaintBox1.width,PaintBox1.height);
img.DrawFrequency(2,true,PaintBox2.canvas,0,0,PaintBox2.width,PaintBox2.height);
end;  { TForm1.UpdateFrequencies }

procedure TForm1.saturationChange(Sender: TObject);
begin
if (LastSat=saturation.position) and
   (LastCon=contrast  .position) and
   (LastLig=lightness .position) then
  exit;
LastSat:=saturation.position;
LastCon:=contrast  .position;
LastLig:=lightness .position;
if LastChange<>1 then
  begin
  LastChange:=1;
  end;
SatLab.caption:=IntToStr(saturation.position);
img.picture.bitmap.assign(original.picture.bitmap);
img.VariateColors(saturation.position,contrast.position,lightness.position);
UpdateFrequencies;
end;

procedure TForm1.LightnessChange(Sender: TObject);
begin
if (LastSat=saturation.position) and
   (LastCon=contrast  .position) and
   (LastLig=lightness .position) then
  exit;
LastSat:=saturation.position;
LastCon:=contrast  .position;
LastLig:=lightness .position;
if LastChange<>2 then
  begin
  LastChange:=2;
  temp.picture.bitmap.assign(original.picture.bitmap);
  temp.VariateColors(saturation.position,contrast.position,0);
  end;
LigLab.caption:=IntToStr(lightness.position);
img.picture.bitmap.assign(temp.picture.bitmap);
img.lightness(lightness.position);
UpdateFrequencies;
end;

procedure TForm1.ContrastChange(Sender: TObject);
begin
if (LastSat=saturation.position) and
   (LastCon=contrast  .position) and
   (LastLig=lightness .position) then
  exit;
LastSat:=saturation.position;
LastCon:=contrast  .position;
LastLig:=lightness .position;
if LastChange<>3 then
  begin
  LastChange:=3;
  temp.picture.bitmap.assign(original.picture.bitmap);
  temp.saturate(saturation.position);
  end;
ConLab.caption:=IntToStr(contrast.position);
img.picture.bitmap.assign(temp.picture.bitmap);
img.VariateColors(0,contrast.position,lightness.position);
UpdateFrequencies;
end;

procedure TForm1.AssignOriginal(ABitmap:graphics.TBitmap);
var RatioW:real;
    RatioH:real;
    ratio :real;
begin
LastChange:=0;
LastSat   :=-1000;
LastCon   :=-1000;
LastLig   :=-1000;
RatioW:=original.width /ABitmap.width ;
RatioH:=original.height/ABitmap.height;
if RatioW>RatioH then
  ratio:=RatioH
else
  ratio:=RatioW;
if (ratio>1) then ratio:=1;
ratio:=ratio*1;
original.picture.bitmap.width :=trunc(ABitmap.width *ratio);
original.picture.bitmap.height:=trunc(ABitmap.height*ratio);
original.picture.bitmap.canvas.StretchDraw(rect(0,0,original.picture.width,original.picture.height),ABitmap);
img.picture.bitmap.assign(original.picture.bitmap);
UpdateFrequencies;
end;  { TForm1.AssignOriginal }

procedure TForm1.FormCreate(Sender: TObject);
begin
LastChange:=0;
LastSat   :=-1000;
LastCon   :=-1000;
LastLig   :=-1000;
AssignOriginal(temp.picture.bitmap);
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
img.DrawFrequency(1,true,PaintBox1.canvas,0,0,PaintBox1.width,PaintBox1.height);
end;

procedure TForm1.PaintBox2Paint(Sender: TObject);
begin
img.DrawFrequency(2,true,PaintBox2.canvas,0,0,PaintBox2.width,PaintBox2.height);
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
close;
end;

procedure TForm1.Loadpicture2Click(Sender: TObject);
begin
if OpenDlg.execute then
  begin
  try
    temp.LoadPicture(OpenDlg.FileName);
    AssignOriginal(temp.picture.bitmap);
  except
    MessageDlg('Error reading '+OpenDlg.FileName,mtWarning,[mbOk],0);
    end;  { try }
  end;  { if }
end;

procedure TForm1.invertClick(Sender: TObject);
begin
img.invert;
end;

procedure TForm1.FlipHorizontalClick(Sender: TObject);
begin
img.FlipHorizontal;
end;

procedure TForm1.FlipVerticalClick(Sender: TObject);
begin
img.FlipVertical;
end;

procedure TForm1.ToGrayClick(Sender: TObject);
begin
img.ToGray;
end;

end.
