{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Testing; doubly linked data element chaining

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDAT;


var Element1, Element2 : GenericLinkageObjectPointerType;
    Data1 : string[100]; Data2, Data3 : string[200];

begin
     Data1 := '1) Some data to store in the element.';
     Data2 := '2) Some other data to update the element with.';
     Data3 := '3) Not functioning properly!'; { Should never be displayed }

     New (Element1, InitializeEmpty);
     Element1^.Free;

     New (Element1, Initialize (Data1, SizeOf(Data1)));
     with Element1^ do begin
          Element (Data1);
          WriteLn (Data1);

          Update (Data2, SizeOf(Data2));
          Element (Data1);
          WriteLn (Data1);

          if IsAllocated then begin
             New (Element2, InitializeDuplicate (Element1));

             with Element2^ do begin
                  Element (Data3);
                  WriteLn (Data3);
                  { Test circular attaching of element }
                  AttachAfter (Element2);
                  if (Element2^.Successor <> @(Element2^)) then
                     WriteLn ('Not functioning properly; circular attaching not valid.');
                  Detach;
                  { Connect the two elements }
                  AttachBefore (Element1);
                  if Element2^.IsIntact then WriteLn ('Intact links!');
             end;

             Element2^.Free;
          end;
     end;

     Element1^.Free;
end.