{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; sorting performance test

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBDAT, CRT;


const NumberOfElements = 500;

var Data : array [1..6] of DataObjectPointerType;
    Current : DataObjectPointerType; Timer : TimerObjectType;
    Index, Number : word;

procedure Build;
begin
     { Build structure }
     Current^.Clear;
     for Index := 1 to NumberOfElements do begin
         Number := Succ(Random(High(Number)));
         Current^.Add (Number); { Add element }
     end;
end;

procedure Test;
begin
     RandSeed := 0; { Control random seed }

     Build;

     (* // Merge sort is under construction (not optimized) // *)

     { Sort structure with MergeSort while measuring the needed time }
     Timer.Initialize;
 (*  Current^.Sort (AscendingOrder, MergeSortAlgorithm); *)
     Write (Timer.ElapsedMS:25:0);
     Timer.Intercept;

     Build;

     { Sort structure with QuickSort while measuring the needed time }
     Timer.Initialize;
     Current^.Sort (AscendingOrder, QuickSortAlgorithm);
     Write (Timer.ElapsedMS:20:0);
     Timer.Intercept;
end;

begin
     WriteLn; TextBackground (Blue);
     Write ('Datatype', '':32, 'Merge sort ........ Quick sort [ms] ');
     TextBackground (Black); WriteLn;

     Write ('Array list          ');
     Data[1] := New(ArrayListObjectPointerType, Initialize(NumberOfElements, SizeOf(Number)));
     Current := Data[1]; Test; WriteLn;

     Write ('Virtual list        ');
     Data[2] := New(VirtualListObjectPointerType, Initialize(0, Succ(NumberOfElements div 100), SizeOf(Number)));
     Current := Data[2]; Test; WriteLn;

     Write ('Pointer list        ');
     Data[3] := New(PointerListObjectPointerType, Initialize(NumberOfElements, 0, SizeOf(Number)));
     Current := Data[3]; Test; WriteLn;

     Write ('Linked list         ');
     Data[4] := New(LinkedListObjectPointerType, InitializeList(SizeOf(Number), UnsortedOrder, TRUE, TRUE));
     Current := Data[4]; Test; WriteLn;

(*   Write ('Cached linked list  ');
     Data[5] := New(CachedLinkedListObjectPointerType, InitializeList(SizeOf(Real), NumberOfElements div 50,
                 UnsortedOrder, FALSE, FALSE));
     Current := Data[5]; Test; WriteLn; *)

(*   Write ('Segment linked list ');
     Data[6] := New(SegmentLinkedListObjectPointerType, InitializeList(SizeOf(Real), NumberOfElements div 50,
                 UnsortedOrder, FALSE, FALSE));
     Current := Data[6]; Test; WriteLn; *)

     WriteLn ('Verifying sort order ...');

     for Index := 1 to SizeOf(Data) div SizeOf(DataObjectPointerType) do
         if Data[Index]^.IsInitialized then
            if not Data[Index]^.IsSorted (AscendingOrder) then
               WriteLn ('Data type ', Index, ' was not correctly sorted.');

     WriteLn ('Done.');

     { Dispose all data structures }
     for Index := 1 to SizeOf(Data) div SizeOf(DataObjectPointerType) do
         if Data[Index]^.IsInitialized then Data[Index]^.Free;

     if GlobalDataError then WriteLn ('Error(s) reported!');
end.


