{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; list performance test

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBDAT, CRT;


const NumberOfElements = 5000;

var Data : array [1..6] of DataObjectPointerType;
    Current : DataObjectPointerType; Timer : TimerObjectType;
    Index : word; Number : real; MemoryUsage : longint;


procedure TestElementAddition;
begin
     RandSeed := 0; { Control random seed }
     Timer.Initialize;
     for Index := 1 to NumberOfElements do begin
         Number := Pi * (Succ(Random(100))/Succ(Random(100)));
         Current^.Add (Number);
     end;
     Write (MemoryUsage - MemAvail:8);
     Write (Timer.ElapsedMS:17:0);
     Timer.Intercept;
end;

procedure TestElementAccess;
begin
     Timer.Initialize;
     for Index := 1 to NumberOfElements do
         Current^.Element (Index, Number);
     Write (Timer.ElapsedMS:25:0);
     Timer.Intercept;
end;

procedure Test;
begin
     TestElementAddition;
     TestElementAccess;
end;

begin
     { This program will test the performance of different data types.
       Not all data types are tested. The remaining data types are
       descendants or close relatives to the tested data types.

       Each data type is tested in 1) element adding and 2) sequential
       access. Each test is measured in duration and the results are
       displayed. Also, the testing involve memory usage check. }

     WriteLn; TextBackground (Blue);
     Write ('Datatype', '':12, 'Memory usage .... Element adding ...... Seq. access [ms] ');
     TextBackground (Black); WriteLn;

     Write ('Array list          '); MemoryUsage := MemAvail;
     Data[1] := New(ArrayListObjectPointerType, Initialize(NumberOfElements, SizeOf(Number)));
     Current := Data[1]; Test; WriteLn;

     Write ('Virtual list        '); MemoryUsage := MemAvail;
     Data[2] := New(VirtualListObjectPointerType, Initialize(0, Succ(NumberOfElements div 100), SizeOf(Number)));
     Current := Data[2]; Test; WriteLn;

     Write ('Pointer list        '); MemoryUsage := MemAvail;
     Data[3] := New(PointerListObjectPointerType, Initialize(NumberOfElements, SizeOf(Number)));
     Current := Data[3]; Test; WriteLn;

     Write ('Linked list         '); MemoryUsage := MemAvail;
     Data[4] := New(LinkedListObjectPointerType, InitializeList(SizeOf(Number), UnsortedOrder, TRUE, TRUE));
     Current := Data[4]; Test; WriteLn;

(*   Write ('Cached linked list  '); MemoryUsage := MemAvail;
     Data[5] := New(CachedLinkedListObjectPointerType, InitializeList(SizeOf(Number), NumberOfElements div 50,
                 UnsortedOrder, FALSE, FALSE));
     Current := Data[5]; Test; WriteLn; *)

(*   Write ('Segment linked list '); MemoryUsage := MemAvail;
     Data[6] := New(SegmentLinkedListObjectPointerType, InitializeList(SizeOf(Number), NumberOfElements div 50,
                 UnsortedOrder, FALSE, FALSE));
     Current := Data[6]; Test; WriteLn; *)

     WriteLn ('Checking data type integrity ...');

     { Certify that all data structures contains exactly the same data. Uses
       the IsEqual method that compares polymorphic data types. }
     for Index := 1 to Pred(SizeOf(Data) div SizeOf(DataObjectPointerType)) do
         if Data[Index]^.IsInitialized and Data[Succ(Index)]^.IsInitialized and
            not Data[Index]^.IsEqual(Data[Succ(Index)]) then
            WriteLn ('Data type ', Index, ' has errors.');

     WriteLn ('Done.');

     { Dispose all data structures }
     for Index := 1 to SizeOf(Data) div SizeOf(DataObjectPointerType) do
         if Data[Index]^.IsInitialized then Data[Index]^.Free;

     if GlobalDataError then WriteLn ('Error(s) reported!');
end.