{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; linked list active sort performance test

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBDAT;


const Filename = '..\data.txt';

var MyText : TextObjectType; Index : word;
    Timer : TimerObjectType;
    TextFile : text; SomeData : string;


procedure AddInOrder;
begin
     System.Assign (TextFile, Filename); Reset (TextFile);
     while not Eof(TextFile) do begin
           ReadLn (TextFile, SomeData);
           MyText.Add (SomeData);
     end;
     System.Close (TextFile);
end;


begin
     with MyText do begin
          { Initialize a structure based on text strings }
          Initialize;

          { Enable active sorting with ascending sort order }
          SetAscendingOrder;

          Timer.Initialize;

          { Binary search method }
          SetSearchMethod (BinarySearchMethod);
          AddInOrder;
          WriteLn ('Active sorting with *FAST* binary search;');
          WriteLn ('':3, Timer.StringMS);
          if not (IsSorted(AscendingOrder) and IsIntact)
             then WriteLn ('Test; structure sorting failed.');

          Clear; { Clear all elements }

          Timer.Reset;

          { Linear search method }
          SetSearchMethod (LinearSearchMethod);
          AddInOrder;
          WriteLn ('Active sorting with conventional linear search;');
          WriteLn ('':3, Timer.StringMS);
          if not (IsSorted(AscendingOrder) and IsIntact)
             then WriteLn ('Test; structure sorting failed.');

          Intercept; Timer.Intercept;
     end;
     if GlobalDataError then WriteLn ('Error(s) reported!');
end.