{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; simple hash table built of text file

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBTXT, EFLIBDAT;


const CapacityOfElements = 1500; { Maximum capacity }

var MyHashTable : HashTableObjectType; MyText : string[30];
    Index : word; Timer : TimerObjectType; TextFile : text;

begin
     Timer.Initialize; Index := 0;

     with MyHashTable do begin

          { Initialize hash table }
          Initialize (CapacityOfElements, SizeOf(MyText));

          WriteLn ('Building hash table ... ');


          { Insert data in hash table }

          Assign (TextFile, '..\DATA.TXT');
          System.Reset (TextFile);

          while not EOF(TextFile) do begin
              { Clear text variable }
              FillChar (MyText, SizeOf(MyText), 0);
              { Get text line from file }
              ReadLn (TextFile, MyText);
              { Add text to hash table if it not already exist }
              if Search(MyText) = 0 then Add (MyText);
              Inc (Index);
          end;

          { Verify that all elements was added correctly }
          if Index = Elements then WriteLn ('Hash table was correctly built.');

          { Resize and rebuild hash table; all hash codes will be
            recalculated }
          Resize(CapacityOfElements * 2); { Double the size }

          { Compare hash table data with original file lines }
          Assign (TextFile, '..\DATA.TXT');
          System.Reset (TextFile);

          while not EOF(TextFile) do begin
              { Clear text variable }
              FillChar (MyText, SizeOf(MyText), 0);
              { Get text line from file }
              ReadLn (TextFile, MyText);

              { Search for line two times and return text and index }
              Write (String(ElementPointer(Search(MyText))^) + ' (' +
                     StringNumber(Search(MyText), 4, 0) + ') = ' + MyText:40);
          end;

          WriteLn (Elements, ' table elements used (maximum ', Capacity,').');

          Intercept; { Hash table }
     end;

     if GlobalDataError then WriteLn ('Hashing failed - duplicate insertion?');

     WriteLn (Timer.StringMS);
end.