#ifndef __THREADTEMP_H__
#define __THREADTEMP_H__

#include <process.h>

#ifndef OS2_INCLUDED
   #ifndef INCL_DOS
     #define INCL_DOS
   #endif
	#include <os2.h>
#endif


#ifndef _exp_
   #ifdef __DLL__
      #define _exp_ _Export
   #else
      #define _exp_
   #endif
#endif


extern "C"{
void _exp_ ThreadStarter(void *);
}

class Thread{
protected:
	static ULONG _exp_ DefaultStackSize;

	APIRET Error;
	TID tid;
	ULONG StackSize;
	USHORT Started		:1;
	USHORT Suspended	:1;
	USHORT Running	:1;


	void SetThreadID(TID t){tid=t;}

public:
	_exp_ Thread(ULONG StackS=DefaultStackSize);

	TID GetThreadID(){return tid;}
	APIRET GetError(){return Error;}

	void ChangeStackSize(ULONG S){
		if(!Started) StackSize=S;
	}

	virtual void _exp_ Run(void)=0;
	void _exp_ Start();
	void _exp_ SuspendThread();
	void _exp_ KillThread();
	void _exp_ ResumeThread();
   void _exp_ ChangePR(ULONG Class,LONG Delta);
	int IsRunning(){return Running;}


   static void _exp_ SetDefaultStackSize(ULONG x);

friend void _exp_ ThreadStarter(void *);
};






template< class C,class Arg>class ClassThreadwArg:public Thread{

	C * TheClass;
	void (C::* TheFunc)(Arg*);
	Arg *TheArg;


public:
	ClassThreadwArg(C* tc,void (C::* tf)(Arg*), Arg* ta ):
		Thread(){

		TheClass=tc;
		TheFunc=tf;
		TheArg=ta;
	}

	ClassThreadwArg():Thread(){
		TheClass=NULL;
		TheFunc=NULL;
		TheArg=NULL;
	}

	void SetInstance(C* tc){TheClass=tc;}
	void SetFunc( void (C::* tf)(Arg*) ){TheFunc=tf;}
	void SetArg(Arg* ta){TheArg=ta;}
	void Run(){
		((TheClass)->*(TheFunc))((TheArg));
	}

};


template< class C,class Arg>class ClassThreadArg:public Thread{

	C * TheClass;
	void (C::* TheFunc)(Arg);
	Arg TheArg;


public:
	ClassThreadArg(C* tc,void (C::* tf)(Arg), Arg ta ):
		Thread(){

		TheClass=tc;
		TheFunc=tf;
		TheArg=ta;
	}

	ClassThreadArg():Thread(){
		TheClass=NULL;
		TheFunc=NULL;
		TheArg=NULL;
	}

	void SetInstance(C* tc){TheClass=tc;}
	void SetFunc( void (C::* tf)(Arg) ){TheFunc=tf;}
	void SetArg(Arg ta){TheArg=ta;}
	void Run(){
		((TheClass)->*(TheFunc))((TheArg));
	}

};


template< class C>class ClassThreadwoArg:public Thread{
	C * TheClass;
	void (C::* TheFunc)(void);

public:
	ClassThreadwoArg(C* tc,void (C::* tf)(void)):
		Thread(){

		TheClass=tc;
		TheFunc=tf;
	}

	ClassThreadwoArg(void (C::* tf)(void)):
		Thread(){

		TheFunc=tf;
	}


	ClassThreadwoArg():Thread(){
		TheClass=NULL;
		TheFunc=NULL;
	}


	ClassThreadwoArg(C* tc,void (C::* tf)(void), ULONG Size):
		Thread(Size){

		TheClass=tc;
		TheFunc=tf;
	}


	void SetInstance(C* tc){TheClass=tc;}
	void SetFunc( void (C::* tf)(void) ){TheFunc=tf;}

	void Run(){
		((TheClass)->*(TheFunc))();
	}

};


template< class C>class StaticClassThreadwoArg:public Thread{

//	 void (C::* TheFunc)(void);
	void (*TheFunc)(void);

public:
	StaticClassThreadwoArg(void (*tf)(void) ):
		Thread(){
		TheFunc=tf;
	}

	StaticClassThreadwoArg():Thread(){
		TheFunc=NULL;
	}

	StaticClassThreadwoArg(void (*tf)(void),ULONG Size ):
		Thread(Size){
		TheFunc=tf;
	}


	void SetFunc( void (*tf)(void) ){TheFunc=tf;}

	void Run(){
		((*TheFunc))();
	}

};


template<class C, class Arg>class StaticClassThreadArg:public Thread{

	void (*TheFunc)(Arg*);
   Arg *TheArg;

public:
	StaticClassThreadArg(void (*tf)(Arg*), Arg* TA ):
		Thread(){
		TheFunc=tf;
      TheArg=TA;
	}

	StaticClassThreadArg():Thread(){
		TheFunc=NULL;
	}

	StaticClassThreadArg(void (*tf)(Arg*),ULONG Size ):
		Thread(Size){
		TheFunc=tf;
	}


	void SetFunc( void (*tf)(Arg*) ){TheFunc=tf;}
   void SetArg(Arg *TA){TheArg=TA;}

	void Run(){
		((*TheFunc))(TheArg);
	}

};

#endif
