// File from fragments starting on page 340 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: NAMESPAC.CPP -- Namespace example fragments from Chapter 8

//: HEADER1.H
namespace MyLib {
  extern int X;
  void f();
  // ...
}

//: HEADER2.H
// Add more names to MyLib
namespace MyLib { // NOT a redefinition!
  extern int Y;
  void g();
  // ...
}

namespace BobsSuperDuperLibrary {
  class widget { /* ... */ };
  class poppit { /* ... */ };
  // ...
}
// Too much to type! I'll alias it:
namespace Bob = BobsSuperDuperLibrary;

namespace {
  class arm  { /* ... */ };
  class leg  { /* ... */ };
  class head { /* ... */ };
  class robot {
    arm Arm[4];
    leg Leg[16];
    head Head[3];
    // ...
  } Xanthan;
  int i, j, k;
}

namespace me {
  class us {
    //...
    friend you();
  };
}

namespace X {
  class Y {
    static int i;
  public:
    void f();
  };
  class Z;
  void foo();
}

int X::Y::i = 9;
class X::Z {
  int u, v, w;
public:
  Z(int I);
  int g();
};

X::Z::Z(int I) { u = v = w = I; }
int X::Z::g() { return u = v = w = 0; }
void X::foo() {
  X::Z a(1);
  a.g();
}

namespace math {
  enum sign { positive, negative };
  class integer {
    int i;
    sign s;
  public:
    integer(int I = 0) 
      : i(I),
        s(i >= 0 ? positive : negative)
    {}
    sign Sign() { return s; }
    void Sign(sign S) { s = S; }
    // ...
  };
  integer A, B, C;
  integer divide(integer, integer);
  // ...
}

void arithmetic() {
  using namespace math;
  integer X;
  X.Sign(positive);
}

void f() {
  using namespace math;
  integer A; // Hides math::A;
  A.Sign(negative);
  math::A.Sign(positive);
}

namespace calculation {
  class integer {};
  integer divide(integer, integer);
  // ...
}

void g() {
  using namespace math;
  using namespace calculation;
  // Everything's ok until:
  divide(1, 2); // Ambiguity
}

namespace U {
  void f() {};
  void g() {};
}

namespace V {
  void f() {};
  void g() {};
}

void func() {
  using namespace U; // Using directive
  using V::f; // Using declaration
  f(); // Calls V::f();
  U::f(); // Must fully qualify to call
}

namespace Q {
  using U::f;
  using V::g;
  // ...
}

void m() {
  using namespace Q;
  f(); // Calls U::f();
  g(); // Calls V::g();
}

main() {}
