// File from page 262 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: DATALOG.CPP -- Datapoint member function
#include "..\5\datalog.h"
#include <iomanip.h>
#include <string.h>

tm datapoint::Time() { return Tm; }

void datapoint::Time(tm T) { Tm = T; }

const char* datapoint::latitude() {
  return Latitude;
}

void datapoint::latitude(const char* l) {
  Latitude[BSZ - 1] = 0;
  strncpy(Latitude, l, BSZ - 1);
}

const char* datapoint::longitude() {
  return Longitude;
}

void datapoint::longitude(const char* l) {
  Longitude[BSZ - 1] = 0;
  strncpy(Longitude, l, BSZ - 1);
}

double datapoint::depth() { return Depth; }

void datapoint::depth(double d) { Depth = d; }

double datapoint::temperature() {
  return Temperature;
}

void datapoint::temperature(double t) {
  Temperature = t;
}

void datapoint::print(ostream& os) {
  os.setf(ios::fixed, ios::floatfield);
  os.precision(4);
  os.fill('0'); // Pad on left with '0'
  os << setw(2) << Time().tm_mon << '\\'
     << setw(2) << Time().tm_mday << '\\'
     << setw(2) << Time().tm_year << ' '
     << setw(2) << Time().tm_hour << ':'
     << setw(2) << Time().tm_min << ':'
     << setw(2) << Time().tm_sec;
  os.fill(' '); // Pad on left with ' '
  os << " Lat:" << setw(9) << latitude()
     << ", Long:" << setw(9) << longitude()
     << ", depth:" << setw(9) << depth()
     << ", temp:" << setw(9) << temperature()
     << endl;
}
