program showpass ;

uses dos,crt,jpstring ;

type
   GameDataRec = Record
      SquareNumber            : byte ;
      Description             : string ;
      Owner                   : string ;
      PurchasePrice           : integer ;
      RentalPrice             : integer ;
      SellPrice               : integer ;
   End ;

   GameRecord = Record
      GameData                : array [1..33] of GameDataRec ;
      PlayerName              : array [1..8] of string[35] ;
      PlayerScore             : array [1..8] of longint ;
      TurnCount               : array [1..8] of integer ;
      PlayerSquareNumber      : array [1..8] of byte ;
      LastDate                : array [1..8] of string[18] ;
      StartDate               : real ;
      OutOfGame               : array [1..8] of boolean ;
      InJail                  : array [1..8] of boolean ;
      GetOutOfJail            : array [1..8] of boolean ;
      GameId                  : STRING[12] ;
      DartScore               : array [1..8] OF INTEGER ;
      InUse                   : BOOLEAN ;
      NumberOfPlayers         : BYTE ;
      Password                : STRING[12] ;
   END ;

var
   gamefile  : file of gamerecord ;
   gameinfo  : gamerecord ;
   num,code,
   howmany   : integer ;
   ch        : char ;
   instr     : string ;


begin
   assign(gamefile,'ea.gam') ;
   {$I-} reset(gamefile) ; {$I+}
   if ioresult <> 0 then begin
      writeln ;
      writeln('Cannot open EA.GAM!') ;
      halt ;
   end ;
   howmany := filesize(gamefile) ;
   repeat
      writeln ;
      textcolor(15) ;
      writeln('ShowPass 1.1 for Eclectic Avenue 2.0x') ;
      writeln ;
      textcolor(10) ;
      write('Enter the game number to show restrictions for [1..'+
             itoa(howmany)+']: ') ;
      textcolor(7) ;
      readln(instr) ;
      if instr = '' then begin
         close(gamefile) ;
         halt ;
      end ;
      val(instr,num,code) ;
      if (num>0) and (num <= howmany) and (code=0) then begin
         seek(gamefile,num-1) ;
         read(gamefile,gameinfo) ;
         writeln ;
         textcolor(11) ;
         writeln('Restrictions for game #'+itoa(num)+':') ;
         writeln ;
         textcolor(13) ;
         writeln('Number of players:   ',gameinfo.numberofplayers) ;
         if gameinfo.password = '' then gameinfo.password := 'None' ;
         writeln('Password:            ',gameinfo.password) ;
         writeln ;
         textcolor(14) ;
         write('-PAUSED-') ;
         ch := readkey ;
         writeln ;
      end else begin
         writeln ;
         textcolor(12) ;
         writeln('Invalid entry!') ;
         writeln ;
      end ;
   until instr = '' ;
   close(gamefile) ;
   textcolor(7) ;
   writeln ;
end.


