UNIT REMDEF ;

INTERFACE

TYPE
   FigRec  = Record
                Tnode          : STRING[2] ;
                SysName        : STRING ;
                OpName         : STRING ;
                DoorSys        : BOOLEAN ;
                DropPath       : STRING ;
                UseFossil      : BOOLEAN ;
                CName          : BYTE ;
                ComAddress     : INTEGER ;
                IRQNum         : INTEGER ;
                LockRate       : LONGINT ;
                KeyLine        : STRING ;
                AdoptedBy      : STRING ;
                MultiLine      : BOOLEAN ;
                CommDrive      : STRING ;
                TextBull,
                AnsiBull       : STRING ;

                Snoop          : BOOLEAN ;
                UseHandles     : BOOLEAN ;
                MaxParticipate : BYTE ;
                MaxGamesStarted: BYTE ;
                TurnsPerGame   : BYTE ;
                GameRetention  : BYTE ;
                StartingNumber : BYTE ;
                MaxDarts       : BYTE ;
                MaxGambles     : BYTE ;
                AllowRestrictions:BOOLEAN ;
                inactivedays   : byte ;
                DungeonEnable  : byte ;
             END ;


   UserRecord = Record
      Name            : string[35] ;
      Alias           : string[35] ;
      Sex             : char ;
      Preferrence     : char ;
      GamesStarted    : byte ;
      LastStarted     : real ;
      LastOn          : real ;
      GamesWon        : integer ;
   End ;

   GameDataRec = Record
      SquareNumber            : byte ;
      Description             : string ;
      Owner                   : string ;
      PurchasePrice           : integer ;
      RentalPrice             : integer ;
      SellPrice               : integer ;
   End ;

   GameRecord = Record
      GameData                : array [1..33] of GameDataRec ;
      PlayerName              : array [1..8] of string[35] ;
      PlayerScore             : array [1..8] of longint ;
      TurnCount               : array [1..8] of integer ;
      PlayerSquareNumber      : array [1..8] of byte ;
      LastDate                : array [1..8] of string[18] ;
      StartDate               : real ;
      OutOfGame               : array [1..8] of boolean ;
      InJail                  : array [1..8] of boolean ;
      GetOutOfJail            : array [1..8] of boolean ;
      GameId                  : STRING[12] ;
      DartScore               : array [1..8] OF INTEGER ;
      InUse                   : Boolean ;
      NumberofPlayers         : BYTE ;
      Password                : STRING[12] ;
   END ;

   TournRec = Record
                 Name       : STRING[35] ;
                 TotalScore : LONGINT ;
                 GamesWon   : INTEGER ;
              END ;

   MsgRecord = RECORD
                  WhoTo,
                  From,
                  Subject      : STRING[35] ;
                  DTG          : STRING[25] ;
                  FileName     : STRING[25] ;
                  CreationDate : REAL ;
                  Private      : BOOLEAN ;
                  Received     : BOOLEAN ;
               END ;

   TrivRec = RECORD
                QuestionFile  : STRING ;
                Answer        : CHAR ;
                Worth         : INTEGER ;
             END ;

   TrivTrackRec = RECORD
                     TriviaNumber    : INTEGER ;
                  END ;

VAR
   UserFile                   : FILE OF UserRecord ;
   User                       : UserRecord ;
   GameFile                   : FILE OF GameRecord ;
   GameInfo                   : GameRecord ;
   ConfigFile                 : FILE OF FigRec ;
   Info                       : FigRec ;
   ConfigFileName             : STRING ;
   TournFile                  : FILE OF TournRec ;
   Tourn                      : TournRec ;
   MsgFile                    : FILE OF MsgRecord ;
   Msg                        : MsgRecord ;
   TrivNumFile                : FILE OF TrivTrackRec ;
   TrivNumInfo                : TrivTrackRec ;
   TrivFile                   : FILE OF TrivRec ;
   Trivia                     : TrivRec ;


IMPLEMENTATION
BEGIN
END.
