{$R-,S+,O+,A-,E-,N-,D+,L-,F+}

(**********************************************************************)
(*                                                                    *)
(*                  E D I T O R   V E R S I O N  1.00                 *)
(*                                                                    *)
(*                   Written entirely by John Parlin                  *)
(*                                                                    *)
(**********************************************************************)


UNIT Editor ;

INTERFACE

USES dos, crt, JPDoor32 ;
{$V-}


TYPE
   NameString  =  string[35] ;
   MsgName     =  string[8] ;
   Str2        =  string[2] ;
   Str45       =  string[45] ;
   MsgRec = record
               posted_hour         : word ;
               posted_min          : word ;
               posted_sec          : word ;
               posted_sec100       : word ;
               posted_year         : word ;
               posted_month        : word ;
               posted_date         : word ;
               posted_day          : word ;
               read_hour           : word ;
               read_min            : word ;
               read_sec            : word ;
               read_sec100         : word ;
               read_year           : word ;
               read_month          : word ;
               read_date           : word ;
               read_day            : word ;
               to_name             : NameString ;
               from_name           : NameString ;
               subject             : string[45] ;
               private             : boolean ;
               text_body           : array [1..99] of string[80] ;
            end ;

VAR
   MsgFile                         : file of MsgRec ;
   Msg                             : MsgRec ;
   MaxLines                        : byte ;

{ functions/procedures - declarations }

function MakeMessage(ToName,FromName : NameString ;
                     subject : Str45 ;
                     private : boolean) : MsgName ;

implementation



function FixByte(n:word) : Str2 ;
var
   temp    : Str2 ;
   solve   : Str2 ;
begin
   str(n,temp) ;
   case n of
      0..9 : solve := concat('0',temp) ;
      else solve := temp ;
   end ;
   FixByte := solve ;
end ;



function dtg(n:byte) : string ;
{ if n = 1 then posted dtg else read dtg }
var
   ts      : string ;
begin
   ts := '' ;
   if n = 1 then begin
      ts := fixbyte(msg.posted_month) + '-' +
            fixbyte(msg.posted_date) + '-' +
            itoa(msg.posted_year) + ' ' +
            fixbyte(msg.posted_hour) + ':' +
            fixbyte(msg.posted_min) ;
   end else begin
      ts := fixbyte(msg.read_month) + '-' +
            fixbyte(msg.read_date) + '-' +
            itoa(msg.read_year) + ' ' +
            fixbyte(msg.read_hour) + ':' +
            fixbyte(msg.read_min) ;
   end ;
   dtg := ts ;
end ;



procedure init_msg_struct ;
var
   i      : byte ;
begin
   getdate(msg.posted_year,msg.posted_month,msg.posted_date,msg.posted_day) ;
   gettime(msg.posted_hour,msg.posted_min,msg.posted_sec,msg.posted_sec100) ;
   msg.read_hour := 0 ;
   msg.read_min := 0 ;
   msg.read_sec := 0 ;
   msg.read_sec100 := 0 ;
   msg.read_year := 0 ;
   msg.read_month := 0 ;
   msg.read_date := 0 ;
   msg.read_day := 0 ;
   msg.to_name := '' ;
   msg.from_name := '' ;
   msg.subject := '' ;
   msg.private := false ;
   for i := 1 to 99 do msg.text_body[i] := '' ;
end ;



procedure msg_menu ;
begin
   crlf ;
   sdisplay(0,14,0,'Message commands: ') ;
   sdisplay(0,15,0,'A>bort, E>dit, L>ist, S>ave: ') ;
end ;
 


function MakeMessage(ToName,FromName : NameString ;
                     subject : Str45 ;
                     private : boolean) : MsgName ;
var
   i,j         : byte ;
   c,cc        : char ;
   start_pos   : byte ;
   tstr,tstr2  : string ;
   num,code    : integer ;

begin
   init_msg_struct ;
   msg.to_name := ToName ;
   msg.from_name := FromName ;
   msg.subject := subject ;
   msg.private := private ;
   i := 42 - length(ToName) ;
   j := 40 - length(FromName) ;
   clearscreen ;
   sdisplay(0,14,0,'To:   ') ;
   sdisplay(0,3,0,ToName+MkString(i,#32)) ;
   sdisplay(0,11,0,'Posted: ') ;
   display(0,15,0,dtg(1)) ;
   sdisplay(0,14,0,'From: ') ;
   sdisplay(0,3,0,FromName+MkString(j,#32)) ;
   sdisplay(0,11,0,'Received: ') ;
   display(0,15,0,'No') ;
   display(0,15,0,MkString(79,'')) ;
   display(0,14,0,'Enter up to 99 lines of text to be sent to '+formatstr(ToName)+'.') ;
   display(0,14,0,'Enter a blank line or press <ENTER> past line 99 for message menu.') ;
   display(0,15,0,MkString(79,'')) ;
   scrap_entry := '' ;
   for i := 1 to 99 do begin
      sdisplay(0,14,0,fixbyte(i)) ;
      sdisplay(0,7,0,': ') ;
      msg.text_body[i] := getline(72,8,3) ;
      if msg.text_body[i] = '' then begin
         maxlines := i ;
         i := 99 ;
      end ;
   end ;
   repeat
      msg_menu ;
      repeat
         c  := upcase(getchar) ;
      until c in ['A','E','L','S'] ;
      display(0,15,0,c) ;
      case c of
         'A' : begin
                  crlf ;
                  sdisplay(0,14,0,'Abort message? [y,n]: ') ;
                  repeat
                     cc := upcase(getchar) ;
                  until cc in ['Y','N'] ;
                  display(0,15,0,cc) ;
                  if cc = 'Y' then begin
                     crlf ;
                     display(0,12,0,'Message aborted...') ;
                     crlf ;
                     MakeMessage := '' ;
                     exit ;
                  end ;
               end ;
         'E' : begin
                  crlf ;
                  sdisplay(0,14,0,'Edit line number: ') ;
                  tstr := getinput('',0,2) ;
                  val(tstr,num,code) ;
                  if (tstr <> '') and (num > 0) and (num < maxlines)
                  and (code = 0) then begin
                     crlf ;
                     display(0,14,0,'Current line contents: ') ;
                     crlf ;
                     sdisplay(0,14,0,fixbyte(num)) ;
                      sdisplay(0,7,0,': ') ;
                     display(0,7,0,msg.text_body[num]) ;
                     crlf ;
                     display(0,14,0,'Enter text to be replaced: ') ;
                     crlf ;
                     sdisplay(0,11,0,'Old String: ') ;
                     tstr := getinput('',0,70) ;
                     if (tstr <> '')
                     and (pos(tstr,msg.text_body[num]) > 0) then begin
                        crlf ;
                        display(0,14,0,'Enter replacement text: ') ;
                        crlf ;
                        sdisplay(0,11,0,'New String: ') ;
                        tstr2 := getinput('',0,70) ;
                        if tstr2 <> '' then begin
                           start_pos := pos(tstr,msg.text_body[num]) ;
                           delete(msg.text_body[num],start_pos,length(tstr)) ;
                           insert(tstr2,msg.text_body[num],start_pos) ;
                        end ;
                        crlf ;
                        display(0,14,0,'New line reads: ') ;
                        crlf ;
                        sdisplay(0,14,0,fixbyte(num)) ;
                        sdisplay(0,7,0,': ') ;
                        display(0,7,0,msg.text_body[num]) ;
                        crlf ;
                        more('Press any key',14) ;
                     end ;
                  end else begin
                     if tstr <> '' then begin
                        crlf ;
                        display(0,14,0,'Entry out of range.') ;
                     end ;
                  end ;
               end ;
         'L' : begin
                  crlf ;
                  display(0,14,0,'Message reads:') ;
                  crlf ;
                  for i := 1 to maxlines do begin
                     sdisplay(0,14,0,fixbyte(i)) ;
                     sdisplay(0,7,0,': ') ;
                     display(0,7,0,msg.text_body[i]) ;
                  end ;
                  more('Press any key',12) ;
               end ;
         'S' : begin
                  crlf ;
                  display(0,11,0,'Saving message...') ;
                  tstr := fixbyte(msg.posted_hour)+
                          fixbyte(msg.posted_min)+
                          fixbyte(msg.posted_sec)+'.'+
                          itoa(msg.posted_sec100) ;
                  assign(msgfile,tstr) ;
                  rewrite(msgfile) ;
                  write(msgfile,Msg) ;
                  close(msgfile) ;
                  MakeMessage := tstr ;
                  exit ;
               end ;
      end ; { case }
   until c = 'S' ;
end ;


begin
end.