UNIT Dungeon ;

INTERFACE

USES DOS,CRT,JPDoor32,EADef,EASup,EAUtils ;


PROCEDURE PlayDungeon(fall:boolean) ;


IMPLEMENTATION

CONST
   guy = #1 ;
   top = 4 ;
   bottom = 16 ;
   leftside = 8 ;
   rightside = 72 ;
   Hwall = '' ;
   Vwall = '' ;


VAR
   grid             : array[5..15] of array[9..71] of char ;
   rowpos,
   colpos,
   lastrow,
   lastcol          : byte ;
   bailedout,
   alldone          : boolean ;
   initialscore,
   scorewon,
   scorelost        : longint ;
   initialturns,
   turnswon,
   turnslost        : byte ;
   ch               : char ;


PROCEDURE Prompt ;
BEGIN
   clearstatusarea ;
   cursorpos(20,1) ;
   sdisplay(0,7,0,'Legend:  M=Monster T=Turn Treasure $=Cash Treasure U=Up/Exit B=Bail Bond') ;
   cursorpos(22,1) ;
   sdisplay(0,15,0,'Move commands: 8=Up 2=Down 4=Left 6=Right Q=Quit (Use NUMlock)') ;
END ;

PROCEDURE PressEnter ;
VAR
   ch   : CHAR ;
BEGIN
   CursorPos(23,1) ;
   sDisplay(0,13,0,'Press <ENTER> to continue') ;
   repeat
      ch := getchar ;
   until ch = #13 ;
END ;


PROCEDURE EraseInner ;
VAR
   i   : BYTE ;
BEGIN
   FOR i := 5 TO 15 DO BEGIN
      CursorPos(i,9) ;
      sDisplay(0,15,0,'                                                               ') ;
   END ;
END ;


PROCEDURE ClearBoard(fall:boolean) ;
BEGIN
   clearstatusarea ;
   cursorpos(20,1) ;
   if not fall then begin
      sdisplay(0,7,0,'Hey look!  A manhole cover!  You somehow manage to open it.  Peering') ;
      cursorpos(21,1) ;
      sdisplay(0,7,0,'down into the darkness you decide to climb in to take a look, but you lose') ;
      cursorpos(22,1) ;
      display(0,7,0,'your footing on the moldy, wet ladder and begin falling....') ;
   end else begin
      sdisplay(0,7,0,'YIKES!! Someone left a manhole cover open!  Not looking where you are') ;
      cursorpos(21,1) ;
      sdisplay(0,7,0,'walking, you walk right into the manhole.  Luckily, you didn''t hit your') ;
      cursorpos(22,1) ;
      sdisplay(0,7,0,'head on the ladder.  You watch the ladder stream by your face as you fall...') ;
   end ;
   PressEnter ;
   EraseInner ;
END ;

PROCEDURE ClearBoard2 ;
BEGIN
   clearstatusarea ;
   cursorpos(20,1) ;
   sdisplay(0,7,0,'It smells down here!  Now you have to try to find the way out.  You might') ;
   cursorpos(21,1) ;
   sdisplay(0,7,0,'even find a treasure or two while you''re looking.  But beware of the monsters') ;
   cursorpos(22,1) ;
   display(0,7,0,'lurking about....') ;
   PressEnter ;
END ;


PROCEDURE WMsg(instr:STRING) ;
BEGIN
   ClearStatusArea ;
   CursorPos(20,1) ;
   sDisplay(0,15,0,#27+'[K'+instr) ;
END ;


PROCEDURE InitArray ;
VAR
   i  : byte ;
   j  : byte ;
BEGIN
   for i := 5 to 15 do begin
      for j := 9 to 71 do grid[i,j] := #32 ;
   end ;
   grid[9,39] := '' ;
END ;


PROCEDURE SetUpWalls ;
VAR
   a,j,c,r,l   : BYTE ;
   Ok          : BOOLEAN ;
BEGIN
   { select 5 vertical walls 3 to 5 characters in length }
   for a := 1 to 8 do begin
      repeat
         { select length of wall }
         repeat
            l := random(8) ;
         until (l > 2) and (l < 6) ;

         { select starting row of vertical wall }
         repeat
            r := random(15) ;
         until (r > 4) and (r < (16-l)) ;

         { select starting column of vertical wall }
         repeat
            c := random(71) ;
         until (c > 9) and (c < 71) ;

         { check to see if wall can be placed here }
         Ok := true ;
         for j := r to r+l do begin
            if grid[j,c] <> #32 then begin
               Ok := false ;
               j := r+l ;
            end ;
         end ;
         if Ok then for j := r to r+l do grid[j,c] := Vwall ;
      until Ok ;
   end ;
   { select 5 horizontal walls 3 to 8 characters in length }
   for a := 1 to 10 do begin
      repeat
         { select length of wall }
         repeat
            l := random(8) ;
         until (l > 2) and (l < 9) ;
         { select starting column of horizontal wall }
         repeat
            c := random(72) ;
         until (c > 8) and (c < (72-l)) ;
         { select starting row of horizontal wall }
         repeat
            r := random(16) ;
         until (r > 4) and (r < 16) ;
         { check to see if wall can be placed here }
         Ok := true ;
         for j := c to c+l do begin
            if grid[r,j] <> #32 then begin
               Ok := false ;
               j := c+l ;
            end ;
         end ;
         if Ok then for j := c to c+l do grid[r,j] := Hwall ;
      until Ok ;
   end ;
END ;


PROCEDURE PlaceCharacter(CharToPlace:CHAR) ;
VAR
   r,c    : BYTE ;
   Ok     : BOOLEAN ;
BEGIN
   Ok := false ;
   repeat
      { select a row }
      repeat
         r := random(25) ;
      until (r > 4) and (r < 16) ;
      { select a column }
      repeat
         c := random(100) ;
      until (c > 8) and (c < 72) ;
      { check if okay to place here }
      if grid[r,c] = #32 then begin
         Ok := true ;
         grid[r,c] := CharToPlace ;
      end ;
   until Ok ;
END ;


Function OwnProperty : boolean ;
var
   tbool   : boolean ;
   i       : byte ;
begin
   tbool := false ;
   for i := 1 to 33 do begin
      if gameinfo.gamedata[i].owner = alias then tbool := true ;
   end ;
   OwnProperty := tbool ;
end ;


PROCEDURE SetUp ;
VAR
   i        : BYTE ;
BEGIN
   InitArray ;
   SetUpWalls ;
   { place the up/exit character in grid }
   PlaceCharacter('U') ;
   { place three monsters in grid }
   for i := 1 to 3 do PlaceCharacter('M') ;
   { place three money treasures in grid }
   for i := 1 to 3 do PlaceCharacter('$') ;
   { place two extra turn treasures in grid }
   for i := 1 to 2 do PlaceCharacter('T') ;
   { if no bail bond card is held, place one in grid }
   if not getoutofjail then PlaceCharacter('B') ;
   { if one property is owned, place a realestate agent }
   if ownproperty then PlaceCharacter('R') ;
END ;


PROCEDURE RevealMap ;
VAR
   i,j   : BYTE ;
BEGIN
   for i := 5 to 15 do begin
      cursorpos(i,9) ;
      for j := 9 to 71 do begin
         if grid[i,j] = #32 then sdisplay(0,3,0,'')
           else sdisplay(0,11,0,grid[i,j]) ;
      end ;
   end ;
END ;


PROCEDURE PutDude ;
BEGIN
   cursorpos(lastrow,lastcol) ;
   if grid[lastrow,lastcol] = #32 then sDisplay(0,7,0,'')
      else sdisplay(0,14,0,grid[lastrow,lastcol]) ;
   cursorpos(rowpos,colpos) ;
   sdisplay(0,15,0,guy) ;
   lastrow := rowpos ;
   lastcol := colpos ;
   if (rowpos < 15) and (grid[rowpos+1,colpos] in [hwall,vwall,'$','T','U']) then begin
      cursorpos(rowpos+1,colpos) ;
      sdisplay(0,11,0,grid[rowpos+1,colpos]) ;
   end ;
   if (rowpos > 5) and (grid[rowpos-1,colpos] in [hwall,vwall,'$','T','U']) then begin
      cursorpos(rowpos-1,colpos) ;
      sdisplay(0,11,0,grid[rowpos-1,colpos]) ;
   end ;
   if (colpos < 71) and (grid[rowpos,colpos+1] in [hwall,vwall,'$','T','U']) then begin
      cursorpos(rowpos,colpos+1) ;
      sdisplay(0,11,0,grid[rowpos,colpos+1]) ;
   end ;
   if (colpos > 9) and (grid[rowpos,colpos-1] in [hwall,vwall,'$','T','U']) then begin
      cursorpos(rowpos,colpos-1) ;
      sdisplay(0,11,0,grid[rowpos,colpos-1]) ;
   end ;
END ;


PROCEDURE UpExit ;
VAR
   ch : CHAR ;
BEGIN
   alldone := true ;
   Cursorpos(rowpos,colpos) ;
   sDisplay(0,14,1,'U') ;
   WMsg('You found the way out!  Press <ENTER>.') ;
   repeat
      ch := getchar ;
   until ch = #13 ;
   clearstatusarea ;
   Wmsg('Revealing map...') ;
   revealmap ;
   Wmsg('Press <ENTER>') ;
   ch := getchar ;
END ;


PROCEDURE RealestateAgent ;
VAR
   howmany,
   i,j       : byte ;
   property  : array[1..22] of string ;
BEGIN
   cursorpos(rowpos,colpos) ;
   sdisplay(0,14,1,'R') ;
   howmany := 0 ;
   for i := 1 to 33 do property[i] := '' ;
   for i := 1 to 33 do begin
      if gameinfo.gamedata[i].owner = alias then begin
         inc(howmany) ;
         property[howmany] := gameinfo.gamedata[i].description ;
      end ;
   end ;
   repeat
      j := random(howmany+10) ;
   until (j >= 1) and (j <= howmany) ;
   ClearStatusArea ;
   Cursorpos(20,1) ;
   sdisplay(0,14,0,'REAL ESTATE AGENT!  He makes your head spin with his fast talk as he convinces') ;
   cursorpos(21,1) ;
   sdisplay(0,14,0,'you to sign a purchase agreement.  Without realizing it, you agreed to sell') ;
   cursorpos(22,1) ;
   sdisplay(0,11,0,property[j]) ;
   sdisplay(0,14,0,' for $100 less than market value!') ;
   for i := 1 to 33 do begin
      if gameinfo.gamedata[i].description = property[j] then begin
         gameinfo.gamedata[i].owner := '' ;
         inc(initialscore,(gameinfo.gamedata[i].purchaseprice - 100)) ;
         i := 33 ;
      end ;
   end ;
   PressEnter ;
   prompt ;
   putdude ;
   grid[rowpos,colpos] := #32 ;
END ;


PROCEDURE Monster ;
VAR
   j     : integer ;
   k     : longint ;
BEGIN
   cursorpos(rowpos,colpos) ;
   sdisplay(0,14,1,'M') ;
   ClearStatusArea ;
   Cursorpos(20,1) ;
   sdisplay(0,14,0,'You found a MONSTER and he wants your ') ;
   repeat
      j := random(10) ;
   until (j > 4) and (j < 7) ;
   if (Info.TurnsPerGame - (TurnCount+turnslost)) < 2 then j := 5 ;
   if j = 5 then begin
      sdisplay(0,14,0,'cash!') ;
      if (playerscore-scorelost) < 2 then begin
         Cursorpos(21,1) ;
         sdisplay(0,15,0,'"YOU DON''T HAVE ANY!", he screams as he scurries off.') ;
      end else begin
         repeat
            k := random((playerscore-scorelost)) ;
         until (k > 0) and (k <= (playerscore-scorelost)) ;
         if k > 900 then k := 900 ;
         if (k < 100) and ((playerscore-scorelost) > 100) then k := 100 ;
         inc(scorelost,k) ;
         cursorpos(21,1) ;
         sdisplay(0,15,0,'After stealing $'+itoa(k)+' he runs off into the darkness.') ;
      end ;
   end else begin
      sdisplay(0,14,0,'turns!') ;
      if ((Info.TurnsPerGame - TurnCount)-turnslost) < 1 then begin
         cursorpos(21,1) ;
         sdisplay(0,10,0,'"AAAARRGH!  You don''t have any!", said the monster.') ;
      end else begin
         repeat
            k := random(10) ;
         until (k > 0) and (k <= (Info.TurnsPerGame-TurnCount)-turnslost) and (k < 3) ;
         inc(turnslost,k) ;
         cursorpos(21,1) ;
         sdisplay(0,15,0,'After stealing '+itoa(k)+' turns from you, he runs off into the darkness.') ;
      end ;
   end ;
   PressEnter ;
   prompt ;
   putdude ;
   grid[rowpos,colpos] := #32 ;
END ;


PROCEDURE Cash ;
VAR
   j     : integer ;
BEGIN
   cursorpos(rowpos,colpos) ;
   sdisplay(0,13,1,'$') ;
   ClearStatusArea ;
   Cursorpos(20,1) ;
   sdisplay(0,14,0,'You found a CASH treasure of $') ;
   repeat
      j := random(1001) ;
   until (j > 100) and (j < 1001) ;
   inc(scorewon,j) ;
   sdisplay(0,14,0,itoa(j)+'!') ;
   PressEnter ;
   prompt ;
   putdude ;
   grid[rowpos,colpos] := #32 ;
END ;


PROCEDURE FreeTurns ;
VAR
   j     : integer ;
BEGIN
   cursorpos(rowpos,colpos) ;
   sdisplay(0,13,1,'T') ;
   ClearStatusArea ;
   Cursorpos(20,1) ;
   sdisplay(0,14,0,'You found a treasure worth ') ;
   repeat
      j := random(100) ;
   until (j > 0) and (j < 4) ;
   inc(turnswon,j) ;
   sdisplay(0,14,0,itoa(j)+' free turn(s)!') ;
   PressEnter ;
   prompt ;
   putdude ;
   grid[rowpos,colpos] := #32 ;
END ;


PROCEDURE BailBond ;
BEGIN
   cursorpos(rowpos,colpos) ;
   sdisplay(0,13,1,'B') ;
   ClearStatusArea ;
   Cursorpos(20,1) ;
   sdisplay(0,14,0,'You found a free bail bond card!') ;
   GetOutOfJail := true ;
   PressEnter ;
   prompt ;
   putdude ;
   grid[rowpos,colpos] := #32 ;
END ;


PROCEDURE AbandonGame ;
VAR
   ch    : CHAR ;
BEGIN
   clearstatusarea ;
   YesNo ;
   cursorpos(20,1) ;
   sdisplay(0,12,1,'WARNING! ') ;
   sdisplay(0,12,0,'Bail out now and you lose any treasures you may have discovered and') ;
   cursorpos(21,1) ;
   sdisplay(0,12,0,'you will still suffer any losses incurred.') ;
   cursorpos(22,1) ;
   sdisplay(0,14,0,'Bail? [y,n]: ') ;
   repeat
      ch := upcase(getchar) ;
   until ch in ['Y','N'] ;
   sdisplay(0,15,0,ch) ;
   if ch = 'Y' then begin
      PlayerScore := initialscore - scorelost ;
      TurnCount := initialturns + turnslost ;
      cursorpos(23,1) ;
      sdisplay(0,12,0,'Returning all discovered treasures...') ;
      alldone := true ;
      bailedout := true ;
   end else begin
      ResetButtons ;
      AddButton('U') ;
      AddButton('D') ;
      AddButton('L') ;
      AddButton('R') ;
      AddButton('Q') ;
      SendButtons(#13) ;
      cursorpos(23,1) ;
      sdisplay(0,10,0,'That''s the spirit!') ;
      delay(2000) ;
   end ;
end ;


PROCEDURE MoveError ;
BEGIN
END ;


PROCEDURE CheckSpace ;
BEGIN
   case grid[rowpos,colpos] of
      'U' : begin
               UpExit ;
            end ;
      'M' : begin
               Monster ;
            end ;
      '$' : begin
               Cash ;
            end ;
      'T' : begin
               FreeTurns ;
            end ;
      'B' : begin
               BailBond ;
            end ;
      'R' : begin
               RealestateAgent ;
            end ;
   end ;
END ;




PROCEDURE MoveDude ;
VAR
   ch        : CHAR ;
BEGIN
   Prompt ;
   repeat
      repeat
         ch := upcase(getchar) ;
         if (ch = '[') or (ch = ']') then begin
            clearstatusarea ;
            wmsg('Turn your NUM LOCK on!') ;
            delay(2500) ;
            prompt ;
         end ;
      until ch in ['8','U','2','D','6','R','4','L','Q'] ;
      case ch of
         'Q' : begin
                  AbandonGame ;
                  Prompt ;
               end ;
         '8','U' : begin
                  if rowpos = 5 then moveerror
                    else
                  if (grid[rowpos-1,colpos] = hwall) or
                  (grid[rowpos-1,colpos] = vwall) then moveerror else begin
                     dec(rowpos) ;
                     putdude ;
                     checkspace ;
                  end ;
               end ;
         '2','D' : begin
                  if rowpos = 15 then moveerror
                    else
                  if (grid[rowpos+1,colpos] = hwall) or
                  (grid[rowpos+1,colpos] = vwall) then moveerror else begin
                     inc(rowpos) ;
                     putdude ;
                     checkspace ;
                  end ;
               end ;
         '4','L' : begin
                  if colpos = 9 then moveerror
                     else
                  if (grid[rowpos,colpos-1] = hwall) or
                  (grid[rowpos,colpos-1] = vwall) then moveerror else begin
                     dec(colpos) ;
                     putdude ;
                     checkspace ;
                  end ;
               end ;
         '6','R' : begin
                  if colpos = 71 then moveerror
                    else
                  if (grid[rowpos,colpos+1] = hwall) or
                  (grid[rowpos,colpos+1] = vwall) then moveerror else begin
                     inc(colpos) ;
                     putdude ;
                     checkspace ;
                  end ;
               end ;
      end ; { case }
   until alldone ;
END ;



PROCEDURE PlayDungeon(fall:boolean) ;
BEGIN
   bailedout := false ;
   initialscore := playerscore ;
   initialturns := turncount ;
   scorewon := 0 ;
   scorelost := 0 ;
   turnswon := 0 ;
   turnslost := 0 ;
   SetUp ;
   alldone := false ;
   rowpos := 9 ;
   colpos := 39 ;
   lastrow := 9 ;
   lastcol := 39 ;
   ClearBoard(fall) ;
   putdude ;
   ClearBoard2 ;
   movedude ;
   EraseInner ;
   if not bailedout then begin
      playerscore := (initialscore + scorewon) - scorelost ;
      turncount := (initialturns - turnswon) + turnslost ;
   end ;
   cursorpos(6,12) ;
   sdisplay(0,15,0,'Money you had coming in:   ') ;
   sdisplay(0,7,0,'$'+itoa(initialscore)) ;
   cursorpos(7,12) ;
   sdisplay(0,15,0,'Money you have going out:  ') ;
   sdisplay(0,7,0,'$'+itoa(playerscore)) ;
   cursorpos(9,12) ;
   sdisplay(0,15,0,'Turns you had coming in:   ') ;
   sdisplay(0,7,0,itoa((Info.TurnsPerGame - InitialTurns))) ;
   cursorpos(10,12) ;
   sdisplay(0,15,0,'Turns you have going out:  ') ;
   sdisplay(0,7,0,itoa((Info.TurnsPerGame - TurnCount))) ;
   cursorpos(12,12) ;
   sdisplay(0,13,0,'Press <ENTER> to continue') ;
   repeat
      ch := getchar ;
   until ch = #13 ;
END ;

BEGIN
END.