UNIT darts ;

INTERFACE

USES DOS,CRT,JPDoor32,EADef,EASup,EAUtils ;

CONST
   arrow  = '->' ;

PROCEDURE PlayDarts ;


IMPLEMENTATION

VAR
   Throws    : BYTE ;

PROCEDURE ClearBoard ;
VAR
   i : BYTE ;
BEGIN
   FOR i := 5 TO 15 DO BEGIN
      CursorPos(i,9) ;
      sDisplay(0,15,0,'                                                               ') ;
   END ;
END ;

PROCEDURE DrawTargetStrip ;
BEGIN
   CursorPos(5,70) ;
   sDisplay(5,15,0,'05') ;
   CursorPos(6,70) ;
   sDisplay(5,15,0,'  ') ;
   CursorPos(7,70) ;
   sDisplay(1,15,0,'10') ;
   CursorPos(8,70) ;
   sDisplay(1,15,0,'  ') ;
   CursorPos(9,70) ;
   sDisplay(4,15,0,'20') ;
   CursorPos(10,70) ;
   sDisplay(2,14,0,'50') ;
   CursorPos(11,70) ;
   sDisplay(4,15,0,'20') ;
   CursorPos(12,70) ;
   sDisplay(1,15,0,'  ') ;
   CursorPos(13,70) ;
   sDisplay(1,15,0,'10') ;
   CursorPos(14,70) ;
   sDisplay(5,15,0,'  ') ;
   CursorPos(15,70) ;
   sDisplay(5,15,0,'05') ;
   CursorPos(15,15) ;
   sDisplay(0,15,0,' ') ;
END ;

PROCEDURE WMsg(instr:STRING) ;
BEGIN
   CursorPos(20,1) ;
   sDisplay(0,15,0,#27+'[K'+instr) ;
END ;

PROCEDURE ShowWinnings(rowpos:BYTE) ;
VAR
   Amount    : BYTE ;
BEGIN
   CASE rowpos OF
      5,6,14,15     : Amount := 5 ;
      7,8,12,13     : Amount := 10 ;
      9,11          : Amount := 20 ;
      10            : Amount := 50 ;
   END ;
   WMsg('You score '+ItoA(Amount)+' points in the tournament and $'+
        ItoA((Amount*2))+' in cash.') ;
   INC(DartScore,Amount) ;
   INC(PlayerScore,(Amount*2)) ;
   Pause ;
END ;

PROCEDURE ShowDartScores ;
VAR
   i,row    : BYTE ;
   dh       : CHAR ;
BEGIN
   ClearBoard ;
   CursorPos(5,9) ;
   sDisplay(0,13,0,Center('AL''S BAR DART TOURNAMENT SCORES FOR GAME #'+
                   ItoA(GameNumber),63)) ;
   CursorPos(6,9) ;
   sDisplay(0,15,0,MkString(63,'')) ;
   row := 6 ;
   FOR i := 1 TO 8 DO BEGIN
      IF GameInfo.PlayerName[i] <> '' THEN BEGIN
         INC(row) ;
         CursorPos(row,9) ;
         IF GameInfo.PlayerName[i] = Alias THEN
            sDisplay(0,6,0,Center(GameInfo.PlayerName[i]+' : '+
                                  ItoA(DartScore)+' points',63))
         ELSE
            sDisplay(0,6,0,Center(GameInfo.PlayerName[i]+' : '+
                                  ItoA(GameInfo.DartScore[i])+' points',63)) ;
      END ;
   END ;
   ClearStatusArea ;
   Cursorpos(20,1) ;
   sdisplay(0,10,0,'Press [SPACEBAR] to continue:') ;
   repeat
      dh := getchar ;
   until dh = #32 ;
END ;


PROCEDURE Prompt ;
BEGIN
   WMsg('[Score: '+ItoA(DartScore)+
        '  Throws Left: '+ItoA((Info.MaxDarts-Throws))+
        ']  Q=Quit, 8=Up Dart, 2=Down Dart, <ENTER>=Throw: ') ;
END ;


PROCEDURE PlayDarts ;
VAR
   oldpos,
   rowpos,
   ii,
   jj         : BYTE ;
   ch         : CHAR ;
BEGIN
   Throws := 0 ;
   ClearBoard ;
   REPEAT
      ClearStatusArea ;
      DrawTargetStrip ;
      RowPos := 5 ;
      CursorPos(rowpos,10) ;
      sDisplay(0,10,0,arrow) ;
      Prompt ;
      REPEAT
         ch := UPCASE(GetChar) ;
         IF (ch = #0) OR (ch = '[') OR (ch = ']') THEN BEGIN
            WMsg('Turn your NUM LOCK on!') ;
            DELAY(3000) ;
            Prompt ;
         END ;
         IF ch in ['2','D'] THEN BEGIN
            CursorPos(rowpos,10) ;
            sDisplay(0,10,0,'   ') ;
            IF rowpos > 14 THEN rowpos := 5 ELSE INC(rowpos) ;
            CursorPos(rowpos,10) ;
            sdisplay(0,10,0,arrow) ;
         END ELSE IF ch in ['8','U'] THEN BEGIN
            CursorPos(rowpos,10) ;
            sdisplay(0,10,0,'   ') ;
            IF rowpos < 6 THEN rowpos := 15 ELSE DEC(rowpos) ;
            cursorpos(rowpos,10) ;
            sdisplay(0,10,0,arrow) ;
         END ELSE IF (ch = 'Q') OR (Throws >= 10) THEN BEGIN
            ShowDartScores ;
            Exit ;
         END ;
      UNTIL ch = #13 ;
      INC(Throws) ;
      FOR jj := 11 TO 69 DO BEGIN
         oldpos := rowpos ;
         delay(50) ;
         cursorpos(oldpos,jj-1) ;
         sdisplay(0,10,0,'   ') ;
         ii := random(500) ;
         IF ii MOD 10 = 0 THEN BEGIN
            ii := random(100) ;
            IF ODD(ii) THEN BEGIN
               IF rowpos < 15 THEN INC(rowpos) ;
            END ELSE BEGIN
               IF rowpos > 5 THEN DEC(rowpos) ;
            END ;
         END ;
         cursorpos(rowpos,jj) ;
         sdisplay(0,10,0,arrow) ;
      END ;
      ShowWinnings(rowpos) ;
      CursorPos(rowpos,jj) ;
      sDisplay(0,10,0,'   ') ;
   UNTIL (ch = 'Q') OR (Throws >= Info.MaxDarts) ;
   ShowDartScores ;
END ;



BEGIN
END.

