/* cursor.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#define INCL_VIO
#include <os2.h>

static VIOCURSORINFO vci;

int main (int argc, char *argv[])
{
  long n;
  char *p;
  USHORT rc;
    
  if (argc != 3)
    {
      fprintf (stderr, "Usage: cursor <start_row> <end_row>\n");
      return (1);
    }
  if ((rc = VioGetCurType (&vci, 0)) != 0)
    {
      fprintf (stderr, "cursor: VioGetCurType failed, rc=%u\n", rc);
      return (1);
    }
  n = strtol (argv[1], &p, 10);
  if (n < -100 || n > 31 || *p != 0)
    {
      fprintf (stderr, "cursor: invalid start row\n");
      return (1);
    }
  vci.yStart = (USHORT)n;
  n = strtol (argv[2], &p, 10);
  if (n < -100 || n > 31 || *p != 0)
    {
      fprintf (stderr, "cursor: invalid end row\n");
      return (1);
    }
  vci.cEnd = (USHORT)n;
  if ((rc = VioSetCurType (&vci, 0)) != 0)
    {
      fprintf (stderr, "cursor: VioSetCurType failed, rc=%u\n", rc);
      return (1);
    }
  return (0);
}
