{ Unit: odyndlg
  By: Ping-sheun LEE (LPS)

 ( translation + modification from
   (1) DynDlg.zip(BC4++ OWL2 Excample)
       by
       University of California, Davis
   and
   (2) MSJ vol9 No.3
       by
       Mr Atig Aziz
       Source code: DynDlg.exe (Microsoft)
  Other information ,please refer to 'dyndlg.txt'
  
  Any bug and Suggestion please send to:
  Ping Shuen Lee
  Compuserve: 100426,21
  Internet: Ping.shuen.Lee@hk.super.net
  
   mod: Use Pcollection instead of array to store dialogs information.
}

Unit odyndlg;
Interface
Uses
    wintypes,winprocs,objects,owindows,odialogs,win31;

{Following infomation is written by Rory Jaffe:
the code for functions: GetDlgCtlRect and MoveSet are adapted (with changes) 
from the code by Atif Aziz in the article: "Simplify and Enhance Your 
Application's User Interface with Dynamic Dialog Boxes" in MSJ vol. 9 no. 3, 
Mar, 1994.  Both functions are changed to to replace a few function calls 
which appear to be either erroneous or are calls to functions he has defined
but not printed in the article. There are at least two things you can do to 
create dangerous situations with this code: 1) use non-existent ID's for 
homespot or refbox, and 2) add more than maxsets sets. I've added debug 
macros for number 1--it should be unnecessary for your finished code. }


{constructor--rarely need to alter default arguments--make hideatstart TRUE }
{if you did not remove visible attribute from the controls which are not }
{to be initially visible--make firstactive nonzero if you want a different }
{set (than 0) initially active--increase maxsets if you are crazy enough }
{to have more than 20 "looks" for the dialog box }

{Setup--this function is called in SetupWindow method of dialog box--first }
{argument is resource ID of the frame that is correctly positioned in the }
{dialog box, as a reference for moving the sets of controls--second }
{argument should be the HWND of the dialog box owning the controls, which }
{is almost always HWindow }

{AddSet--adds in sequence each set of dynamic controls (sets numbered from 0) and
returns the sequence number for the added set--each set consists of a
group of sequentially numbered controls (gaps are OK but wasteful) and a
refence frame.  The controls are placed in the reference frame so that
 they are in the same relation to their reference frame as you wish them
to be with the correctly positioned frame (set in Setup method).
 The AddSet method should also be called in the dialog class's SetupWindow
 method. }

{Activate--argument is the set number of the group to activate (show).  This }
{function returns the set number of the previously active group. }

type

PDynamicDialogControls=^tdynamicdialogcontrols;
tdynamicdialogcontrols=object
        dlginfo:pcollection;
	constructor init(hideatstart:bool;firstactive:integer) ;
	destructor done;virtual;
	procedure Setup(homespot:integer;hdlgwindow:hwnd) ;virtual;
	function AddSet(firstitem,lastitem,refbox:integer):integer;virtual;
	function Activate(which:integer):integer;virtual;
private
	_HDlgWindow:hwnd;
	_HomeSpot:integer ;
	_Active:integer ;
	_HideAtStart:bool ;
	procedure ShowSet(setnumber,cmdshow:integer) ;
	procedure MoveSet(setnumber,refbox:integer) ;
	procedure GetDlgCtlRect(nID:integer;var rc:trect) ;
end;

Implementation

type
    pdlglistelem=^tdlglistelem;
     tdlglistelem=object(tobject)
      start:integer;
      ends:integer;
     constructor init(_start,_ends:integer);
     destructor done;virtual;
end;

constructor tdlglistelem.init(_start,_ends:integer);
begin
   start:=_start;
   ends:=_ends;
end;

destructor tdlglistelem.done;
begin
  inherited done;
end;
(* wptr is pointer to dialog box that contains this class
 homespot is ID of the frame that is correctly positioned
 hideatstart tells the class to send SW_HIDE to all inactive controls on
 startup--but it's faster to unset VISIBLE attribute in dialog editor
 firstactive is the number of the set to be initially shown
 maxsets means no more than that many can be saved
 typical call is--
  TMyDialog::TMyDialog(...) : TDialog(...), mydyncontrols(this,HomeFrameID){}

  where mydyncontrols is a data member of TMyDialog*)



constructor tDynamicDialogControls.init(hideatstart:bool;firstactive:integer);
begin
	_HideAtStart:=hideatstart;
	_Active:=firstactive;
        dlginfo:=new(pcollection,init(5,5));
end;

destructor tDynamicDialogControls.done;
begin
	dispose(dlginfo,done);
end;

procedure tDynamicDialogControls.Setup(homespot:integer;hdlgwindow:hwnd);
begin
	_HomeSpot:= homespot ;
	_HDlgWindow:= hdlgwindow ;
end;

{add a set of sequentially numbered controls to dynamic box--they will be
moved to the same relative position in the HomeSpot frame as they were in the
refbox frame
Returns the set number}

function TDynamicDialogControls.AddSet(firstitem, lastitem, refbox:integer):integer;

begin
	dlginfo^.insert(new(pdlglistelem,init(firstitem,lastitem))) ;
	if refbox <> _HomeSpot then
		MoveSet(dlginfo^.count, refbox) ;
	if (_HideAtStart=false) and (dlginfo^.count<>_Active) then
		ShowSet(dlginfo^.count, SW_HIDE) ;
	addset:=dlginfo^.count ;
end;

procedure tDynamicDialogControls.GetDlgCtlRect( nID:integer; var rc:tRECT);
begin

	GetWindowRect(GetDlgItem(_HDlgWindow,nID),rc) ;
	MapWindowPoints(0, _HDlgWindow, rc, 2) ;
end;

{ activate a set--returns the number of the prior active set}

function tDynamicDialogControls.Activate(which:integer):integer;
var lastactive:integer;
begin
	lastactive:= _Active ;
	if _Active=which then
		activate:=_Active ;

	ShowSet(_Active,SW_HIDE) ;
	ShowSet(which, SW_SHOW) ;
	_Active:= which ;
	activate:=lastactive ;
end;

procedure tDynamicDialogControls.MoveSet(setnumber, refbox:integer);
var
       rcSrc, rcDest, rcCtl:trect ;
       nDeltaX, nDeltaY:integer ;
       hwndCtl:hwnd ;
       i,first,last:integer;

begin
	(*PRECONDITIONX(::GetDlgItem(HDlgWindow,refbox), "refbox in call to MoveSet is"
		"invalid") ;
	PRECONDITIONX(::GetDlgItem(HDlgWindow,HomeSpot), "HomeSpot in call to MoveSet is"
		"invalid") ;
          *)
	GetDlgCtlRect(refbox, rcSrc) ;
	GetDlgCtlRect(_HomeSpot, rcDest) ;

	nDeltaX:= rcDest.left - rcSrc.left ;
	nDeltaY:= rcDest.top - rcSrc.top ;

        first:=pdlglistelem(dlginfo^.at(setnumber-1))^.start;
        last:=pdlglistelem(dlginfo^.at(setnumber-1))^.ends;
	for i := first to last do
	begin
		hwndCtl := GetDlgItem(_HDlgWindow,i) ;
		if hwndCtl>0 then
		begin
			GetDlgCtlRect(i, rcCtl) ;
			SetWindowPos(hwndCtl, 0, rcCtl.left + nDeltaX,
				rcCtl.top + nDeltaY, 0, 0,
				SWP_NOSIZE or SWP_NOZORDER or SWP_NOACTIVATE) ;
		end;
	end;
end;

procedure tDynamicDialogControls.ShowSet( setnumber:integer; cmdShow:integer);
var  first,last:integer;
     hwndCtl:hwnd ;
     i:integer;
begin
        first:=pdlglistelem(dlginfo^.at(setnumber-1))^.start;
        last:=pdlglistelem(dlginfo^.at(setnumber-1))^.ends;

	for i:=first to last do
	begin
		hwndCtl:=GetDlgItem(_HDlgWindow,i) ;
		if hwndCtl>0  then
		ShowWindow(hwndCtl, cmdShow) ;
	end;
end;

End.

