$IF 0

This demo door was written by James R. Davis for use with DWDoor 2.3!

Change the DoorName$, DoorHelp$, and ErrorFile$ variables in the DWDOOR.INC
file to personalize your door.

NOTE:  If you ever open a file, use FREEFILE and set it to a variable before
       proceeded.  Here's the syntax for using a variable with files:

       A% = FREEFILE
       OPEN "I", A%, FileName$
       LINE INPUT #A%, A$
       PRINT #A%, A$
       GET$  #A%, A$
       PUT$  #A%, A$

       You get the idea.  Have fun with this program and read the docs for
       more information on the commands not used here!

This demonstration door will allow you to see the kind of things that this
program can do.  It will allow the user who runs this on a BBS to download
library using ZModem download only.  The DSZ.EXE program must exist within
the current directory.  The library file should be the only ZIP file located
within the directory as well.

$ENDIF

$INCLUDE "DWDOOR.INC"                  'Starts program rolling,
                                       'sets all variables
Start:
  CALL CLR                             'Clear the screen
  A$ = Center$(DoorName$, 79)          'Center the name of door in 79 spaces.
  CALL OutComm(Attr%(0, 7), 1, A$)     'Print A$ to screen/com in black on white
  CALL OutComm(Attr%(14,0), 1, "")     'Blank space
  CALL OutComm(Attr%(9, 0), 1, Center$("Written by James R. Davis", 79))
  CALL OutComm(Attr%(14, 0), 1, "")
  A$ = "(C) Copyright 1993 - All Rights Reserved"
  CALL DVPrint(25, 17, A$, Attr%(0, 7))'Print A$ on line 25 in the status box
  CALL OutComm(Attr%(14, 0), 1, Center$(A$, 79))
  CALL OutComm(Attr%(14, 0), 1, Center$(Extra$, 79))
  CALL OutComm(Attr%(14, 0), 1, "")
  CALL OutComm(Attr%(15, 0), 1, Center$("Demonstration supplied by " + BBS$, 79))
  CALL OutComm(Attr%(14, 0), 1, "")
  CALL Pause                           'Wait for a key to be pressed

  CALL CLR
  A$ = "Hello " + FirstName$ + ","
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = "You are connected to COM" + Trim$(STR$(ComPort%)) + " at " + _
     Trim$(STR$(Baud&)) + " baud, parity of " + Trim$(STR$(ComParity%)) + "."
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = "You currently have " + Trim$(STR$(TimeLeft& \ 60)) + " minutes remaining."
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = "The current connect string is: " + CHR$(34) + ComInit$ + CHR$(34)
  CALL OutComm(Attr%(14, 0), 1, A$)
  IF KBLocal% = True% THEN             'Determine if user is local or remote
    A$ = "LOCAL mode."
  ELSE
    A$ = "REMOTE mode."
  END IF
  A$ = "You are currently playing in " + A$
  CALL OutComm(Attr%(14, 0), 1, A$)
  CALL OutComm(Attr%(14, 0), 1, "")    'Blank line
  CALL Pause                           'Wait for a key to be pressed

  Row% = DCSRLIN%                      'Get current cursor location
  Col% = DPOS%
  A$ = AnsiLocate$(1, 7) + UserName$ + ","'Reposition cursor to 1,7 and print
  CALL OutComm(Attr%(15, 0), 1, A$)    'the user's full name.
  A$ = AnsiLocate$(Row% + 1, Col%) + NormalColor$ + "You can separate commands with a " + _
     AnsiColor$(Attr%(15, 1)) + " ; (Semi-colon) " + NormalColor$ + "."
  CALL OutComm(Attr%(7, 0), 1, A$)     'Put cursor back where you found it
                                       '+1 and continue.

  'The following demonstrates the use of fixed length input of 20 characters
  'The user must press return to end input.  A semi-colon can be used to
  'separate input.  Try it using the following input:
  '
  '                          Name;Address;Phone
  '
  'You'll notice that Name is extracted for input #1, Address is automatically
  'returned for input #2, and Phone is automatically given to input #3.

  A1$ = InComm$(Attr%(10, 0), 20, 0, "", 0, "", "Enter the 1st of 3 fields: ")
  A2$ = InComm$(Attr%(10, 0), 20, 0, "", 0, "", "Enter the 2nd of 3 fields: ")
  A3$ = InComm$(Attr%(10, 0), 20, 0, "", 0, "", "Enter the 3rd of 3 fields: ")
  CALL OutComm(Attr%(14, 0), 1, "")
  CALL Pause
  CALL CLR
  A$ = AnsiColor$(Attr%(14, 0)) + "You entered: " + AnsiColor$(Attr%(15, 1)) + A1$ +_
     NormalColor$ + " for field #1."
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = AnsiColor$(Attr%(14, 0)) + "You entered: " + AnsiColor$(Attr%(15, 1)) + A2$ +_
     NormalColor$ + " for field #2."
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = AnsiColor$(Attr%(14, 0)) + "You entered: " + AnsiColor$(Attr%(15, 1)) + A3$ +_
     NormalColor$ + " for field #3."
  CALL OutComm(Attr%(14, 0), 1, A$)
  CALL OutComm(Attr%(14, 0), 1, "")
  CALL Pause

  'The next few lines demostrate how word wrapping can be accomplished with
  'the InComm$() command.  Note: The last line of this routine will not word-
  'wrap, but wait for the user to end their input.

  CALL CLR
  A$ = "You can also do word wrapping!"
  CALL OutComm(Attr%(14, 0), 1, A$)
  CALL OutComm(Attr%(14, 0), 1, "")
  A$ = "Enter up to 3 lines of text, 77 characters long:"
  CALL OutComm(Attr%(14, 0), 1, A$)
  A1$ = InComm$(Attr%(10, 0),  0, 0, "", 0, "", "1:")
  A2$ = InComm$(Attr%(10, 0),  0, 0, "", 0, "", "2:")
  A3$ = InComm$(Attr%(10, 0), 77, 0, "", 0, "", "3:") 'This command does not word-wrap
  CALL OutComm(Attr%(14, 0), 1, "")
  CALL Pause
  A$ = "You entered:"
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = AnsiColor$(Attr%(15,  1)) + A1$
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = AnsiColor$(Attr%(15, 1)) + A2$
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = AnsiColor$(Attr%(15, 1)) + A3$
  CALL OutComm(Attr%(14, 0), 1, A$)
  CALL OutComm(Attr%(14, 0), 1, "")
  CALL Pause

  'The following is an example of how you can mask input without displaying
  'the actual characters, but substituting a "." in place of every key typed.

  CALL CLR
  A$ = "You can also hide input and replace it with a character!"
  CALL OutComm(Attr%(14, 0), 1, A$)
  CALL OutComm(Attr%(14, 0), 1, "")
  A$ = InComm$(Attr%(10, 0), -15, 0, ".", 0, "", "Enter a password (Dots will echo): ")
  CALL OutComm(Attr%(14, 0), 1, "")
  A$ = AnsiColor$(Attr%(14, 0)) + "You entered: " + AnsiColor$(Attr%(15, 1)) + A$ +_
     NormalColor$ + " for a password."
  CALL OutComm(Attr%(14, 0), 1, A$)
  CALL OutComm(Attr%(14, 0), 1, "")
  CALL Pause

  'The next routine give an example of how to use the PrintFile() routine.
  'It will display the DEMO.BAS source file with More: prompting.

  CALL CLR
  A$ = "You can display an entire file, with the PrintFile() subroutine."
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = "Here is the source to the program running right now.  See how easy"
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = "it can be to program with this library of commands..."
  CALL OutComm(Attr%(14, 0), 1, A$)
  CALL OutComm(Attr%(14, 0), 1, "")
  CALL PrintFile(0, "DEMO.BAS")
  CALL Pause

  ' This routine will demonstrate the new Scrn2Str$() function!

  Scrn$ = Scrn2Ansi$(9, 10, 13, 40)
  CALL OutComm(Attr%(14, 1), 1,AnsiLocate$(9, 10) + "Ŀ")
  CALL OutComm(Attr%(14, 1), 1,AnsiLocate$(10,10) + "  Now we can do WINDOWS!  " + AnsiColor$(7) + "")
  CALL OutComm(Attr%(14, 1), 1,AnsiLocate$(11,10) + " Press a key to clear it! " + AnsiColor$(7) + "")
  CALL OutComm(Attr%(14, 1), 1,AnsiLocate$(12,10) + "" + AnsiColor$(7) + "")
  CALL OutComm(Attr%(7,  0), 1,AnsiLocate$(13,10) + "  ")
  A$ = InComm$(0, -1, -1, "", 0, "", "")
  CALL OutComm(0, 0, Scrn$ + AnsiLocate$(23, 1) + SPACE$(79) + AnsiLocate$(23, 1))
  CALL Pause

  'This routine demonstrates how to use the InComm$() for specific input.
  'It also shows how to SHELL to Dos to perform other functions.

  CALL CLR
  D$ = DIR$("DW*.ZIP")

  A$ = "At this point you have an option.  If you think that this demo has fullfilled"
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = "your needs as a door programmer or you have thought about writting a door"
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ = "yourself, but just didn't have the opportunity to do so, well now is your"
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ ="chance.  If you can download using Z-Modem protocol, you can at this time,"
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ ="download the library used to make this demo.  Just hit "+AnsiColor$(Attr%(31,0))+"Y"+AnsiColor$(Attr%(14,0))+" at the following"
  CALL OutComm(Attr%(14, 0), 1, A$)
  A$ ="prompt to begin Z-Modem transfer!"
  CALL OutComm(Attr%(14, 0), 1, A$)
  CALL OutComm(Attr%(14, 0), 1, "")
  IF D$ = "" THEN
    A$ = "NOTICE:  The sysop has not put DWDOORxx.ZIP in the current directory."
    CALL OutComm(Attr%(12, 0), 1, A$)
    A$ = "         Please inform " + SysopF$ + " of this.  You may not download now!"
    CALL OutComm(Attr%(12, 0), 1, A$)
    A$ = "         Check on the main board's download directory, you may find it there!"
    CALL OutComm(Attr%(12, 0), 1, A$)
    CALL OutComm(Attr%(14, 0), 1, "")
  END IF
  IF KBLocal% = True% THEN
    A$ = "I hope you don't expect to download the file in local mode!  GIVE ME A BREAK!"
    CALL OutComm(Attr%(15, 0), 1, A$)
    CALL OutComm(Attr%(14, 0), 1, "")
  END IF
  A$ = "Do you wish to download " + D$ + "? (y/N): "
  A$ = InComm$(Attr%(14, 0), 1, -1, "N", Attr%(7, 0), "YNyn", A$)

  'The following is an example of how to use the ErrLevel% function to
  'determine whether or not an error occured after a program was run in
  'shell mode.  It also shows how to use the WriteDoorERR() routine to
  'write custom error messages to your error file set in the ErrorFile$
  'variable.  Note the use of CALL Script().

  CALL OutComm(Attr%(14, 0), 1, "")
  IF UCASE$(A$) = "Y" THEN
    IF D$ <> "" OR KBLocal% <> True% THEN
      CALL OutComm(Attr%(14, 0), 1, "Sending " + D$ + "... prepare to receive...")
      SHELL "dsz.com handshake both pB4096 z sz " + D$
      Er% = ErrLevel%                      'Get the errorlevel if one exists

      'After a shell, you must redisplay the last 2 lines on the screen.

      CALL Line25
      IF Er% <> 0 THEN CALL WriteDoorERR(Er%, "File transfer of " + D$ + " did not go smoothly!")
    ELSE
      CALL OutComm(Attr%(14, 0), 1, "")
      A$ = "Well, either you can't read.. or you're a moron... <GRIN!>"
      CALL OutComm(Attr%(15, 0), 1, A$)
      CALL OutComm(Attr%(14, 0), 1, "")
      CALL Script("Pause", "", "")
    END IF
  END IF

  'This last routine gives you an example of how to end a program correctly.

  COLOR 7, 0
  CALL CLR
  A$ = NormalColor$ + CHR$(12) + "Thanks for trying DWDoor Demo v2.3!"
  CALL OutComm(Attr%(14, 0), 1, A$)
  CALL ExitDoor(0)
