$COMPILE EXE                             'Compile your program to an EXE
$CPU 8086                                'Set default CPU type to 8086
$LIB IPRINT ON                           'Include Interpreted print routines
$LIB COM ON                              'Include communications library
$COM 2048                                'Set the comport buffer to 2048
$STACK 7140                              'Set the stack size to 7140 bytes

' Declare our functions and subs

DECLARE FUNCTION AnsiColor$(INTEGER)
DECLARE FUNCTION AnsiLocate$(INTEGER,INTEGER)
DECLARE FUNCTION Attr%(INTEGER,INTEGER)
DECLARE FUNCTION Carrier%(INTEGER)
DECLARE FUNCTION Center$(STRING,INTEGER)
DECLARE FUNCTION CommKey$()
DECLARE FUNCTION DCSRLIN%()
DECLARE FUNCTION DPos%()
DECLARE FUNCTION DataLen%(INTEGER)
DECLARE FUNCTION DoorInfo$(STRING)
DECLARE FUNCTION ErrLevel%()
DECLARE FUNCTION Exist%(STRING)
DECLARE FUNCTION GetBaud&(INTEGER)
DECLARE FUNCTION GetExtra$(STRING)
DECLARE FUNCTION InComm$(INTEGER,INTEGER,INTEGER,STRING,INTEGER,STRING,STRING)
DECLARE FUNCTION More%()
DECLARE FUNCTION Parity%(INTEGER)
DECLARE FUNCTION Parm$(STRING,STRING)
DECLARE FUNCTION Scrn2Ansi$(INTEGER,INTEGER,INTEGER,INTEGER)
DECLARE FUNCTION StopBits%(INTEGER)
DECLARE FUNCTION Trim$(STRING)

DECLARE SUB CLR()
DECLARE SUB CheckTime()
DECLARE SUB DPrint(STRING)
DECLARE SUB DVGivUp()
DECLARE SUB DVPrint(INTEGER,INTEGER,STRING,INTEGER)
DECLARE SUB DoorInit(STRING)
DECLARE SUB ExitDoor(INTEGER)
DECLARE SUB GetLocalInfo()
DECLARE SUB Help(STRING)
DECLARE SUB Line25()
DECLARE SUB OutComm(INTEGER,INTEGER,STRING)
DECLARE SUB PAUSE()
DECLARE SUB PrintFile(INTEGER,STRING)
DECLARE SUB Script(STRING,STRING,STRING)
DECLARE SUB TestComm()
DECLARE SUB WriteDoorERR(INTEGER,STRING)

$LINK "DWDOOR.PBL"                        'Link in the door routines

'Declare our PUBLIC variables

PUBLIC Ansi%          ,_   '-1 if ANSI allowed, 0 if not.
       BBS$           ,_   'The BBS name.
       Back%          ,_   'Current background color.
       Baud&          ,_   'The baud rate of ComPort%.
       Beeper&        ,_   'Seconds before beep for no input.
       CR$            ,_   'Carridge return CHR$(13)
       CRLF$          ,_   'Return + Linefeed CHR$(13)+CHR$(10)
       ComInit$       ,_   'Complete string for opening com port.
       ComParity%     ,_   'The parity of ComPort%.
       ComPort%       ,_   'The comport number (1-8).
       Comm%          ,_   'OPENed COM port number.
       DoorHelp$      ,_   'The filename displayed when ? used on command line.
       DoorName$      ,_   'Full Name of door.
       ErrorFile$     ,_   'The filename to write errors to.
       Extra$         ,_   'Extra string of 70 characters or less (optional).
       False%         ,_   'Constant 0
       FirstName$     ,_   'User's First Name.
       Fore%          ,_   'Current foreground color.
       IRQ$           ,_   'The sysop comport IRQ # (2-15 or 0 for none)
       InText$        ,_   'Extra input from the user.
       KBLocal%       ,_   '-1 if LOCAL, 0 if at REMOTE.
       KBTime&        ,_   'KB time-out limit in seconds.
       LBack$         ,_   'CHR$(29)
       LBackSp$       ,_   'Local Backspace.
       LastName$      ,_   'User's Last Name.
       MaxTime&       ,_   'Maximum amount of time in door allowed in secs.
       NormalColor$   ,_   'Resets ANSI color to White on Black.
       Okay%          ,_   '-1 if serial code matches, 0 if not.
       RBack$         ,_   'CHR$(8)
       RBackSp$       ,_   'Remote Backspace.
       Serial$        ,_   'Returned from SERIAL variable in CFG.
       SysopF$        ,_   'The Sysop's First name.
       SysopL$        ,_   'The Sysop's Last name.
       SysopName$     ,_   'The full sysop's name (All Uppercase).
       TimeIn&        ,_   'Time user started program in seconds.
       TimeLeft&      ,_   'Total time left in door in seconds.
       True%          ,_   'Constant -1
       UserName$           'User's full Name (All Uppercase).

DEFINT A - Z

' The next 3 variables must be set!

DoorName$  = "Demo Door v2.3"             'The name of your door
DoorHelp$  = "DWDOOR.HLP"                 'The Help file to display
ErrorFile$ = "DWDOOR.ERR"                 'The error file to write to

'If you wish to have your own command line options, it is suggested that you
'parse the command line HERE before sending the CFG filename from the command
'line to DoorInit$()

C$ = COMMAND$
A$ = UCASE$(C$)

CALL DoorInit(A$)

