/************************************************************************/
/*                                                                      */
/*                 Digitized Voice Programmer's Toolkit                 */
/*                 ------------------------------------                 */
/*                            version 3.0                               */
/*                                                                      */
/*              Copyright (c) 1988-1993, Farpoint Software              */
/*                                                                      */
/*                                                                      */
/*  Example of how to use FSSPEAK.EXE as a transient (non-TSR) program  */
/*                                                                      */
/************************************************************************/

#include <stdlib.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <stdio.h>
#include <stddef.h>
#include <malloc.h>
#include <process.h>
#include <errno.h>
#include <string.h>

/*-------------------------------------------------------------------*/

/* name of the data file to be played */

char datafilename[] = "DEMO.VOI";

/* sample rate of the data file */

unsigned int samples_per_sec = 16572;  // default for DVPT

/* compression algorithm to be used; 0 = none, 1 = uLaw, 2 = ADPCM */

int compression = 0;

/* name of the file where calibration information is to be stored */

char calfilename[] = "CALIB.FSS";

/*-------------------------------------------------------------------*/

void main(int argc, char **argv)

{
int destination, returncode;
char arg1[6], arg2[64];

/* get the destination parameter from the command line */

if ( argc < 2 )         // no parameters...
    destination = -1;   // ... auto-locate
else
    {
    argv++;                             // point to 1st parameter
    if ( !stricmp(*argv, "LPT1") )
        destination = 1;
    else if ( !stricmp(*argv, "LPT2") )
        destination = 2;
    else if ( !stricmp(*argv, "LPT3") )
        destination = 3;
    else if ( !stricmp(*argv, "SPKR") )
        destination = 0;               // use internal speaker
    else
        destination = -1;              // invoke auto-locate if parameter
                                       //   is not interpretable
    }

/* Step 1 (required only when destination changes): Save calibration info */

  /* create command line argument 1 */

if ( destination != -1 )
    sprintf(arg1, "/S%1.1d%1.1d", destination, compression);
else
    sprintf(arg1, "/SA%1.1d", destination, compression);

  /* create command line argument 2 */

sprintf(arg2, "%u", samples_per_sec);

  /* invoke the executable */

returncode = _spawnl(_P_WAIT, "FSSPEAK.EXE", "FSSPEAK.EXE",
                     arg1, arg2, calfilename, NULL);

  /* test return code; see docs for complete explanation */

if ( returncode != 1 )         // if not OK
    {
    printf("Calibration pass returned %d.\n", returncode);
    exit(1);
    }

/* Step 2: Play the data through the internal speaker or LPT port.
           This can be done multiple times after a single calibration. */

_spawnl(_P_WAIT, "FSSPEAK.EXE", "FSSPEAK.EXE",
        "/P", calfilename, datafilename, NULL);

}
