/*	ts;4	*/
/*
	asm PutChProc.asm
	lc -v -cs -O DupCheck
	blink from DupCheck.o PutChProc.o to DupCheck SC SD ND
*/

#include <exec/types.h>
#include <exec/alerts.h>
#include <exec/memory.h>
#include <exec/libraries.h>
#include <dos/dosextens.h>
#include <dos/rdargs.h>
#include <dos/datetime.h>

#include <clib/exec_protos.h>
#include <clib/utility_protos.h>
#include <clib/dos_protos.h>

extern struct DosLibrary	*DOSBase;
extern struct UtilityBase	*UtilityBase;

#include <pragma/exec_lib.fd.h>
#include <pragma/utility_lib.fd.h>
#include <pragma/dos_lib.fd.h>

#include <string.h>

#define SUCCESS		0
#define USERBREAK	1
#define FAILURE		2

extern LONG	_main();
#define DOSNAME		"dos.library"
#define UTILITYNAME	"utility.library"
#define LIBREQ		37
__saveds LONG	startup()
{
	register LONG	RetVal = 5;
	if(DOSBase = (struct DosLibrary *) OpenLibrary(DOSNAME, LIBREQ))
	{
		if(Cli())
		{
			if(UtilityBase = (struct UtilityBase *) OpenLibrary(UTILITYNAME, LIBREQ))
			{
				RetVal = _main();
				CloseLibrary((struct Library *) UtilityBase);
			}
			else
				Alert(AG_OpenLib | AO_UtilityLib);
		}
		CloseLibrary((struct Library *) DOSBase);
	}
	else
		Alert(AG_OpenLib | AO_DOSLib);
	return(RetVal);
}

static char	Failed[] = "FAILED";
static char	ALLOCMEM[] = "AllocMem";
static char	DATETOSTR[] = "DateToStr";
static char	NAMEFROMLOCK[] = "NameFromLock";
static char	ADDPART[] = "AddPart";
static char	MATCHFIRST[] = "MatchFirst";
static char	PARSEPATTERNNOCASE[] = "ParsePatternNoCase";
static char	MATCHPATTERNNOCASE[] = "MatchPatternNoCase";
static char	FMT2[] = "%s %s\n";
static char	FMT3[] = "%s %s [%s]\n";
static char	BytesInFiles[] = " %10ld Bytes in %10ld Files\n";

struct DosLibrary	*DOSBase;
struct UtilityBase	*UtilityBase;

static char Version[] = "\0$VER: DupCheck v1.2 (31-Aug-93)";

#define BREAK(Mask)	(CheckSignal(Mask) == (Mask))
static char	BreakMsg[] = "\n**** BREAK\n";

static LONG	PrintfStub(char *fmtstr, ...)
{
	return(VPrintf(fmtstr, (LONG *) (&fmtstr + 1)));
}

extern void __asm	PutChProc(
	register __d0 char	*d0,
	register __a3 char	*a3
);
typedef VOID	(*FUNC)();
static VOID	SPrintfStub(char *str, char *fmtstr, ...)
{
	RawDoFmt(fmtstr, (LONG *) (&fmtstr + 1), (FUNC) &PutChProc, str);
}

static struct StrLst
{
	char			*str;
	struct StrLst	*prev;
}	*StrLst = 0;

static void	FreeStrLst()
{
	while(StrLst)
	{
		register struct StrLst	*strlst = StrLst;
		register char	*str = strlst->str;
		FreeMem(str, strlen(str) + 1);
		StrLst = strlst->prev;
		FreeMem(strlst, sizeof(struct StrLst));
	}
}

static char	*StrDup(register char *src)
{
	register char	*dst;
	register struct StrLst	*strlst;
	register int	len = strlen(src) + 1;
	if(!(dst = (char *) AllocMem(len, MEMF_PUBLIC)))
	{
		PrintfStub(FMT3, ALLOCMEM, Failed, src);
		goto EndStrDup;
	}
	if(!(strlst = (struct StrLst *) AllocMem(sizeof(struct StrLst), MEMF_PUBLIC)))
	{
		PrintfStub(FMT2, ALLOCMEM, Failed);
		FreeMem(dst, len);
		dst = 0;
		goto EndStrDup;
	}
	strlst->str = dst;
	strlst->prev = StrLst;
	StrLst = strlst;
	strcpy(dst, src);
EndStrDup:
	return dst;
}

#define PATHLEN	(256*2)

struct DupEntry
{
	UBYTE				de_FileFlag;
	UBYTE				de_SizeFlag;
	UBYTE				de_DateFlag;
	UBYTE				de_DupFlag;
	char				*de_Root;
	char				*de_Path;
	char				*de_File;
	LONG				de_Size;
	struct DateStamp	de_DateStamp;
};

struct DupList
{
	struct DupList		*Prev;
	struct DupList		*Next;
	struct DupEntry		DupEntry;
};
struct DupList	*DupListHead = 0;

struct	Args
{
	char	*a_Pattern;
	int		a_Size;
	int		a_Date;
	int		a_Verbose;
};

static int	MaxRootLen = 0;
static int	MaxFileLen = 0;
static int	MaxPathLen = 0;

static void	UpdateMax(register struct DupEntry *Old, register struct DupEntry *New)
{
	register int	RootLen = strlen(New->de_Root);
	register int	PathLen = strlen(New->de_Path);
	register int	FileLen = strlen(New->de_File);
	if(!Old->de_DupFlag)
	{
		register int	rootLen = strlen(Old->de_Root);
		register int	pathLen = strlen(Old->de_Path);
		if(RootLen < rootLen)
			RootLen = rootLen;
		if(PathLen < pathLen)
			PathLen = pathLen;
	}
	if(MaxRootLen < RootLen)
		MaxRootLen = RootLen;
	if(MaxPathLen < PathLen)
		MaxPathLen = PathLen;
	if(MaxFileLen < FileLen)
		MaxFileLen = FileLen;
}

static int	Compare(
	register struct DupEntry *Old,
	register struct DupEntry *New,
	register struct Args *Args
)
{
	register int	fcmp;
	register int	scmp;
	register int	dcmp;
	register int	cmp;
	register struct DateStamp	*OldStamp;
	register struct DateStamp	*NewStamp;

	if(cmp = fcmp = Stricmp(Old->de_File, New->de_File))
	{
		dcmp = scmp = fcmp;
		goto EndCmp;
	}
	Old->de_FileFlag = New->de_FileFlag = 1;

	if(cmp = scmp = (Old->de_Size - New->de_Size))
	{
		dcmp = scmp;
		goto EndCmp;
	}
	Old->de_SizeFlag = New->de_SizeFlag = 1;

	OldStamp = &Old->de_DateStamp;
	NewStamp = &New->de_DateStamp;
	if(cmp = dcmp = (OldStamp->ds_Days - NewStamp->ds_Days))
		goto EndCmp;
	if(cmp = dcmp = (OldStamp->ds_Minute - NewStamp->ds_Minute))
		goto EndCmp;
	if(cmp = dcmp = (OldStamp->ds_Tick - NewStamp->ds_Tick))
		goto EndCmp;
	Old->de_DateFlag = New->de_DateFlag = 1;

EndCmp:

	if(Args->a_Date ? !dcmp : Args->a_Size ? !scmp : !fcmp)
	{
		UpdateMax(Old, New);
		New->de_DupFlag = 1;
	}

	return cmp;
}

static LONG	InsertEntry(struct DupEntry *DupEntry, register struct Args *Args)
{
	register LONG	RetVal = FAILURE;
	register struct DupList	*DupList = DupListHead;
	register struct DupList	*NewDupList = AllocMem(sizeof(struct DupList), MEMF_PUBLIC | MEMF_CLEAR);

	if(!NewDupList)
	{
		PrintfStub(FMT2, ALLOCMEM, Failed);
		goto	NoAllocMem;
	}

	if(!DupList)
		DupListHead = NewDupList;
	else
	{
		while(Compare(&DupList->DupEntry, DupEntry, Args) < 0)
		{
			if(!DupList->Next)
			{
				DupList->Next = NewDupList;
				NewDupList->Prev = DupList;
				goto	Done;
			}
			DupList = DupList->Next;
		}
		NewDupList->Prev = DupList->Prev;
		NewDupList->Next = DupList;
		if(DupList == DupListHead)
			DupListHead = NewDupList;
		else
			DupList->Prev->Next = NewDupList;
		DupList->Prev = NewDupList;
	}

Done:
	NewDupList->DupEntry = *DupEntry;

	RetVal = SUCCESS;

NoAllocMem:

	return(RetVal);
}

static void	ClearDupList()
{
	register struct DupList	*DupList = DupListHead;
	while(DupList)
	{
		register struct DupList	*Next = DupList;
		DupList = Next->Next;
		FreeMem(Next, sizeof(struct DupList));
	}
}

static LONG	PrintDupEntry(
	register struct DupEntry *DupEntry,
	register struct Args *Args,
	register char *FmtStr)
{
	register LONG	RetVal = FAILURE;

	register UBYTE	StrDay[LEN_DATSTRING];
	register UBYTE	StrDate[LEN_DATSTRING];
	register UBYTE	StrTime[LEN_DATSTRING];

	if(Args->a_Verbose || !Args->a_Date)
	{
		struct DateTime	DateTime;

		DateTime.dat_Stamp = DupEntry->de_DateStamp;
		DateTime.dat_Format = FORMAT_DOS;
		DateTime.dat_Flags = DTF_SUBST;
		DateTime.dat_StrDay = StrDay;
		DateTime.dat_StrDate = StrDate;
		DateTime.dat_StrTime = StrTime;

		if(!DateToStr(&DateTime))
		{
			PrintfStub(FMT2, DATETOSTR, Failed);
			goto NoDateToStr;
		}
	}

	PrintfStub(FmtStr,
		DupEntry->de_SizeFlag ? 'S' : ' ',
		DupEntry->de_DateFlag ? 'D' : ' ',
		DupEntry->de_Root,
		DupEntry->de_File,
		DupEntry->de_Path
	);

	if(Args->a_Verbose || !Args->a_Size)
		PrintfStub(" %10ld", DupEntry->de_Size);

	if(Args->a_Verbose || !Args->a_Date)
		PrintfStub(" %10s %8s", StrDate, StrTime);

	PrintfStub("\n");

	RetVal = SUCCESS;
NoDateToStr:

	return(RetVal);
}

static LONG	PrintDupList(register struct Args *Args)
{
	register LONG	RetVal = FAILURE;
	register struct DupList	*DupList = DupListHead;
	register LONG	TotBytes = 0;
	register LONG	DupBytes = 0;
	register LONG	TotFiles = 0;
	register LONG	DupFiles = 0;

	register char	FmtStr[64];

	SPrintfStub(FmtStr, "%s%s %lc-%ld%lc %lc-%ld%lc %lc-%ld%lc",
		"%lc", "%lc",
		'%', MaxRootLen, 's',
		'%', MaxFileLen, 's',
		'%', MaxPathLen, 's'
		);

	while(DupList)
	{
		register struct DupEntry	*DupEntry = &DupList->DupEntry;

		if(BREAK(SIGBREAKF_CTRL_C))
		{
			RetVal = USERBREAK;
			goto EndPrintDupList;
		}

		TotBytes += DupEntry->de_Size;
		TotFiles++;

		if(
			(!DupEntry->de_FileFlag)
		||
			(Args->a_Size && !DupEntry->de_SizeFlag)
		||
			(Args->a_Date && !DupEntry->de_DateFlag)
		)
			goto next;

		if(PrintDupEntry(DupEntry, Args, FmtStr) != SUCCESS)
			goto	EndPrintDupList;

		if(DupEntry->de_DupFlag)
		{
			DupBytes += DupEntry->de_Size;
			DupFiles++;
		}
	next:
		DupList = DupList->Next;
	}

	if(Args->a_Verbose)
	{
		PrintfStub("Total    ");
		PrintfStub(BytesInFiles, TotBytes, TotFiles);
		PrintfStub("Duplicate");
		PrintfStub(BytesInFiles, DupBytes, DupFiles);
	}

	RetVal = SUCCESS;

EndPrintDupList:

	return(RetVal);
}

static LONG	NextFile(
	register struct AnchorPath *AnchorPath,
	register struct DupEntry *DupEntry,
	register struct Args *Args
)
{
	static	char	*PrevPath = 0;

	register LONG	RetVal = FAILURE;
	register struct FileInfoBlock	*FileInfoBlock = &AnchorPath->ap_Info;
	register LONG	DirEntryType = FileInfoBlock->fib_DirEntryType;
	register char	*Name = FileInfoBlock->fib_FileName;

	if(BREAK(SIGBREAKF_CTRL_C))
	{
		RetVal = USERBREAK;
		goto EndNextFile;
	}

	if((DirEntryType == ST_USERDIR) || (DirEntryType == ST_ROOT)) /* skip links (ST_LINKDIR) */
	{
		if(!(AnchorPath->ap_Flags & APF_DIDDIR))
		{
			register char	Path[PATHLEN];
			PrevPath = DupEntry->de_Path;
			if(!NameFromLock(AnchorPath->ap_Current->an_Lock, Path, PATHLEN))
			{
				PrintFault(IoErr(), 0);
				PrintfStub(FMT2, NAMEFROMLOCK, Failed);
				goto EndNextFile;
			}
			if(!AddPart(Path, Name, PATHLEN))
			{
				PrintfStub(FMT3, ADDPART, Failed, Name);
				goto EndNextFile;
			}
			if(!(DupEntry->de_Path = StrDup(Path)))
				goto EndNextFile;
			AnchorPath->ap_Flags |= APF_DODIR;
		}
		else
			DupEntry->de_Path = PrevPath;
		AnchorPath->ap_Flags &= ~APF_DIDDIR;
	}
	if(DirEntryType == ST_FILE) /* skip links (ST_SOFTLINK, ST_LINKFILE) */
	{
		register char	*Pattern = Args->a_Pattern;
		if(Pattern)
			if(!MatchPatternNoCase(Pattern, Name))
			{
				register int	IoError = IoErr();
				if(IoError)
				{
					PrintFault(IoErr(), 0);
					PrintfStub(FMT3, PARSEPATTERNNOCASE, Failed, Pattern);
					goto NoMatchPatternNoCase;
				}
				else
					goto NoMatch;
			}
		if(!(DupEntry->de_File = StrDup(Name)))
			goto EndNextFile;
		DupEntry->de_Size = FileInfoBlock->fib_Size;
		DupEntry->de_DateStamp = FileInfoBlock->fib_Date;
		DupEntry->de_FileFlag = 0;
		DupEntry->de_SizeFlag = 0;
		DupEntry->de_DateFlag = 0;
		DupEntry->de_DupFlag = 0;
		if(InsertEntry(DupEntry, Args) != SUCCESS)
			goto EndNextFile;
	}

NoMatch:
	RetVal = SUCCESS;

NoMatchPatternNoCase:
EndNextFile:

	return(RetVal);
}

static LONG	DupCheck(register char *Root, register struct Args *Args)
{
	register LONG	RetVal = FAILURE;
	register struct AnchorPath	*AnchorPath =
		(struct AnchorPath *) AllocMem(sizeof(struct AnchorPath), MEMF_PUBLIC | MEMF_CLEAR);
	struct DupEntry	DupEntry;

	if(!AnchorPath)
	{
		PrintfStub(FMT2, ALLOCMEM, Failed);
		goto NoAnchorPath;
	}

	if(!(DupEntry.de_Root = StrDup(Root)))
		goto  NoRoot;

	if(MatchFirst(Root, AnchorPath))
	{
		PrintFault(IoErr(), 0);
		PrintfStub(FMT3, MATCHFIRST, Failed, Root);
		goto	NoMatchFirst;
	}
	{
		register LONG	DirEntryType = AnchorPath->ap_Info.fib_DirEntryType;
		if((DirEntryType == ST_ROOT) || (DirEntryType == ST_USERDIR))
		{
			if((RetVal = NextFile(AnchorPath, &DupEntry, Args)) != SUCCESS)
				goto EndDupCheck;
		}
		else
		{
			PrintfStub("[%s] is not a root or user directory\n", Root);
			goto NoRoot;
		}
	}

	while(!MatchNext(AnchorPath))
		if((RetVal = NextFile(AnchorPath, &DupEntry, Args)) != SUCCESS)
			goto EndDupCheck;

	RetVal = SUCCESS;

EndDupCheck:
	if(RetVal == USERBREAK)
		PrintfStub(BreakMsg);

NoRoot:
NoMatchFirst:
	MatchEnd(AnchorPath);

	FreeMem(AnchorPath, sizeof(struct AnchorPath));
NoAnchorPath:

	return(RetVal);
}

#define ARG_ROOTS	0
#define ARG_PATTERN	(ARG_ROOTS + 1)
#define ARG_SIZE	(ARG_PATTERN + 1)
#define ARG_DATE	(ARG_SIZE + 1)
#define ARG_VERBOSE	(ARG_DATE + 1)
#define ARG_LAST	(ARG_VERBOSE + 1)
static LONG	*ArgArray[ARG_LAST];

static char	Template[] = "ROOTS/M,P=PATTERN/K,S=SIZE/S,D=DATE/S,V=VERBOSE/S";

LONG	_main()
{
	register LONG	RetVal = FAILURE;
	register struct RDArgs	*RDArgs;
	register int	root;
	register char	*Root;
	register char	*Pattern;
	register int	PatternLenght;
	struct Args		Args;
	register int	Verbose;

	if(!(RDArgs = ReadArgs(Template, (LONG *) ArgArray, NULL)))
	{
		PrintFault(IoErr(), 0);
		goto	NoRDArgs;
	}

	if(Pattern = (char *) ArgArray[ARG_PATTERN])
	{
		PatternLenght = (strlen(Pattern) + 1) << 1;
		if(!(Args.a_Pattern = AllocMem(PatternLenght, MEMF_PUBLIC)))
		{
			PrintfStub(FMT2, ALLOCMEM, Failed);
			goto	NoPattern;
		}
		if(ParsePatternNoCase(Pattern, Args.a_Pattern, PatternLenght) == -1)
		{
			PrintfStub(FMT3, PARSEPATTERNNOCASE, Failed, Pattern);
			goto	NoParsePatternNoCase;
		}
	}
	else
		Args.a_Pattern = 0;
	Args.a_Size = (int) ArgArray[ARG_SIZE];
	if(Args.a_Date = (int) ArgArray[ARG_DATE])
		Args.a_Size = 1;

	Verbose = Args.a_Verbose = (int) ArgArray[ARG_VERBOSE];

	for(root = 0; Root = (char *) ArgArray[ARG_ROOTS][root]; ++root)
	{
		if(Verbose)
			PrintfStub("processing [%s]\n", Root);
		if(DupCheck(Root, &Args) != SUCCESS)
			goto	NoDupCheck;
	}
	if(!root && Verbose)
		PrintfStub("nothing to process\n");

	RetVal = SUCCESS;

NoDupCheck:

NoParsePatternNoCase:
	if(Pattern)
		FreeMem(Args.a_Pattern, PatternLenght);
NoPattern:

	FreeArgs(RDArgs);
NoRDArgs:

NoAllocMem:

	if(PrintDupList(&Args) == USERBREAK)
		PrintfStub(BreakMsg);

	if(Verbose)
		PrintfStub("free-ing memory, please wait ...\n");
	FreeStrLst();
	ClearDupList();

	return(RetVal);
}
