
typedef enum channel {MONO_LEFT,MONO_RIGHT,MONO_BOTH,STEREO,STEREO_LEFT,
		 STEREO_RIGHT,STEREO_LEFT_BOTH,STEREO_RIGHT_BOTH,
		  UNSPECIFIED} channel;

struct IOAudio *GetAudioChannel(ULONG bufferSize,UBYTE *allocationMap);
void FreeAudioChannel(struct IOAudio *aIOB);
void InitAudioChannel(struct IOAudio *aIOB,UWORD volume,UWORD period);
struct IOAudio *DuplicateAudioChannel(struct IOAudio *OrigIOB);
void DeleteDuplication(struct IOAudio *aIOB);
ULONG LoadAudioBuffer(BPTR file,struct IOAudio *aIOB,ULONG toRead);
char *FindChunk(BPTR file,char *string);
void Position(BPTR file,char *string);
void WriteMsg(char *errMsg);
void playMonoSample(BPTR file,channel audioChannel,struct Voice8Header *vhdr,
		    ULONG len);
void playStereoSample(BPTR leftFile,channel audioChannel,
		      struct Voice8Header *vhdr, ULONG length, char *filename);
void playMonoTwice(BPTR file,channel audioChannel,struct Voice8Header *vhdr,
		   ULONG length);
BPTR dupFileHandle(BPTR origFile,char *filename);
ULONG getPosInFile(BPTR file);
void cleanup(int err);

/* Mem.c */
void storeLeft(BPTR file,ULONG length,ULONG blockLength);
void deleteLeft(void);
void getLeft(APTR dest);

void storeRight(BPTR file,ULONG length,ULONG blockLength);
void deleteRight(void);
void getRight(APTR dest);

typedef struct Voice8Header
{
   ULONG oneShotHiSamples,
	 repeatHiSamples,
	 samplesPerHiCycle;
   UWORD samplesPerSec;
   UBYTE ctOctave,sCompression;
   LONG volume;
};

#define MIN(x,y) ( (x) < (y) ) ? (x) : (y)


char *getLength(ULONG length);
char *getRate(struct Voice8Header *vhdr);
char *getTime(ULONG numSecs);

UWORD textToPixelX(UWORD fontUnits);
UWORD textToPixelY(UWORD fontUnits);
UWORD defFontBaseline();
void drawBevelBoxes(char *time,char *size,char *rate, char *filename);
void installGadgets();
void updateTime(ULONG numSecs);

void swapPointers(struct IOAudio **first,struct IOAudio **second);
void updateSampleInfo(unsigned int currentPos,unsigned int length,
		      unsigned int sampleRate);


