***************************************************************************
*
* Procedure file: DRAGDROP.PRG
*         System: GenScrnX
*        Version: 1.0
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* DRAGDROP - DragDrop driver for GENSCRNX.
*
* Description:
* This program is used as an optional driver for use with GENSCRNX.PRG.
*
* Features:
* Generates drag-and-drop event/property code.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
* Important:
* Function calls made from this program may be contained in GENSCRNX.PRG.
* Variable names not declared PRIVATE in this program defined PRIVATE in
* GENSCRNX.PRG.
*
PRIVATE c_dragmode,dragover,c_dragdrop,c_dragenter,c_dragleave,c_dragwithin
PRIVATE c_objcmd,c_objmsg,objarray,c_objtxt,c_dragicon,c_overicon,c_overtxt
PRIVATE c_overbutton,c_dblclick,c_dragheight,c_dragwidth,c_noiconlist
PRIVATE c_objheight,c_objwidth,c_overheight,c_overwidth,c_3d,c_no3d
PRIVATE dragicon,overicon,overtxt,overbutton,objclass,objmsg
PRIVATE dragmode,dragover,dragdrop,dragenter,dragleave,dragwithin,objtxt
PRIVATE objarray,iconlist,codedata,codedata2,codedata3,setupdata,cleanupdata
PRIVATE dragheight,dragwidth,objheight,objwidth,overheight,overwidth
PRIVATE cfontstylm,vfontratio,hfontratio,vfactor,hfactor,dblclick
PRIVATE r,i,expr2,vpos2,hpos2,height2,width2,match,offset

IF OBJTYPE#1.OR..NOT.drvenable(PROGRAM()).OR.m.drv_no>7
  GOTO BOTTOM
  RETURN .F.
ENDIF
IF TYPE('m.gsxversion')#'C'.OR.LEFT(m.gsxversion,4)<'1.7a'
  GOTO BOTTOM
  =warning('DragDrop driver requires GENSCNRX 1.7a or later')
  RETURN .F.
ENDIF
IF m.drv_no<7.AND..NOT.m.loop_flag
  a_scxdrvs(7)=a_scxdrvs(7)+1
  IF ALEN(a_scxdrv)<(8*a_scxdrvs(7))
    DIMENSION a_scxdrv(a_scxdrvs(7),8)
  ENDIF
  a_scxdrv(a_scxdrvs(7),7)=a_scxdrv(m.drv_cnt,m.drv_no)
ENDIF
m.c_dblclick='*:DBLCLICK'
m.c_dragdrop='*:DRAGDROP'
m.c_dragenter='*:DRAGENTER'
m.c_dragheight='*:DRAGHEIGHT'
m.c_dragicon='*:DRAGICON'
m.c_dragleave='*:DRAGLEAVE'
m.c_dragmode='*:DRAGMODE'
m.c_dragover='*:DRAGOVER'
m.c_dragwidth='*:DRAGWIDTH'
m.c_dragwithin='*:DRAGWITHIN'
m.c_noiconlist='*:NOICONLIST'
m.c_objarray='*:OBJARRAY'
m.c_objclass='*:OBJCLASS'
m.c_objheight='*:OBJHEIGHT'
m.c_objmsg='*:OBJMSG'
m.c_objtxt='*:OBJTXT'
m.c_objwidth='*:OBJWIDTH'
m.c_overbutton='*:OVERBUTTON'
m.c_overheight='*:OVERHEIGHT'
m.c_overicon='*:OVERICON'
m.c_overtxt='*:OVERTXT'
m.c_overwidth='*:OVERWIDTH'
m.c_3d='*:3D'
m.c_no3d='*:NO3D'
m.iconlist=(wordsearch(m.c_noiconlist)==m.null)
IF m.drv_no=7
  IF EMPTY(NAME)
    REPLACE NAME WITH SYS(2015)
  ENDIF
  m.iconlist=(wordsearch(m.c_noiconlist)==m.null)
  m.cleanupdata=''
  m.codedata="dragover"+IIF(m.scxcount=1,"",;
             ALLTRIM(STR(m.scxcount,2)))+m.cr_lf+;
             "PARAMETERS m.objmsgonly"+m.cr_lf+;
             "PRIVATE m.objmsgonly,m.xlinkfnct,m.arraycount"+m.cr_lf+;
             "EXTERNAL ARRAY evlmsg"+m.cr_lf+m.cr_lf
  IF m.scxcount=1
    m.codedata=m.codedata+"IF m.scnno>1"+m.cr_lf+;
               "  m.xlinkfnct=[dragover]+ALLTRIM(STR(m.scnno,2))+"+;
               "[(m.objmsgonly)]"+m.cr_lf+"  RETURN &xlinkfnct"+m.cr_lf+;
               "ENDIF"+m.cr_lf
  ENDIF
  m.codedata2=''
  m.setupdata=''
  m.match=.F.
  SCAN ALL
    m.dragdrop=nobrackets(wordsearch(m.c_dragdrop))
    m.dragmode=nobrackets(wordsearch(m.c_dragmode))
    IF m.dragdrop==m.null
      IF .NOT.m.dragmode==m.null
        m.match=.T.
      ENDIF
      LOOP
    ENDIF
    m.match=.T.
    m.dragmode=fnctexpr(m.dragmode)
    m.dragover=fnctexpr(nobrackets(wordsearch(m.c_dragover)))
    m.dragenter=fnctexpr(nobrackets(wordsearch(m.c_dragenter)))
    m.dragwithin=fnctexpr(nobrackets(wordsearch(m.c_dragwithin)))
    m.dragleave=fnctexpr(nobrackets(wordsearch(m.c_dragleave)))
    m.objmsg=nobrackets(wordsearch(m.c_objmsg))
    IF m.objmsg==m.null
      m.objmsg=''
    ENDIF
    m.objtxt=nobrackets(wordsearch(m.c_objtxt))
    IF m.objtxt==m.null
      m.objtxt=''
    ENDIF
    IF EMPTY(m.objmsg)
      m.objmsg=m.objtxt
      IF EMPTY(m.objmsg)
        m.objmsg=SYS(2015)
      ENDIF
    ENDIF
    IF LEFT(m.dragdrop,1)=='*'
      m.dragdrop=m.null
    ELSE
      m.dragdrop=fnctexpr(m.dragdrop)
    ENDIF
    m.overheight=nobrackets(wordsearch(m.c_overheight))
    IF m.overheight==m.null
      m.overheight=''
    ENDIF
    m.overwidth=nobrackets(wordsearch(m.c_overwidth))
    IF m.overwidth==m.null
      m.overwidth=''
    ENDIF
    m.overtxt=nobrackets(wordsearch(m.c_overtxt))
    DO CASE
      CASE m.overtxt==m.null
        DO CASE
          CASE m.dragdrop==m.null
            m.overtxt=''
          CASE OBJTYPE=1
            m.overtxt="[]"
          CASE EMPTY(m.objmsg)
            m.overtxt="[Drop ]+m.objmsg"
          OTHERWISE
            m.overtxt="[Drop ]+m.objmsg+[ on ]+evlmsg(["+m.objmsg+"])"
        ENDCASE
      CASE EMPTY(m.overtxt)
        m.overtxt=''
      CASE .NOT.LEFT(m.overtxt,1)=="'".AND..NOT.LEFT(m.overtxt,1)=='"'
        m.overtxt="["+m.overtxt+"]"
    ENDCASE
    m.overbutton=nobrackets(wordsearch(m.c_overbutton))
    DO CASE
      CASE m.overbutton==m.null.OR.OBJTYPE#14
        m.overbutton=''
      CASE EMPTY(m.overbutton)
        m.overbutton=MLINE(NAME,1)
    ENDCASE
    m.overicon=nobrackets(wordsearch(m.c_overicon))
    DO CASE
      CASE m.overicon==m.null
        m.overicon=''
      CASE EMPTY(m.overicon)
        IF EMPTY(m.overbutton)
          IF OBJTYPE=1
            m.overicon="[]"
          ELSE
            m.overicon="IIF(FILE([OVERICON.ICO]),[OVERICON.ICO],[])"
            =updiconlst('OVERICON.ICO')
          ENDIF
        ELSE
          m.overicon=''
        ENDIF
      CASE .NOT.LEFT(m.overicon,1)=="'".AND..NOT.LEFT(m.overicon,1)=='"'
        =updiconlst(m.overicon)
        m.overicon="["+m.overicon+"]"
    ENDCASE
    m.objarray=nobrackets(wordsearch(m.c_objarray))
    DO CASE
      CASE m.objarray==m.null.OR.m.dragdrop==m.null
        m.objarray=''
      CASE EMPTY(m.objarray)
        m.objarray=SYS(2015)
    ENDCASE
    m.vpos2=VPOS
    m.hpos2=HPOS
    IF ALLTRIM(m.platform_)=='DOS'.OR.ALLTRIM(m.platform_)=='UNIX'
      m.hpos2=m.hpos2+1
      m.height2=HEIGHT-1
      m.width2=WIDTH-1
    ELSE
      m.height2=objheight()
      m.width2=objwidth()
    ENDIF
    m.codedata2="IF BETWEEN(m.objrow,"+ALLTRIM(STR(m.vpos2,7,3))+","+;
                ALLTRIM(STR(m.vpos2+m.height2,7,3))+").AND.BETWEEN(m.objcol,"+;
                ALLTRIM(STR(m.hpos2,7,3))+","+;
                ALLTRIM(STR(m.hpos2+m.width2,7,3))+")"+m.cr_lf
    m.codedata2=m.codedata2+;
                "  IF .NOT.m.objmsgonly"+m.cr_lf+;
                "    IF m.objstate=-1"+m.cr_lf
    IF .NOT.EMPTY(m.overbutton)
      m.codedata2=m.codedata2+;
                  "      "+m.overbutton+"=0"+m.cr_lf+;
                  "      SHOW GET "+m.overbutton+m.cr_lf
    ENDIF
    IF .NOT.EMPTY(m.objarray)
      m.codedata2=m.codedata2+;
                  "      IF TYPE(["+m.objarray+"])#[C]"+m.cr_lf+;
                  "        m.arraycount=1"+m.cr_lf+;
                  "        PUBLIC "+m.objarray+"(m.arraycount,2)"+m.cr_lf+;
                  "      ELSE"+m.cr_lf+;
                  "        m.arraycount=ALEN("+m.objarray+",1)+1"+m.cr_lf+;
                  "        DIMENSION "+m.objarray+"(m.arraycount,2)"+m.cr_lf+;
                  "      ENDIF"+m.cr_lf+;
                  "      "+m.objarray+"(m.arraycount,1)=m.objclass"+m.cr_lf+;
                  "      "+m.objarray+"(m.arraycount,2)=m.objmsg"+m.cr_lf
      m.cleanupdata="RELEASE "+m.objarray+m.cr_lf+m.cleanupdata
    ENDIF
    m.codedata2=m.codedata2+;
                "      ="+IIF(EMPTY(m.dragdrop).OR.m.dragdrop==m.null,".F.",;
                m.dragdrop)+m.cr_lf
    IF .NOT.EMPTY(m.dragover).OR..NOT.EMPTY(m.dragenter).OR.;
       .NOT.EMPTY(m.dragwithin).OR..NOT.EMPTY(m.dragleave).OR.;
       .NOT.EMPTY(m.overicon).OR..NOT.EMPTY(m.overheight).OR.;
       .NOT.EMPTY(m.overwidth).OR..NOT.EMPTY(m.overtxt)
      m.codedata2=m.codedata2+;
                  "    ELSE"+m.cr_lf+;
                  "      IF .NOT.m.objover==["+m.objmsg+"]"+m.cr_lf+;
                  "        IF .NOT.m.objover==m.null"+m.cr_lf+;
                  "          RETURN m.null"+m.cr_lf+;
                  "        ENDIF"+m.cr_lf+;
                  "        IF m.objstate#1"+m.cr_lf+;
                  "          m.objstate=0"+m.cr_lf+;
                  "        ENDIF"+m.cr_lf+;
                  "      ENDIF"+m.cr_lf
      m.codedata2=m.codedata2+;
                  "      DO CASE"+m.cr_lf+;
                  "        CASE m.objmsg0==["+m.objmsg+"]"+m.cr_lf+;
                  "          =.F."+m.cr_lf
      m.codedata3=''
      IF .NOT.EMPTY(m.overtxt)
        IF m.dragmode==m.null
          m.codedata3=m.codedata3+;
                      "          m.dragtxt="+m.overtxt+m.cr_lf
        ELSE
          m.codedata3=m.codedata3+;
                      "          m.dragtxt="+m.overtxt+m.cr_lf
        ENDIF
      ENDIF
      IF .NOT.EMPTY(m.overicon)
        m.codedata3=m.codedata3+;
                    "          m.dragicon="+m.overicon+m.cr_lf+;
                    "          m.objheight=-1"+m.cr_lf+;
                    "          m.objwidth=-1"+m.cr_lf+;
                    "          m.icontimer=-1000"+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.overheight)
        m.codedata3=m.codedata3+;
                    "          m.objheight="+m.overheight+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.overwidth)
        m.codedata3=m.codedata3+;
                    "          m.objwidth="+m.overwidth+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.overbutton)
        m.codedata3=m.codedata3+;
                    "          "+m.overbutton+"=1"+m.cr_lf+;
                    "          SHOW GET "+m.overbutton+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.codedata3)
        m.codedata2=m.codedata2+;
                    "        CASE m.objstate=0"+m.cr_lf+m.codedata3
      ENDIF
      m.codedata3=''
      IF .NOT.EMPTY(m.overtxt)
        m.codedata3=m.codedata3+;
                  "          m.dragtxt=[]"+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.overicon)
        m.codedata3=m.codedata3+;
                  "          m.dragicon=[]"+m.cr_lf+;
                  "          m.icontimer=-1000"+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.overbutton)
        m.codedata3=m.codedata3+;
                    "          "+m.overbutton+"=0"+m.cr_lf+;
                    "          SHOW GET "+m.overbutton+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.codedata3)
        m.codedata2=m.codedata2+;
                    "        CASE m.objstate=1"+m.cr_lf+m.codedata3
      ENDIF
      m.codedata2=m.codedata2+;
                  "      ENDCASE"+m.cr_lf
      m.codedata3=''
      IF .NOT.EMPTY(m.dragenter).OR..NOT.EMPTY(m.dragwithin).OR.;
         .NOT.EMPTY(m.dragleave)
        m.codedata2=m.codedata2+;
                    "      DO CASE"+m.cr_lf
        IF .NOT.EMPTY(m.dragenter)
          m.codedata2=m.codedata2+;
                      "        CASE m.objstate=0"+m.cr_lf+;
                      "          ="+m.dragenter+m.cr_lf
        ENDIF
        IF .NOT.EMPTY(m.dragleave)
          m.codedata2=m.codedata2+;
                      "        CASE m.objstate=1"+m.cr_lf+;
                      "          ="+m.dragleave+m.cr_lf
        ENDIF
        IF .NOT.EMPTY(m.dragwithin)
          m.codedata2=m.codedata2+;
                      "        CASE m.objstate=2"+m.cr_lf+;
                      "          ="+m.dragwithin+m.cr_lf
        ENDIF
        m.codedata2=m.codedata2+;
                    "      ENDCASE"+m.cr_lf
      ENDIF
    ENDIF
    IF .NOT.EMPTY(m.dragover)
      m.codedata2=m.codedata2+"      ="+m.dragover+m.cr_lf
    ENDIF
    m.codedata2=m.codedata2+;
                "    ENDIF"+m.cr_lf+;
                "  ENDIF"+m.cr_lf+;
                "  RETURN ["+m.objmsg+"]"+m.cr_lf+;
                "ENDIF"+m.cr_lf
    IF OBJTYPE=1
      m.setupdata=m.codedata2
      m.codedata2=''
    ELSE
      m.codedata=m.codedata+m.codedata2
    ENDIF
  ENDSCAN
  m.codedata=m.codedata+m.setupdata+"RETURN m.null"+m.cr_lf
  m.codedata2=''
  m.setupdata=''
  IF TYPE('m.iconfiles')=='N'.AND.m.iconfiles>0
    =ASORT(a_iconfile)
    m.codedata=m.codedata+"* Start of null icon file list"+m.cr_lf
    FOR m.i = 1 TO m.iconfiles
      IF .NOT.EMPTY(a_iconfile(m.i))
        m.codedata=m.codedata+"DO "+LOWER(a_iconfile(m.i))+m.cr_lf
      ENDIF
    ENDFOR
    m.codedata=m.codedata+"* End of null icon file list"+m.cr_lf
  ENDIF
  RELEASE a_iconfile,m.iconfiles
  m.codedata=m.codedata+m.cr_lf+"* END dragover"+m.cr_lf
  IF m.match.OR.m.screens>1
    =insfnct(m.codedata)
  ENDIF
  IF .NOT.EMPTY(m.cleanupdata)
    LOCATE
    REPLACE PROCCODE WITH m.cleanupdata+m.cr_lf+PROCCODE
  ENDIF
  GOTO BOTTOM
  RETURN .T.
ENDIF
SCAN ALL
  IF OBJTYPE=1.OR.OBJTYPE=6.OR.EMPTY(COMMENT).OR..NOT.drvobj()
    LOOP
  ENDIF
  m.vpos2=VPOS
  m.hpos2=HPOS
  m.height2=objheight()
  m.width2=objwidth()
  m.dragmode=nobrackets(wordsearch(m.c_dragmode))
  m.dragdrop=nobrackets(wordsearch(m.c_dragdrop))
  m.dragover=nobrackets(wordsearch(m.c_dragover))
  m.dragenter=nobrackets(wordsearch(m.c_dragenter))
  m.dragwithin=nobrackets(wordsearch(m.c_dragwithin))
  m.dragleave=nobrackets(wordsearch(m.c_dragleave))
  m.overicon=nobrackets(wordsearch(m.c_overicon))
  m.overbutton=nobrackets(wordsearch(m.c_overbutton))
  IF m.dragdrop==m.null.AND.(.NOT.m.dragover==m.null.OR.;
                 .NOT.m.dragenter==m.null.OR..NOT.m.dragwithin==m.null.OR.;
                 .NOT.m.dragleave==m.null.OR..NOT.m.overicon==m.null.OR.;
                 .NOT.m.overbutton==m.null)
    REPLACE COMMENT WITH m.c_dragdrop+" *"+m.cr_lf+COMMENT
  ENDIF
  m.objmsg=nobrackets(wordsearch(m.c_objmsg))
  IF m.objmsg==m.null
    m.objmsg=''
  ENDIF
  m.objarray=nobrackets(wordsearch(m.c_objarray))
  DO CASE
    CASE m.objarray==m.null
      m.objarray=''
    CASE EMPTY(m.objarray)
      m.objarray=SYS(2015)
      REPLACE COMMENT WITH m.c_objarray+' '+m.objarray+m.cr_lf+COMMENT
  ENDCASE
  m.objtxt=nobrackets(wordsearch(m.c_objtxt))
  IF m.objtxt==m.null
    m.objtxt=''
  ENDIF
  DO CASE
    CASE OBJTYPE#14.OR.m.overbutton==m.null
      m.overbutton=''
    CASE EMPTY(m.overbutton)
      m.overbutton=MLINE(NAME,1)
      IF EMPTY(WHEN)
        REPLACE WHENTYPE WITH 0, WHEN WITH ".F."
      ENDIF
  ENDCASE
  IF (_WINDOWS.OR._MAC).AND.INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC').AND.;
     (OBJTYPE=17.OR.OBJTYPE=12.OR.OBJTYPE=14)
    m.offset=4
    m.cfontstylm=IIF(m.fontstyle=1.OR.m.fontstyle=3,'B','')
    m.vfontratio=FONTMETRIC(1,'MS Sans Serif',8,'N')/;
                 (FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm)+;
                 FONTMETRIC(5,m.fontface,m.fontsize,m.cfontstylm))*;
                 (FONTMETRIC(1,WFONT(1,''),WFONT(2,''),WFONT(3,''))+;
                 FONTMETRIC(5,WFONT(1,''),WFONT(2,''),WFONT(3,'')))/;
                 FONTMETRIC(1,'FoxFont',9,'N')
    m.hfontratio=FONTMETRIC(6,'MS Sans Serif',8,'N')/;
                 FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)*;
                 FONTMETRIC(6,WFONT(1,''),WFONT(2,''),WFONT(3,''))/;
                 FONTMETRIC(6,'FoxFont',9,'N')
    IF OBJTYPE=17.AND..NOT.m.dragdrop==m.null.AND.;
       wordsearch(m.c_3d)==m.null.AND.wordsearch(m.c_no3d)==m.null
      REPLACE COMMENT WITH m.c_3d+' '+IIF(m.dragmode==m.null,'INSET','RAISED')+;
                           m.cr_lf+COMMENT
      IF OBJTYPE=14
        m.i=4
      ELSE
        m.i=8
      ENDIF
      =insrec(-1)
      m.vfactor=m.i*m.vfontratio*(SROWS()/SYSMETRIC(1))
      m.hfactor=2*m.i*m.hfontratio*(SROWS()/SYSMETRIC(2))
      REPLACE OBJTYPE WITH 7, OBJCODE WITH 4,;
              VPOS WITH m.vpos2-m.vfactor, HPOS WITH m.hpos2-m.hfactor,;
              HEIGHT WITH m.height2+2*m.vfactor, WIDTH WITH m.width2+2*m.hfactor,;
              PENSIZE WITH 1, PENPAT WITH 8,;
              COMMENT WITH m.c_3d+' '+IIF(m.dragmode==m.null,'1','-1')+' BOX'
      m.offset=m.offset+4
      SKIP
    ENDIF
    IF .NOT.EMPTY(m.objtxt)
      =insrec(-1)
      m.vfactor=m.offset*m.vfontratio*(SROWS()/SYSMETRIC(1))
      m.i=TXTWIDTH(m.objtxt,'MS Sans Serif',8)
      REPLACE OBJTYPE WITH 5, EXPR WITH '"'+m.objtxt+'"',;
              VPOS WITH m.vpos2+m.height2+m.vfactor,;
              HPOS WITH m.hpos2+m.width2/2-m.i/2,;
              HEIGHT WITH 1, WIDTH WITH m.i,;
              FONTFACE WITH 'MS Sans Serif', FONTSTYLE WITH 0,;
              FONTSIZE WITH 8, MODE WITH 1, COMMENT WITH m.c_no3d
      SKIP
    ENDIF
  ENDIF
  IF m.dragmode==m.null.OR..NOT.wordsearch(m.c_click)==m.null
    LOOP
  ENDIF
  DO CASE
    CASE OBJTYPE=17
      m.expr2=ALLTRIM(FULLPATH(EVALUATE(PICTURE),m.fscxbase))
      REPLACE PICTURE WITH '"'+m.expr2+'"'
    CASE OBJTYPE=5
      m.expr2=''
      FOR m.i = 1 TO MEMLINES(EXPR)
        m.expr2=m.expr2+MLINE(EXPR,m.i)
      ENDFOR
      m.expr2=ALLTRIM(EVALUATE(m.expr2))
    OTHERWISE
      m.expr2=ALLTRIM(MLINE(NAME,1))
      IF .NOT.EMPTY(m.expr2)
        m.expr2='@'+m.expr2
      ENDIF
  ENDCASE
  m.objclass=nobrackets(wordsearch(m.c_objclass))
  IF m.objclass==m.null
    m.objclass=''
  ENDIF
  IF EMPTY(m.objclass).AND..NOT.EMPTY(m.objarray)
    m.objclass='ARRAY'
  ENDIF
  IF EMPTY(m.objmsg)
    DO CASE
      CASE .NOT.EMPTY(m.objarray)
        m.objmsg=m.objarray
      CASE EMPTY(m.objtxt)
        m.objmsg=IIF(OBJTYPE=17,trimpath(m.expr2),m.expr2)
      OTHERWISE
        m.objmsg=m.objtxt
    ENDCASE
    IF EMPTY(m.objmsg)
      m.objmsg=SYS(2015)
      REPLACE COMMENT WITH m.c_objmsg+' '+m.objmsg+m.cr_lf+COMMENT
    ENDIF
  ENDIF
  IF EMPTY(m.expr2)
    m.expr2=m.objmsg
  ENDIF
  m.dragicon=nobrackets(wordsearch(m.c_dragicon))
  IF m.dragicon==m.null
    m.dragicon=m.expr2
  ENDIF
  =updiconlst(m.dragicon)
  m.dblclick=fnctexpr(nobrackets(wordsearch(m.c_dblclick)))
  m.dragheight=nobrackets(wordsearch(m.c_dragheight))
  DO CASE
    CASE m.dragheight==m.null.OR.VAL(m.dragheight)<0
      m.dragheight='-1'
    CASE EMPTY(m.dragheight)
      m.dragheight=ALLTRIM(STR(objheight(),9,3))
  ENDCASE
  m.dragwidth=nobrackets(wordsearch(m.c_dragwidth))
  DO CASE
    CASE m.dragwidth==m.null.OR.VAL(m.dragwidth)<0
      m.dragwidth='-1'
    CASE EMPTY(m.dragwidth)
      m.dragwidth=ALLTRIM(STR(objwidth(),9,3))
  ENDCASE
  m.objheight=nobrackets(wordsearch(m.c_objheight))
  DO CASE
    CASE m.objheight==m.null.OR.VAL(m.objheight)<0
      m.objheight='0'
    CASE EMPTY(m.objheight)
      m.objheight=ALLTRIM(STR(objheight(),9,3))
  ENDCASE
  m.objwidth=nobrackets(wordsearch(m.c_objwidth))
  DO CASE
    CASE m.objwidth==m.null.OR.VAL(m.objwidth)<0
      m.objwidth='0'
    CASE EMPTY(m.objwidth)
      m.objwidth=ALLTRIM(STR(objwidth(),9,3))
  ENDCASE
  IF (_WINDOWS.OR._MAC).AND.INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC').AND.;
     wordsearch(m.c_3d)==m.null.AND.wordsearch(m.c_no3d)==m.null
    IF OBJTYPE=5.AND.MODE=1
      REPLACE MODE WITH 0
    ENDIF
    REPLACE COMMENT WITH m.c_3d+' RAISED'+m.cr_lf+COMMENT
  ENDIF
  m.codedata="MDOWN().AND.BETWEEN(MROW(),"+ALLTRIM(STR(VPOS,9,3))+","+;
             ALLTRIM(STR(VPOS+m.height2,9,3))+").AND.BETWEEN(MCOL(),"+;
             ALLTRIM(STR(HPOS,9,3))+","+ALLTRIM(STR(HPOS+m.width2,9,3))+;
             ").AND."+"dragevnt(MWINDOW(),MROW(MWINDOW()),MCOL(MWINDOW()),"+;
             "SECONDS(),["+m.dragicon+"],["+m.objclass+"],["+m.objmsg+"],["+;
             m.objarray+"],["+m.dragmode+"],"+m.dragheight+","+m.dragwidth+;
             ","+ALLTRIM(STR(VPOS+m.height2/2,9,3))+","+;
             ALLTRIM(STR(HPOS+m.width2/2,9,3))+","+m.objheight+","+m.objwidth+;
             ","+ALLTRIM(STR(m.scxcount,2))+","+ALLTRIM(STR(m.scheme,2))+;
             ",["+m.dblclick+"])"
  IF OBJTYPE=17.OR.OBJTYPE=5.OR.OBJTYPE=7.OR.(OBJTYPE=15.AND.OBJCODE=0)
    m.codedata=m.codedata+".AND..F."
    m.r=RECNO()
    GOTO m.r_scxdata
    IF .NOT.insrec(-1)
      GOTO m.r
      LOOP
    ENDIF
    REPLACE VPOS WITH m.vpos2, HPOS WITH m.hpos2,;
            HEIGHT WITH m.height2, WIDTH WITH m.width2
    REPLACE OBJTYPE WITH 20, OBJCODE WITH 1,;
            NAME WITH 'm.null'+ALLTRIM(STR(RECNO(),6)), EXPR WITH '',;
            PICTURE WITH '"@*IHN "', FONTFACE WITH m.fontface,;
            FONTSTYLE WITH m.fontstyle, FONTSIZE WITH m.fontsize,;
            WHENTYPE WITH 0, WHEN WITH m.codedata,;
            INITIALVAL WITH '', INITIALNUM WITH 0, COMMENT WITH '*:NO3D'
    GOTO m.r
    SKIP
  ELSE
    DO CASE
      CASE EMPTY(WHEN)
        m.codedata=".NOT.("+m.codedata+")"
        REPLACE WHENTYPE WITH 0, WHEN WITH m.codedata
      CASE WHENTYPE=1
        m.codedata="IF "+m.codedata+m.cr_lf+"  RETURN .F."+m.cr_lf+"ENDIF"
        REPLACE WHEN WITH m.codedata+m.cr_lf+WHEN
      OTHERWISE
        m.codedata=".NOT.("+m.codedata+")"
        REPLACE WHEN WITH m.codedata+".AND."+WHEN
    ENDCASE
  ENDIF
ENDSCAN
GOTO BOTTOM
RETURN .T.

* END dragdrop



FUNCTION updiconlst
PARAMETERS m.iconfile
PRIVATE m.iconfile,m.fileext,m.updflag,m.at_pos,m.iconno,m.laststexct
PRIVATE m.animate,m.lowrange,m.highrange,m.iconmask,m.wildcard,m.ascflag

IF .NOT.m.iconlist
  RETURN .F.
ENDIF
m.iconfile=ALLTRIM(UPPER(m.iconfile))
m.animate=(ATC('animate(',m.iconfile)>0)
IF m.animate
  m.at_pos=ATC('animate(',m.iconfile)
  m.iconfile=SUBSTR(m.iconfile,m.at_pos+9)
  m.str_data=''
  m.at_pos=AT("'",m.iconfile)
  IF m.at_pos>0
    m.str_data=SUBSTR(m.iconfile,m.at_pos+1)
    m.iconfile=LEFT(m.iconfile,m.at_pos-1)
  ENDIF
  m.at_pos=AT('"',m.iconfile)
  IF m.at_pos>0
    m.str_data=SUBSTR(m.iconfile,m.at_pos+1)
    m.iconfile=LEFT(m.iconfile,m.at_pos-1)
  ENDIF
  m.iconfile=ALLTRIM(UPPER(m.iconfile))
  m.at_pos=AT(')',m.str_data)
  IF m.at_pos>0
    m.str_data=LEFT(m.str_data,m.at_pos-1)
  ENDIF
  m.str_data=ALLTRIM(UPPER(m.str_data))
ENDIF
m.fileext=UPPER(RIGHT(m.iconfile,4))
IF .NOT.m.fileext=='.BMP'.AND..NOT.m.fileext=='.ICO'
  RETURN .F.
ENDIF
IF m.animate.AND.'?'$m.iconfile
  m.at_pos=AT(',',m.str_data,2)
  IF m.at_pos=0
    RETURN .F.
  ENDIF
  m.lowrange=SUBSTR(m.str_data,m.at_pos+1)
  m.at_pos=AT(',',m.lowrange)
  IF m.at_pos=0
    RETURN .F.
  ENDIF
  m.iconmask=m.iconfile
  IF '??'$m.iconmask
    m.wildcard='??'
  ELSE
    m.wildcard='?'
  ENDIF
  m.highrange=SUBSTR(m.lowrange,m.at_pos+1)
  m.lowrange=LEFT(m.lowrange,m.at_pos-1)
  IF "'"$m.lowrange.OR.'"'$m.lowrange
    m.ascflag=.T.
    m.lowrange=ASC(SUBSTR(m.lowrange,2,1))
    m.highrange=ASC(SUBSTR(m.highrange,2,1))
  ELSE
    m.ascflag=.F.
    m.lowrange=VAL(m.lowrange)
    m.highrange=VAL(m.highrange)
  ENDIF
  IF m.lowrange>m.highrange
    m.iconno=m.lowrange
    m.lowrange=m.highrange
    m.highrange=m.iconno
  ENDIF
  FOR m.iconno = m.lowrange TO m.highrange
    IF m.ascflag
      m.iconfile=CHR(m.iconno)
    ELSE
      m.iconfile=ALLTRIM(STR(m.iconno,2))
      IF LEN(m.wildcard)>LEN(m.iconfile)
        m.iconfile=REPLICATE('0',LEN(m.wildcard)-LEN(m.iconfile))+m.iconfile
      ENDIF
    ENDIF
    m.iconfile=STRTRAN(m.iconmask,m.wildcard,m.iconfile,1,1)
    =updiconlst(m.iconfile)
  ENDFOR
  RETURN .T.
ENDIF
m.laststexct=SET('EXACT')
SET EXACT ON
IF TYPE('a_iconfile')#'C'
  PUBLIC a_iconfile(1)
  a_iconfile=''
ENDIF
IF TYPE('m.iconfiles')#'N'
  PUBLIC m.iconfiles
  m.iconfiles=0
ENDIF
IF EMPTY(m.iconfile).OR.ASCAN(a_iconfile,m.iconfile)>0
  m.updflag=.F.
ELSE
  m.updflag=.T.
  m.iconfiles=m.iconfiles+1
  DIMENSION a_iconfile(m.iconfiles)
  a_iconfile(m.iconfiles)=UPPER(m.iconfile)
ENDIF
IF m.laststexct=='ON'
  SET EXACT ON
ELSE
  SET EXACT OFF
ENDIF
RETURN m.updflag

* END updiconlst



FUNCTION fnctexpr
PARAMETERS fnctname

DO CASE
  CASE m.fnctname==m.null
    m.fnctname=''
  CASE .NOT.EMPTY(m.fnctname).AND..NOT.RIGHT(m.fnctname,1)==')'
    m.fnctname=m.fnctname+'()'
ENDCASE
RETURN m.fnctname

* END fnctexpr
