upcase	macro	char
	local	nocvt

	ifb	<char>

	upcase	al

	else

	cmp	char,'a'
	jb	nocvt
	cmp	char,'z'
	ja	nocvt
	sub	char,32
nocvt:
	endif
	endm

	page	66,132

cseg	segment	byte public 'CODE'
	assume	cs:cseg,ds:cseg,es:cseg
	org	100h

start	proc	near
	jmp	start1

	db	13,'DTR (c)1985 by Donavon Kuhn and Jon Niedfeldt',13,10,26

start1:
	mov	bl,0			;default com port (COM1:)
	mov	si,80h
start2:
	inc	si
	mov	al,[si]			;space off leading spaces
	cmp	al,' '
	jz	start2

	cmp	al,'?'
	jz	errexit

	upcase				;using UPCASE without a parameter
	cmp	al,'C'			;(defaults to AL)
	jnz	nocom

	mov	cl,[si][1]
	upcase	cl			;using UPCASE using another register
	cmp	cl,'O'
	jnz	nocom
				

	mov	al,[si][2]
	upcase	al			;using UPCASE with AL as the parm
	cmp	al,'M'
	jnz	nocom

	cmp	byte ptr [si][4],':'
	jz	check_port

errexit:
	lea	dx,errmsg
errexit1:
	mov	ah,9
	int	21h

	mov	ax,4c01h		;return ERRORLEVEL of 1
	int	21h

check_port:
	mov	al,[si][3]		;get the com number
	sub	al,'1'			;convert to binary
	cmp	al,3			;greater than com4?
	ja	errexit

	add	si,5

	mov	bl,al
nocom:
	xor	bh,bh	
	shl	bl,1
	mov	ax,40h
	mov	ds,ax
	mov	ax,ds:[bx]
	push	cs
	pop	ds

	cmp	ax,0
	jnz	comok

	lea	dx,ncstr
	jmp	errexit1


comok:
	mov	dx,ax
	add	dx,4
	in	al,dx

	dec	si
start3:
	inc	si
	mov	al,[si]			;space off leading spaces
	cmp	al,' '			;after COMx:
	jz	start3

	mov	al,[si]
	upcase
	cmp	al,'O'
	jnz	errexit

	mov	al,[si][1]
	upcase

	cmp	al,'N'
	jnz	noton

	or	al,3			;set dtr bit
	out	dx,al

	lea	dx,onstr

exitok:
	mov	ah,9
	int	21h

	mov	ax,4c00h
	int	21h

noton:
	cmp	al,'F'
	jnz	notoff

	and	al,0fch
	out	dx,al

	lea	dx,offstr
	jmp	exitok

notoff:
	jmp	errexit

errmsg	db	'Usage:  DTR [COM1:|COM2:|COM3:|COM4:] ON|OFF',13,10,'$'
onstr	db	'DTR is now ON',13,10,'$'
offstr	db	'DTR is now OFF',13,10,'$'
ncstr	db	'COM port not found',13,10,'$'

start	endp

cseg	ends
    	end	start
                                   