unit Dosvalu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TDosEnv = class(TComponent)
  private
     FDosIn : String;
     FDosVal: String;
     procedure SetDosIn(Value : string);
     procedure SetDosVal(Value : string);
  published
     property DosEnv: string read FDosIn  write SetDosIn;
     property DosVal: string read FDosVal write SetDosVal;
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Freeware', [TDosEnv]);
end;

procedure TDosEnv.SetDosIn(Value : string);
begin
     FDosIn := Value;
     SetDosVal(value);
end;

procedure TDosEnv.SetDosVal(Value : string);
var
   P : PChar;
   S : String;
   E : String;
begin
   FDosVal := '';
   if Length(FDosIn) > 0 then
     begin
       P := GetDOSEnvironment;
       while P[0] <> #0 do
         begin
            S := StrPas(P);
            E := S;
            S := Copy(UpperCase(S), 1, Length(FDosIn) + 1);
            if S = UpperCase(FDosIn) + '=' then
              begin
                FDosVal := Copy(E, Length(FDosIn) + 2, Length (E));
              end;
            P := StrEnd(P) + 1;
         end;
     end
   else
     FDosVal := '';

end;

end.
