;****************************************************************************
; Filename: STRNCPY.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1995.03.12
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: PSZ @strncpy(PSZ dest,PSZ source,ULONG length);
;  Comment: Copies a string from <source> to <dest> and returns a pointer to
;           the destination string.
;    Input: Eax, dest - pointer to destination string
;           Edx, source - pointer to source string
;           Ecx, length - maximum length to copy from the source string
;   Output: pointer to the destination string
;****************************************************************************

        Include STDDEF.INC

        Codeseg

Proc    strncpy ,3
                Jecxz   @@Exit06
                Push    Eax,Ebx
                Jmp     @@Next01
        Align   4
@@Loop01:       Add     Eax,4
@@Next01:       Sub     Ecx,4
                Mov     Ebx,[Edx]
                Jbe     @@Exit04
                Add     Edx,4
                TestZ   Bl
                Jz      @@Exit01
                TestZ   Bh
                Jz      @@Exit02
                Test    Ebx,0FF0000h
                Jz      @@Exit03
                TestZ   Ebx,0FF000000h
                Mov     [Eax],Ebx
                Jnz     @@Loop01
                Pop     Ebx,Eax
@@Exit06:       Ret
        Align   4
@@Exit04:       Jz      @@Exit05
                Cmp     Cl,-3
                Je      @@Exit01
                TestZ   Bl
                Je      @@Exit01
                Cmp     Cl,-2
                Je      @@Exit02
                TestZ   Bh
                Je      @@Exit02
@@Exit03:       Mov     [Eax],Bx
                Mov     [Byte Eax+2],0
                Pop     Ebx,Eax
                Ret
        Align   4
@@Exit05:       Mov     [Eax],Ebx
                Pop     Ebx,Eax
                Ret
        Align   4
@@Exit02:       Mov     [Eax],Bx
                Pop     Ebx,Eax
                Ret
        Align   4
@@Exit01:       Mov     [Eax],Bl
                Pop     Ebx,Eax
                Ret
Endp

        End
