comment ~
*****************************************************************************
         Example program for DOS32 dos-extender.

  By Adam Seychell

   Example on using the VESA 2.0 BIOS Interface. This program
uses the VESA.ASM library from DOS32 and takes full advatage of the protected
mode interfacing if available including linear memory mapping supported on
VBE 2.0. If you don't have a VESA v2.0 driver for your video card then
get your self copy of UniVBE v5.1+ Universal VESA driver. The latest
version is availible via FTP at ftp.scitechsoft.com

The full VBE 2.0 specification is available from ftp.scitechsoft.com
or in ascii form x2ftp.oulu.fi:/pub/msdos/programming/specs/vbe20.zip



*****************************************************************************
~
.386
.MODEL FLAT , C
.STACK

include vesa.inc                ; include macros


VIDEO_MODE_NUMBER = 101h


;
;  Macro to print some text on the screem
;
Print MACRO string
local @text,@skip
    mov edx,offset @text
    mov ah,9
    int 21h
    jmp @skip
@text db string,13,10,36
@skip:
ENDM



.DATA
VideoPtr              DD ?
Palette  Label Byte
Include palette.inc
counter               DB  ?
Linear_Mode_Available DB 1
CurrentBank           DB ?

.CODE


;***************************************************************************
;                           START OF PROGRAM
;***************************************************************************

VBEstart PROC

    ; Set video mode for linear memory mapping
    ;
         mov   ax,VIDEO_MODE_NUMBER or 4000h    ; set bit 14 of mode number
         call  CheckVbeMode
         jnc LinearModeisOk

    ; if linear memory mapping failed then try ordinary bank switching
    ;
         mov   ax,VIDEO_MODE_NUMBER
         call  CheckVbeMode
         jnc modeisOk
         cmp    dl,1
         je   NoVESA
         cmp    dl,2
         je   @@ModeNotFound
         jmp  ModeNotGood

modeisOk:
         Mov   Linear_Mode_Available,0

LinearModeisOk:


        mov   VideoPtr,eax
    ;
    ; Display messages
    ;
        Print 'This is an example program using the VESA 2.0 driver'
        Print ' '
        Print '  -Video mode 640 x 480 at 256 colors found'
        cmp  Linear_Mode_Available,1
        jne  J90
	        Print '  -Linear memory mapping is available.'
        jmp  J91
J90:

		;** if linear mode not available then print message saying so
        ;   and then look for protected mode bank switching VBE 2.0 services.
        ;
		; **************************
	    Print '  -Linear memory mapping not available.'
        mov  ax,4F0Ah
        mov  bl,0
        int 10h
        cmp ax,004Fh
        je J80
        Print <'  Protected mode bank switching not available, using Real Mode'>
        Print <'  bank switching.'>
        jmp J91
J80:
        Print <'  -Using protected mode bank switching'>
J91:
         Print <13,10,'   press any key to display pattern...'>

         mov ah,0
         int 16h




         call  SetVbeMode       ; set the video mode to previous call to
                                ; CheckVbeMode

;----------------------------------------------------------------------------
; The video mode setting up is now complete and the applicaion is ready
; to start writting to video memory ( address defined in VideoPtr ).
;----------------------------------------------------------------------------



    ;
    ; Set palette
    ;
         mov    al,0
         mov    dx,3C8h
         out    dx,al
         mov    esi,Offset Palette
         mov    dx,3C9h
         mov    ecx,768
         cld
         rep    outsb


    ;
    ; Fill in screen with some patterns
    ;

         cmp  Linear_Mode_Available,1
         jne  UsingBankSwitching

      ;*******************************************
      ; Fill screen using the linear memory map
      ;*******************************************

         mov     edi,VideoPtr
         mov     edx, (640*480)/512
         mov     counter,1
         mov     bl,0
Loop01:  mov     ecx,512/4
         mov     al,bl
         mov     ah,bl
         push    ax
         push    ax
         pop     eax
         or      al,0ffh
         rep     stosd
         add     bl,counter
         jnz J99
         sub     bl,counter
         neg     counter
J99:     dec     edx
         jnz Loop01
         jmp  finished

      ;*******************************************
      ; Fill screen using bank switching method
      ;*******************************************
UsingBankSwitching:
         mov     CurrentBank,0
         mov     counter,1
         mov     bl,0
loop02:  mov     edi,VideoPtr
         mov     dl,CurrentBank
         SetBank                                ; set bank to DL
         mov     bh,65536/512
Loop03:  mov     ecx,512/4
         mov     al,bl
         mov     ah,bl
         push    ax
         push    ax
         pop     eax
         or al,0ffh
         rep     stosd
         add     bl,counter
         jnz J98
         sub     bl,counter
         neg     counter
J98:     dec     bh
         jnz Loop03
         inc     CurrentBank
         cmp     CurrentBank,5
         jb loop02


finished:


        mov    ah,0          ; Wait for key using BIOS call
        int    16h

        mov    ax,3          ; Return to TEXT mode
        int    10h

Exit:
         Mov    Ax,4C00h    ; Exit this program
         Int    21h



;------------------------ Error messages ---------------------------------

ModeNotGood:
         Print <'VESA BIOS video mode 640x480x256 is incompatible'>
         jmp Exit
@@ModeNotFound:
         Print 'Video mode 640x480x256 not supported  ( VESA mode 101h )'
         jmp Exit

NoVESA:
         Print 'VESA BIOS not installed'
         jmp Exit

VBEstart ENDP





End VBEstart
