;*****************************************************************************
; INT24H.ASM          Example:  handing critical errors from DOS.
;
;
; This program will hook interrupt 24h which is the DOS critical
; error handler. DOS32 automatically redirects INT 24h from real mode to
; INT 24h in protected mode. In other words, your protected mode programs
; may handle DOS critical errors simply by hooking interrupt 24h.
; Normally the command interpreter ( e.g COMMAND.COM ) hooks this interrupt
; and displays a message on the screen asking the user to Abort, Ignore,
; Fail or Retry the operation.
;      The protected mode critical error handler below works in a similar
; way except it does not allow to (A)bort since this will terminate the
; application without exiting from protected mode properly.
;
;
;*****************************************************************************

.386
.model flat
.stack 1024


	.DATA?

Old_Int24h_vector       DF ?
return_code             db ?
dummystring             db 256 dup (?)

	 .DATA
mesg1        db ' Please remove disk from drive A, so that the INT 24h critical error is called.'
             db 13,10,13,10,'Press any key ...',13,10,36
exit_mesg    db 'Program is exiting ',13,10,36


     .CODE

start:


  ;
  ; Save the INT 24h vector before we modify it
  ;
    mov     ax,204h
    mov	    bl,24h
    int     31h
    Mov     Dword ptr Old_Int24h_vector,edx
    Mov     Word ptr Old_Int24h_vector[4],cx

  ;
  ; Set INT 24h vector point to our critical error handler ( see below )
  ;
    mov     ax,205h
    mov	    bl,24h
    mov	    cx,cs
    mov     edx,Offset  Int24h_Handler
    int     31h



  ; Display a message to let the user know the critical error handler
  ; is about to be invoked.
  ;
    mov     edx,offset mesg1
    mov     ah,9
    int     21h
    mov     ah,0            ; wait for a key
    int     16h


  ;
  ; Access drive A just to make DOS invoke a critical error (INT 24h)
  ;
    mov     ah,47h                               ; get CWD
    mov     esi,offset dummystring
    mov     dl,1
    int     21h


   ;
   ; Restore the origonal INT 24h vector
   ;  just good programming practice :)
   ;
    mov     ax,204h
    mov	    bl,24h
    Mov     edx,Dword ptr Old_Int24h_vector
    Mov     cx,Word ptr Old_Int24h_vector[4]
    int     31h


   ;
   ; Exit program with a message.
   ;
        mov     edx,offset exit_mesg
        mov     ah,9
        int     21h
        mov     ax,4c00h
        int     21h


;************************************************************************
;
; INTERRUPT 24H --CRITICAL ERROR HANDLER-- (PROTECTED MODE)
;
; Note: must not exit this handler with return code number 2
; (abort to DOS) or else DOS32 won't exit to protected mode correctly.
;************************************************************************
Int24h_Handler PROC FAR
        push 	ds                                 ; Save registers used
    	pushad
        mov    	ax,_DATA                           ; load DS with data selector
        mov     ds,ax

        mov     edx,offset Error_message
        mov     ah,9
        int     21h

  ; Loop around to read the keyboard
  ;

getkeyLOOP:
        mov     ah,0            ; get bios key
        int     16h
        cmp     ah,17h
        jne  J09
         mov    return_code,0   ; ignore
         jmp gotkey
J09:
        cmp     ah,21h
        jne  J08
         mov    return_code,3   ; Fail
         jmp gotkey
J08:
        cmp     ah,13h
        jne  J07
         mov    return_code,1   ; Try again
         jmp gotkey
J07:
	jmp getkeyLOOP
gotkey:

        popad
        mov     al,return_code
        pop     ds
    	iretd                    ; Return from the interrupt.

Error_message  LABEL BYTE
db 13,10
db ' This message has been printed by the INT 24h critical error handler.',13,10
db '  Please select one of the following actions ',13,10
db '  F) fail',13,10
db '  R) retry',13,10
db '  I) ignore',13,10
db '$'

Int24h_Handler ENDP

end start
