comment ~
****************************************************************************
RUNME.ASM
                A basic example of using a DOS32 Loadable Library

Notes: As explained in the DOS32 documentaion, the use of the Library's
global public symbol can be used in many differnet ways for the
application to interfacing to/from the dynamic library. This example program
will load the library file named A_DLL.DLL which contains a single
two functions. The public in A_DLL.DLL will point to two pointer that
refrence these two functions. See A_DLL.ASM (source of A_DLL.DLL).


to compile EXE:

 tasm dlltest
 dlink dlltest

****************************************************************************
~
.386
.model flat ,C
.stack
.code



;
;  Macro to print some text on the screem
;
Print MACRO string
local @text,@skip
    pushad
    mov edx,offset @text
    mov ah,9
    int 21h
    popad
    jmp @skip
@text db string,13,10,36
@skip:
ENDM


; varibles holding pointers to each function in A_DLL.DLL
;
function_1   dd ?
function_2   dd ?





dll_FileName db 'a_dll.dll',0

start:

      Print <'Loading DOS32 dynamic library "a_dll.dll" ... '>

  ;
  ; Function EE10h to setup a DOS32 Dynamic Linkable Library file.
  ;
  ; Expects CS:EDX -> pointing to file name.
  ;            EBX = seek position from beginning of file.
  ;
  ;
    mov  ax,0EE10h
    mov  edx, Offset dll_FileName
    mov  ebx,0
    int  31h
    jnc  Ok
    cmp  al,1                   ; if carry set then get error code from AL
    je   error1                 ; 1 = file not found
    cmp  al,2                   ; 2 = bad format
    je   error2
Ok:

  ; Returns EAX with number of bytes required to load the library.
  ;         EBX = DLL file size


  ;
  ; Allocate memory for the loadable program.
  ;
    mov edx,eax
    mov ax,0EE42h
    int 31h
    jc error


  ;
  ; Load the DLL
  ;
  ;      Expects CS:EDX -> pointing to memory block to holding
  ;                         the DLL program.
  ;
    mov  ax,0EE11h
    int  31h
    jc error1

    Print <'loaded successfully'>

    ;
    ; Returns CS:EDX -> pointing to the DLL public symbol.
    ;
    ; DEXAMPLE.DLL is written so that the public symbol points
    ; to an array of pointers to two procedures in the DLL.
    ;

    mov     eax,[edx]             ; get first function pointer
    mov     [function_1],eax
    mov     eax,[edx+4]           ; get second function pointer
    mov     [function_2],eax


   ; Use these two functions
   ;

    call    function_1

    call    function_2


exit:
    mov ax,4c00h
    int 21h


;---------------------------------------------------------------------
error:
    mov edx, offset error_mesg
    mov ah,9
    int 21h
    jmp exit
error_mesg db 'not enough memory to load DLL',13,10,36

;---------------------------------------------------------------------
error1:
    mov edx, offset error1_mesg
    mov ah,9
    int 21h
    jmp exit
error1_mesg db 'Error opening loadable library, TEST.DLL',13,10,36

;-------------------------------------------------------------------
error2:
    mov edx, offset error2_mesg
    mov ah,9
    int 21h
    jmp exit
error2_mesg db 'Bad DOS32 Lodabale Library format',13,10,36


end start