/*
Deja News Reader
v. 1.23
6 March 1997
Eric Walker
High Boskage House
dnreader@highboskage.com

Requires Quercus Systems RexxLib (included)
  & IBM EWS RxSock (on ftp site below).

Latest version always available by ftp from--

  ftp.scruznet.com/users/ewalker/public/dnreader


Changes:
--------

1.1 -  Added LOADSDIR to Expose list for routine PickHit, to allow Search HTML to be loaded.
       Added PopUp message box to routine GetPickFrom list for cases of zero-length 
         articles/hits list.
       (Release package added fully functional Quercus Systems DLLs.)

1.11 - Deleted improper open-quote on attribute number in above-cited PopUp call.

1.19 - (Not generally released): a series of small fixes and improvements,
       from 1.19a through most of the alphabet.

1.20 - Major changes throughout.  A few specifics--
       Added configurable variable BOOPS to control sound generation throughout; left
         sound always on at Syntax/Halt exits.
       Added configuration variable ARTCOLOR for article-screen colors.
       Dropped MsgMax as an option; fixed at 100 per load.
       Very substantially reworked the PowerSearch routine; some bugfix, but also added
         "next block" & "last block" as options, and explanatory on-screen text.
       Added "next"/previous block" and range/total descriptors to articles lists.
       Added option to retain extant previous download files & preserve serial numbering.
       Allowed new posting from group articles list as well as from in an article.
       Made correct e-mail address a near-necessity before posting allowed.
       Expanded testing of DLL loading.

1.21   (Not generally released.)

1.22   Added search-criteria setup screen.  Made reply-post quote symbol configurable.
       Made several screen colors configurable.  Made reply-text intro configurable.
       Updated help text for article-reading.  Rectified articles counts.

1.23   Modified Article-Read algorithm to keep up with Deja News' change in their
       article-page format--which, OF COURSE, occurred the day I released 1.22.

*/


/***SETUP & INITIALIZATION:***************************************************/

/*    Essentials:  */

Signal On SYNTAX
Signal On HALT
'cls'


/*    Initialize "global" values.  */
cr=D2C(13)
crlf=D2C(13)||D2C(10)
escape=D2C(27)
alfabase=64  /* ascii of "A" minus 1 */
boops=1
rexxutils=0
quercuslib=0
quercuswin=0
rexxsock=0
help=0
global='rexxutils quercuslib quercuswin rexxsock cr crlf escape alfabase help boops'


/*    Rexx Function Extensions:  */

/*      Add Extended REXX Functions.  */
junk='Found RexxUtil DLL already available.'
If RxFuncQuery('SysLoadFuncs') Then
  Do
    rexxutils=1
    junk='Loaded RexxUtils DLL functions locally.'
    If RxFuncAdd('SysLoadFuncs','RexxUtil','SysLoadFuncs')=0 Then Call SysLoadFuncs
     Else
      Do
        Say 'Unable to register OS/2 RexxUtils DLL functions.'
        Say
        Exit -1
      End
  End

/*      Add Quercus REXXLIB Functions.  */
text='Found RexxLib DLL already available.'
If RxFuncQuery('rexxlibregister') Then
  Do
    quercuslib=1
    text='Loaded RexxLib DLL functions locally.'
    If RxFuncAdd('rexxlibregister','rexxlib','rexxlibregister')=0 Then Call RexxLibRegister
     Else
      Do
        Say 'Unable to register Quercus RexxLib DLL functions.'
        Say
        Exit -2
      End
  End

Call CursorType ,,0  /* remove cursor from screen */
Call ScrWrite 1,1,Center('Setting up . . . ',80),,,31
Call ScrWrite 25,1,Center('Loading needed DLL functions . . . ',80),,,31
Call ScrWrite  5,1,Center(junk,80),,,14
Call ScrWrite  8,1,Center(text,80),,,14

/*      Add Quercus Window Functions.  */
text='Found RexxWin DLL already available.'
If RxFuncQuery('w_open') Then
  Do
    quercuswin=1
    text='Loaded RxWin DLL functions locally.'
    If RxFuncAdd('w_register','rxwin30','rxwindow')=0 Then Call W_Register
     Else
      Do
        Call ScrWrite 11,1,'Unable to register Quercus RexxLib DLL functions.',,,12
        Call ScrWrite 13,1,Center('(Press any key to exit.)',80),,,15
        Call InKey
        'cls'
        Exit -3
      End
  End
Call ScrWrite 11,1,Center(text,80),,,14
hello=W_Open(18,1,5,80,79)
Call W_Border hello
Call W_ScrWrite hello,3,2,Center('Remember!  The <F1> key brings help at any list-selection screen.',78)

/*      Add RxSock DLL functions.  */
text='Found RxSock DLL already available.'
If RxFuncQuery('SockLoadFuncs') Then
  Do
    rexxsock=1
    text='Loaded RxSock DLL functions locally.'
    If RxFuncAdd('SockLoadFuncs','RxSock','SockLoadFuncs')=0 Then Call SockLoadFuncs dummy
     Else
      Do
        Call ScrWrite 14,1,'Unable to register IBM-EWS RxSock DLL functions.',,,12
        Call ScrWrite 16,1,Center('(Press any key to exit.)',80),,,15
        Call InKey
        'cls'
        Exit -4
      End
  End
Call ScrWrite 14,1,Center(text,80),,,14
Drop junk text


/*    Initializations:  */
Call ScrWrite 25,1,Center('Initializing values . . . ',80),,,31

/*      Set universals.  */
homedir=Directory()
Parse Arg poster

/*      Set scan codes.  */
pgup=D2C(73)
pgdn=D2C(81)
upkey=D2C(72)
dnkey=D2C(80)
leftkey=D2C(75)
rightkey=D2C(77)
ins=D2C(82)
del=D2C(83)
homekey=D2C(71)
endkey=D2C(79)
helpf1=D2C(59)
scancodes='pgup pgdn upkey dnkey leftkey rightkey ins del homekey endkey helpf1'

/*      Initialize over-rideable values.  */
username='nemo'
password='nemo@nowhere.org'
email='nemo@nowhere.org'
myname='anonymous'
myorg='none'
groupsdir=homedir'\GROUPS\'
loadsdir=homedir'\LOADS\'
daysback='7'
editor='E.EXE'
quoter='| '
intro='based on which I say:'
clustercolor=3
groupcolor=6
artcolor=96
artpick1=112
artpick2=128
hitpick=10
specpick=13

/*      Over-ride via CNF file.  */
Call FileRead 'DNREAD.CNF','dummy.'
Do line=1 to dummy.0
  If Pos('boops=',dummy.line)>0 Then Interpret dummy.line
  If Pos('poster=',dummy.line)>0 Then Interpret dummy.line
  If Pos('username=',dummy.line)>0 Then Interpret dummy.line
  If Pos('password=',dummy.line)>0 Then Interpret dummy.line
  If Pos('email=',dummy.line)>0 Then Interpret dummy.line
  If Pos('myname=',dummy.line)>0 Then Interpret dummy.line
  If Pos('myorg=',dummy.line)>0 Then Interpret dummy.line
  If Pos('groupsdir=',dummy.line)>0 Then Interpret dummy.line
  If Pos('loadsdir=',dummy.line)>0 Then Interpret dummy.line
  If Pos('daysback=',dummy.line)>0 Then Interpret dummy.line
  If Pos('editor=',dummy.line)>0 Then Interpret dummy.line
  If Pos('quoter=',dummy.line)>0 Then Interpret dummy.line
  If Pos('intro=',dummy.line)>0 Then Interpret dummy.line
  If Pos('clustercolor=',dummy.line)>0 Then Interpret dummy.line
  If Pos('groupcolor=',dummy.line)>0 Then Interpret dummy.line
  If Pos('artcolor=',dummy.line)>0 Then Interpret dummy.line
  If Pos('artpick1=',dummy.line)>0 Then Interpret dummy.line
  If Pos('artpick2=',dummy.line)>0 Then Interpret dummy.line
  If Pos('hitpick=',dummy.line)>0 Then Interpret dummy.line
  If Pos('specpick=',dummy.line)>0 Then Interpret dummy.line
End
Drop line dummy.
If boops<>0 and boops<>1 Then boops=1

/*      Initialize pointers cv.  */
pointers.0=5
Do junk=1 To 5
  pointers.junk=''
End
!nextup=1
!oneback=2
!hitlist=3
!thread=4
!author=5
Drop junk

/*      Initialize miscellaneous values.  */
svcclass='dncurrent'
ageweight='1'
agesign='1'
showsort='score'
msgmax='100'
gserial=0
aserial=0
groups.0=0
lastlook.0=0
block.0=0

/*      Load Cluster-name lists.  */
Call SysFileTree groupsdir'*.DNR','lists.','FO'
gnames.0=1+lists.0
gnames.1=' SEARCH BY KEYWORD(S)'
Do i=1 To lists.0
  Call FileRead lists.i,'dummy.'
  j=i+1
  gnames.j=dummy.1
End
Drop dummy.


/*    Net SetUp:  */
Call ScrWrite 25,1,Center('Resolving addresses . . . ',80),,,31

/*      Get queries-host dot address.  */
queryserver=NewHost('search.dejanews.com')
If queryserver='' Then Call ItQuits 'Unable to resolve query-server name--exiting.',-5

/*      Get posting-host dot address.  */
postserver=NewHost(poster)
If postserver='' Then Call ItQuits 'Unable to resolve posting-server name--exiting.',-6


/*    Set exposure groups:  */
poststuff='poster postserver username password email myname myorg editor loadsdir groupname quoter intro'
artstuff='loadsdir groupname wason groupnumber artibase oldbase queryserver'
criteria='svcclass ageweight agesign showsort msgmax'
colors='clustercolor groupcolor artcolor artpick1 artpick2 hitpick specpick'


/*    Clean plate?:  */
Call ScrWrite 25,1,Center('Cleaning up . . . ',80),,,31
Call SysFileTree loadsdir'*.*','dummy.','FO'
If (dummy.0)>0 Then
  Do
    If PopUp('Clean out Loads directory?',2)='Y' Then Call KillAll '*.*'
     Else
      Do
        Call SysFileTree loadsdir'A*.*','dummy.','FO'
        top=dummy.0
        If top>0 Then
          Do
            title=Word(ParseFN(dummy.top),3)
            aserial=1+Format(SubStr(title,2))
          End
        Call SysFileTree loadsdir'G*.*','dummy.','FO'
        top=dummy.0
        If top>0 Then
          Do
            title=Word(ParseFN(dummy.top),3)
            gserial=1+Format(SubStr(title,2))
          End
      End
    Call W_Close hello
  End
 Else
  Do
    Call Delay 3
    Call W_Close hello
  End
Call CursorType ,,0  /* re-remove cursor from screen */
drop dummy. top title hello i


/***MAIN ACTIVITY LOOPS:******************************************************/

clusterbase=0
Do Forever  

/*  pick a Cluster  */
  lookback=daysback
  cluster=Clusters()
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
Clusters returns a cluster number (an index into cv
LISTS.) or zero (for a PowerSearch) or causes exit
from the whole program (with, obviously, no return).
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

  groupbase=0
  Do Forever  
  /*  pick a Group  */               

    If cluster=0 Then  /* search selected as "cluster" */
      Do
        If PowerSearch() Then
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
PowerSearch either gets a search Hitlist and stores it
to disk as G0.HTM, returning 1, or it fails or is
aborted and returns zero.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
          Do
            groupname='SEARCH'  /* to avoid bypassing article selection */
            groupnumber=-1
          End
         Else groupname=''  /* will bypass article selection */
      End

     Else  /* a real cluster selected */
      Do
        groupname=GroupNames(cluster)
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
GroupNames returns either the actual name of a specific
group in the specified cluster or else a nul if group
selection is abandoned (by <Esc>).
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
        If groupname<>'' Then 
          Do
            Call ArraySearch 'groups.','found.',groupname  /* see if previously loaded */
            If found.0=1 Then
              Do
                /* this group's articles list was previously fetched */
                groupnumber=found.1
                If (lastlook.groupnumber)<>lookback Then
                  Do                                                            
                    Call BlockRen groupnumber,'HOLD'
                    groupnumber=NewGroup(groupname,groupnumber-1)  /* -1 offsets updating */
                    If groupnumber=found.1 Then 
                      Do
                        lastlook.groupnumber=lookback
                        block.groupnumber=0  /* restart at beginning */
                        Call KillAll 'X'groupnumber'.*'
                        Call DosReName loadsdir'G'groupnumber'.HTM',loadsdir'G'groupnumber'.0'
                      End
                     Else 
                      Do
                        groupname=''
                        Call BlockRen groupnumber,'BACK'
                        Call PopUp 'NO revised article list returned.',2,'X'
                      End
                  End
              End
             Else
              Do
                /* this is a new group, so get new article list */
                newgserial=NewGroup(groupname,gserial)
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
NewGroup gets the articles list for GROUPNAME and assigns
an updated GSERIAL to that group.  The list is saved
to disk as Ggserial.HTM; if it fails to load a list,
it returns zero.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
                If newgserial>0 Then
                  Do
                    /* update "loaded" cv list with new group */
                    gserial=newgserial
                    groupnumber=gserial
                    groups.0=gserial
                    groups.gserial=groupname
                    lastlook.0=gserial
                    lastlook.gserial=lookback
                    block.0=gserial
                    block.gserial=0
                    Call DosReName loadsdir'G'gserial'.HTM',loadsdir'G'gserial'.0'
                  End  /* got new art list ok */
                 Else 
                  Do
                    Call PopUp 'NO article list returned.',2,'X'
                    groupname=''
                  End

              End  /* art list not previously gotten */
          End  /* group picked from cluster */

      End  /* real cluster selected */
    If groupname='' Then Leave  /* go back to cluster selection */
      
    /*  pick an Article  */
    artibase=0
    query=''
    Do Forever
      If query='' Then  /* no outstanding article/list to get */
        Do
          Select
            When groupnumber<0 Then query=PickHit()  /* search */
            When groupnumber=0 Then query=PickSpecial()  /* thread or other list */
            Otherwise query=PickArticle(groupnumber)  /* actual article */
          End
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
The sundry Picks all return the needed query string for 
fetching an article, or a nul if selection was aborted.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
          If query='' & groupnumber=0 Then  /* leaving thread picking */
            Do
              Call ScrClear 7,' ',2,1,23,80
              Call ScrWrite 25,1,Center('Reloading group article list . . . ',80),,,31
              groupnumber=wason
              artibase=oldbase
              If groupnumber>0 Then query=PickArticle(groupnumber,1)
               Else query=''  /* was thread of a searched article */
            End
        End
      If query='' Then Leave  /* article selection finished */

      newaserial=MakeQuery(query,queryserver,aserial,'A')
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
MakeQuery gets the server's response and saves it in a
file named Aserial.HTM, updating ASERIAL as it does so;
it returns the updated ASERIAL or, for any failure, -1.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
      If newaserial<1 Then 
        Do
          query=''  /* avoid endless retries */
          Call PopUp 'Article NOT returned.',5,'X'
        End
      If newaserial=0 Then Iterate

      aserial=newaserial
      If ReadArticle(aserial)>0 Then query=ViewArticle(aserial)  /* follow-on requested */
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
ReadArticle converts the HTML to two files: the header
info (Haserial.TXT) and the text proper (Aaserial.TXT).
It also leaves pointers to other jumps in cv POINTERS.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
       Else 
        Do
          query=''  /* avoid endless retries */
          Call PopUp 'Article contained NO usable references.',1,'X'
        End
    End  /*  pick-article loop  */

    If cluster=0 Then Leave  /* don't keep going back to search setup */
  End  /*  pick-group loop  */
End  /*  pick-cluster loop  */

Exit  /* paranoia */



/***ROUTINES:*****************************************************************/

/*------Posting Routine:-----------------------------------------------------*/
PostIt:
Procedure Expose (global) (poststuff)
Parse Arg aserial,mode
ec=0  /* assume the worst (0=fail, 1=ok) */
If mode='P' & groupname='SEARCH' Then Call PopUp 'Cannot originate articles from Search.',7,'X'
If mode='P' & groupname='SEARCH' Then Return ec
If email='nemo@nowhere.org' Then 
  Do
    temp=W_Open(9,1,9,80,79)
    Call W_Border temp
    Call W_ScrWrite temp,2,2,Center('Ahoy, Captain Nemo!  Before you can post from this program',78)
    Call W_ScrWrite temp,3,2,Center('you need to set at the least your true e-mail address in the',78)
    Call W_ScrWrite temp,4,2,Center('configuration file (DNREAD.CNF).  You will likely also want to',78)
    Call W_ScrWrite temp,5,2,Center('set there correct values for your name and for any organization.',78)
    Call W_ScrWrite temp,6,2,Center('And, to avoid embarrassment, you should customize the sig file',78)
    Call W_ScrWrite temp,7,2,Center('(DNREAD.SIG), lest your readers think you a bloodthirsty pirate.',78)
    Call W_ScrWrite temp,8,2,Center('(Press any key to continue.)',78)
    If boops Then Call Sound 300,.3
    Call InKey
    Call W_Close temp
    Call CursorType ,,0
  End
If email='nemo@nowhere.org' Then Return ec
Call ScrWrite 1,1,Center('Posting message via 'poster' . . . ',80),,,31
If mode='R' Then
  Do
    /*  Get info on message to be replied to.  */
    Call FileRead loadsdir'H'aserial'.TXT','oldhead.'
    newsgroups='?'
    subject='?'
    messageid='?'
    messagedate='?'
    author='?'
    Do line=1 To oldhead.0
      If Pos('Newsgroups:',oldhead.line)>0 Then newsgroups=LineValue(oldhead.line)
      If Pos('Subject:',oldhead.line)>0 Then subject=LineValue(oldhead.line)
      If Pos('Message-',oldhead.line)>0 Then messageid=LineValue(oldhead.line)
      If Pos('Date:',oldhead.line)>0 Then messagedate=LineValue(oldhead.line)
      If Pos('From:',oldhead.line)>0 Then author=LineValue(oldhead.line)
    End    
    /*  Create new article from old.  */
    Call ScrWrite 25,1,Center('Creating reply . . . ',80),,,31
    Call FileRead loadsdir'A'aserial'.TXT','oldmsg.'
    dummy.0=7+oldmsg.0
    dummy.1='On 'messagedate', in message 'messageid','
    dummy.2=author' wrote:'
    dummy.3=Copies('-',70)
    Do line=1 To oldmsg.0
      my=3+line
      dummy.my=quoter||oldmsg.line
    End
    my=(dummy.0)-3
    dummy.my=Copies('=',70)
    my=my+1
    dummy.my=intro
    my=my+1
    dummy.my=''
    my=my+1
    dummy.my=''
    Drop oldmsg.
    Call FileWrite loadsdir'TOSEND.TXT','dummy.'
    Drop dummy.
    editor loadsdir'TOSEND.TXT'
    Call ScrWrite 25,1,Center('Reply ready.',80),,,31
    If PopUp('Send the article?',5)='N' Then Return 1
    /*  Attach Header  */
    Call FileRead loadsdir'TOSEND.TXT','text.'
    If Upper(Left(subject,4))<>'RE: ' Then subject='Re: 'subject
    mymessage.0=8
    mymessage.1='From: 'myname' <'email'>'
    mymessage.2='Date: 'Left(Date('Weekday'),3)', 'Date('Normal')' 'Time()' PST'
    mymessage.3='Newsgroups: 'Lower(newsgroups)
    mymessage.4='Subject: 'subject
    mymessage.5='References: 'messageid
    mymessage.6='Organization: 'myorg
    mymessage.7='Lines: '4+text.0
    mymessage.8=''
  End
 Else
  Do 1  /* Makes loop Leave-able */
    /*  Create new article.  */
    Call ScrWrite 25,1,Center('Creating new message . . . ',80),,,31
    temp=W_Open(2,1,23,80,8)
    Call W_Border temp
    Call W_ScrWrite temp,10,2,Center('Enter below a SUBJECT heading for this article:',78)
    subject=W_Get(temp,12,6,65)
    Call W_Close temp
    Call CursorType ,,0
    If Strip(subject)='' Then Leave
    dummy.0=3
    dummy.1=subject':'
    dummy.2=Copies('-',70)
    dummy.3=''
    Call FileWrite loadsdir'TOSEND.TXT','dummy.'
    Drop dummy.
    editor loadsdir'TOSEND.TXT'
    Call ScrWrite 25,1,Center('New message ready.',80),,,31
    If PopUp('Send the article?',5)='N' Then Return 1
    /*  Attach Header  */
    Call FileRead loadsdir'TOSEND.TXT','text.'
    mymessage.0=7
    mymessage.1='From: 'myname' <'email'>'
    mymessage.2='Date: 'Left(Date('Weekday'),3)', 'Date('Normal')' 'Time()' PST'
    mymessage.3='Newsgroups: 'Lower(groupname)
    mymessage.4='Subject: 'subject
    mymessage.5='Organization: 'myorg
    mymessage.6='Lines: '4+text.0
    mymessage.7=''
  End
If Strip(subject)='' Then Return ec
Call ArrayInsert 'text.','mymessage.'
Drop text.    
/*  Attach Sig.  */
Call FileRead 'DNREAD.SIG','dummy.'
If dummy.0=0 Then
  Do
    dummy.0=4
    dummy.1=''
    dummy.2=Copies(':',70)
    dummy.3=myname
    dummy.4=myorg
  End
Do While dummy.0<4
  top=1+dummy.0
  dummy.top=''
  dummy.0=top
End
Call ArrayInsert 'dummy.','mymessage.'
Drop dummy.
/*  Connect to server for a socket.  */
Call ScrWrite 25,1,Center('Connecting . . . ',80),,,31
socket=SockSocket("AF_INET","SOCK_STREAM",0)
If socket=-1 Then
  Do
    If boops Then Call Sound 300,.3
    Call ScrWrite 25,1,Center('Error opening socket!  (Press any key to continue.)',80),,,79
    Call InKey
  End
If socket=-1 Then Return 0
/*  Log on to the socket.  */
Call ScrWrite 25,1,Center('Logging on . . . ',80),,,31
server.!family='AF_INET'  /* mandatory  */
server.!port=119  /*  standard news port  */
server.!addr=postserver  /* as obtained earlier  */
got=SockConnect(socket,'server.!')
If got=-1 Then
  Do
    If boops Then Call Sound 300,.3
    Call ScrWrite 25,1,Center('Error logging on to socket!  (Press any key to continue.)',80),,,79
    Call InKey
  End
If got=-1 Then Return 0
/*  Get server's initial response.  */
got=GetALine(socket)
Parse Var got code meaning
ok=0
Select
  When code='200' Then ok=1
  When code='201' Then Call PopUp poster' does not allow posting.',4,'X'
  When code='400' Then Call PopUp poster' broke contact ('meaning').',4,'X'
  Otherwise Call PopUp poster': 'meaning'--cannot continue',4,'X'
End
If \ok Then got=GoodBye(socket)
If \ok Then Return 0
/*  Test for needed authentication.  */
Call ScrWrite 25,1,Center('Initiating post . . . ',80),,,31
Call SendLine 'POST',socket
got=GetALine(socket)
Parse Var got code meaning
ok=1
If code='480' Then
  Do
    Call ScrWrite 25,1,Center('Authenticating with server . . . ',80),,,31
    Call SendLine 'authinfo user 'username,socket
    got=GetALine(socket)
    Parse Var got code meaning
    If code='381' Then
      Do
        Call SendLine 'authinfo pass 'password,socket
        got=GetALine(socket)
        Parse Var got code meaning
      End
    Select
      When code='281' Then 
        Do
          Call ScrWrite 25,1,Center('Authentication complete; stand by. ',80),,,31
          Call SendLine 'POST',socket
          got=GetALine(socket)
          Parse Var got code meaning
        End
      When code='482' Then 
        Do
          Call PopUp 'Authentication rejected!--exiting.',4,'X'
          ok=0
        End
      When code='502' Then 
        Do
          Call PopUp 'No permission on 'poster'--exiting.',4,'X'
          ok=0
        End
      Otherwise
        Do
          Call PopUp 'Unexpected response ('meaning')--exiting.',4,'X'
          ok=0
        End
    End
  End  /* authentication requested  */
If \ok Then got=GoodBye(socket)
If \ok Then Return 0
If code<>'340' Then Call PopUp 'Will be unable to post--exiting.',4,'X'
If code<>'340' Then Return 0
/*  Actually send message.  */
Do line=1 To mymessage.0
  If Left(mymessage.line,1)='.' Then tosend='.'||mymessage.line
   Else tosend=mymessage.line
  Call SendLine tosend,socket
  Call ScrWrite 25,1,Center('Sending line 'line' of 'mymessage.0' . . . ',80),,,31
End
Call SendLine '.',socket  /* end-of-message marker */
/*  Check response to send.  */
Call ScrWrite 25,1,Center('Awaiting confirmation . . . ',80),,,31
got=GetALine(socket)
Parse Var got code meaning
ok=1
If boops Then Call Sound 1500,.1
Select 
  When code='240' Then 
    Do
      ec=1
      Call PopUp 'Message posted OK.',2,'X'
    End
  When code='440' Then Call ScrWrite 1,1,Center('Posting disallowed! (code 'meaning')',80),,,79
  Otherwise 
    Do
      Call FileWrite loadsdir||'BadSend.Txt','mymessage.'
      Call ScrWrite 1,1,Center('Posting failed!  ('code')',80),,,79
      Call ScrWrite 25,1,Center('Press any key to continue.',80),,,79
      temp=W_Open(12,1,3,80,79)
      Call W_ScrWrite temp,2,1,meaning
      Call InKey
      Call W_Close temp
      Call CursorType ,,0
    End
End
Call ScrWrite 25,1,Center('Logging off 'poster' . . . ',80),,,31
/*  Exit civilly.  */
got=GoodBye(socket)
Return ec


/*------Major Routines:------------------------------------------------------*/

Clusters:
/*  Select an interest-cluster from extant file collection  */
Procedure Expose (global) (scancodes) (colors) clusterbase gnames.
If boops Then Call Sound 900,.1
Call ScrWrite 1,1,Center('Interest-Cluster Selection Screen:',80),,,31
Call ScrWrite 25,1,Center('Select an interest cluster by indicator letter (<Esc> quits).',80),,,31
Call ArrayCopy 'gnames.','choices.'
choicebase=clusterbase
Do Until cluster>0
  help=1
  cluster=GetChoice(' ',clustercolor)
  help=0
  If cluster=0 Then
    Do
      If PopUp('Do you really want to exit this program?',4)='Y' Then ,
         Call ItQuits 'Normal exit.',0
    End
End
choice=cluster-1  /* 1 is lowest return from GetChoice */
clusterbase=choicebase
Call ScrClear
Return choice

     
GroupNames:
Procedure Expose (global) (colors) groupbase lookback (scancodes) lists.
Parse Arg cluster
Call FileRead lists.cluster,'grouplist.'
If boops Then Call Sound 700,.1
Call ScrWrite 1,1,Center('Specific-NewsGroup Selection Screen,'grouplist.1' Interest Cluster:',80),,,31
Call ScrWrite 25,1,Center('Select a group by indicator letter (<Esc> quits).',80),,,31
Call ArrayCopy 'grouplist.','choices.',2  /*  leave title line out of choices cv  */
choicebase=groupbase
help=2
pick=GetChoice('',groupcolor)
help=0
index=pick+1  /* cv choice is 1 off from cv grouplist (title line) */
If pick>0 Then groupname=grouplist.index
 Else groupname=''
groupbase=choicebase
Call ScrClear
Return groupname


MakeQuery:
Procedure Expose (global) loadsdir block.
Parse Arg query,serveraddr,serial,type
Select
  When type='G' & serial=-1 Then Call ScrWrite 1,1,Center('Getting requested Search . . . ',80),,,31
  When type='G' Then Call ScrWrite 1,1,Center('Getting requested Group . . . ',80),,,31
  When type='S' Then Call ScrWrite 1,1,Center('Getting requested list . . . ',80),,,31
  Otherwise Call ScrWrite 1,1,Center('Getting requested Article . . . ',80),,,31
End
/*  Connect to server for a socket.  */
Call ScrWrite 25,1,Center('Connecting . . . ',80),,,31
socket=SockSocket("AF_INET","SOCK_STREAM",0)
If socket=-1 Then
   Do
     If boops Then Call Sound 300,.3
     Call ScrWrite 25,1,Center('Error opening socket!  (Press any key to continue.)',80),,,79
     Call InKey
   End
If socket=-1 Then Return -1
/*  Log on to the socket.  */
Call ScrWrite 25,1,Center('Logging on to socket 'socket' . . . ',80),,,31
server.!family='AF_INET'  /* mandatory  */
server.!port=80  /*  standard HTTP port  */
server.!addr=serveraddr  /* as obtained earlier  */
got=SockConnect(socket,'server.!')
If got=-1 Then
   Do
     If boops Then Call Sound 300,.3
     Call ScrWrite 25,1,Center('Error logging on to socket!  (Press any key to continue.)',80),,,79
     Call InKey
   End
If got=-1 Then Return -1
/*  Send actual service request.  */
Call ScrClear 7,' ',2,1,23,80
Call ScrWrite 25,1,Center('Sending request . . . ',80),,,31
cut=Pos('?',query)
target=Left(query,cut-1)
query=SubStr(query,cut+1)
Call SendLine 'POST 'target' HTTP/1.0',socket
Call SendLine 'Accept: *'||'/'||'*; q=0.300',socket
Call SendLine 'Accept: application/octet-stream; q=0.100',socket
Call SendLine 'Accept: text/plain',socket
Call SendLine 'Accept: text/html',socket
Call SendLine 'User-Agent: IBM-RxSock-DLL/v1.1',socket
Call SendLine 'Content-type: application/x-www-form-urlencoded',socket
qline='Content-length: 'Length(query)
Call SendLine qline,socket
Call SendLine '',socket
Call SendLine query,socket
Call ScrWrite 25,1,Center('Request sent . . . ',80),,,31
buffer=''
Call Time('R')
Do Until buffer<>'' & data=''
  If Time('E')>120 Then Leave
  rc=SockRecv(socket,'data',8000)
  If buffer='' Then Call ScrWrite 25,1,Center('Receiving reply . . . ',80),,,31
  buffer=buffer||data
  If data<>'' Then Call Time('R')
  Call ScrWrite 13,1,Center(Length(buffer)' bytes received . . . ',80),,,14
End
/*  Close socket before proceeding.  */
got=SockSoClose(socket)
If got=-1 Then Call ItQuits 'Error closing socket.',-7
/*  Process response, if any.  */
If buffer<>'' Then
  Do
    ok=serial+1
    dummy.0=1
    dummy.1=buffer
    Call ScrWrite 25,1,Center('Reply received; parsing/saving . . . ',80),,,31
    Call FileWrite loadsdir||type||ok'.HTM','dummy.'
    Call ScrWrite 25,1,Center('Reply complete; stand by for list display . . . ',80),,,31
  End
 Else 
   Do
     ok=-1
     Call PopUp 'Error receiving response.',6,'X'
   End
Return ok

PickArticle:
Procedure Expose (global) (scancodes) (poststuff) (colors) artibase queryserver gserial hrefs. hits. block.
Parse Arg tosee
localblock=0
Do Forever
  /*  Extract hits/hrefs and pointers from raw file.  */
  Call FileRead loadsdir'G'tosee'.'localblock,'artlist.'  /* get raw html articles list */
  hits.0=0
  hrefs.0=0
  art=0
  inset=-1
  nextblock=''
  range=''
  full='(all)'
  Do line=1 to artlist.0
    If Pos('<UL>',artlist.line)>0 Then inset=inset+1
    If Pos('</UL>',artlist.line)>0 Then inset=inset-1
    If Pos('<LI>',artlist.line)>0 Then
      Do
        art=art+1
        hits.art=Copies(' ',3*inset)||DeHtml(artlist.line)
        hrefs.art=GetPointer(artlist.line)
      End
    If Pos('">Get next ',artlist.line)>0 & Pos('<A HREF="http://',artlist.line)>0 Then
      Do
        startat=LastPos('<A HREF="http://',artlist.line)  /* get past "previous xxx" */
        cutout=SubStr(artlist.line,startat)
        nextblock=GetPointer(cutout)
      End
    If Pos('<FONT SIZE=+1>Reading <B></B> from <BR></FONT>Matches <B>',artlist.line)>0 Then
/*
<FONT SIZE=+1>Reading <B></B> from <BR></FONT>Matches <B>1-100</B> of 152
*/
      Do
        start=3+LastPos('<B>',artlist.line)
        cut=Pos('<',artlist.line,start)
        range=SubStr(artlist.line,start,cut-start)
        cut=1+LastPos('>',artlist.line)
        full=SubStr(artlist.line,cut)
        dash=Pos('-',range)
        low=(Format(Left(range,dash-1)))-1
        high=Format(SubStr(range,dash+1))
        thisload=high-low
      End
    If Pos('<FONT SIZE=+1>Reading <B></B> from <BR></FONT><B>',artlist.line)>0 Then
/*
<FONT SIZE=+1>Reading <B></B> from <BR></FONT><B>85</B> Matches
*/
      Do
        start=3+LastPos('<B>',artlist.line)
        cut=Pos('<',artlist.line,start)
        range='1-'||SubStr(artlist.line,start,cut-start)||' '
      End
  End
  Call ScrWrite 1,1,Center('Current Articles 'range||full', 'groupname':',80),,,31
  hits.0=art
  hrefs.0=art
  help=3
  Do Forever
    toread=GetPickFromList(artpick1,artpick2)
    If (toread<>'+' & toread<>'-') | ,
       (toread='-' & localblock>0) | ,
       (toread='+' & nextblock<>'') Then Leave
    If boops Then
      Do
        Call Sound 40,.5
      End
  End
  If toread<>'+' & toread<>'-' Then Leave
  Call ScrClear 7,' ',2,1,23,80
  artibase=0
  If toread='+' Then
    Do
      localblock=localblock+1
      If localblock>(block.gserial) Then  /* need to load it */
        Do
          Call ScrWrite 25,1,Center('Sending next-block request . . . ',80),,,31
          newgserial=MakeQuery(nextblock,queryserver,gserial-1,'G')
          If newgserial=gserial Then 
            Do              
              block.gserial=1+block.gserial
              Call DosReName loadsdir'G'gserial'.HTM',loadsdir'G'gserial'.'localblock
            End
           Else localblock=localblock-1  /* failed so back off */
        End
    End
   Else localblock=localblock-1  /* must be "-" */
End
help=0
Return toread


PickHit:
Procedure Expose (global) (scancodes) (colors) loadsdir artibase queryserver
Call ScrWrite 1,1,Center('Articles found by Search:',80),,,31
localblock=0
topblock=0
Do Forever
  /*  Extract hits/hrefs and pointers from raw file.  */
  Call DosReName loadsdir'G0.HTM',loadsdir'G0.'localblock
  Call FileRead loadsdir'G0.'localblock,'artlist.'  /* get raw html articles list */
  hits.0=0
  hrefs.0=0
  art=0
  nextblock=''
  Do line=1 to artlist.0
    If Pos('.',Left(artlist.line,6))>0 & Pos('<A HREF="http://',artlist.line)>0 Then
      Do
        art=art+1
        hits.art=SubStr(DeHtml(artlist.line),18)
        hrefs.art=GetPointer(artlist.line)
      End
    If Pos('">Get next ',artlist.line)>0 & Pos('<A HREF="http://',artlist.line)>0 Then
      Do
        nextblock=GetPointer(artlist.line)
      End
    If Pos('Matches <B>',artlist.line)>0 Then
/*
Matches <B>101-200</B> of <B>424</B> for Query: 
*/
      Do
        cut=Pos('<',artlist.line,12)
        range=SubStr(artlist.line,12,cut-12)
        start=3+LastPos('<B>',artlist.line)
        cut=Pos('<',artlist.line,start)
        full=SubStr(artlist.line,start,cut-start)
      End
  End
  thisload=art
  upto=localblock*100
  Call ScrWrite 1,1,Center('Found Articles 'range' (of 'full'):',80),,,31
  hits.0=art
  hrefs.0=art
  help=4
  Do Forever
    toread=GetPickFromList(hitpick,hitpick)
    If (toread<>'+' & toread<>'-') | ,
       (toread='-' & localblock>0) | ,
       (toread='+' & nextblock<>'') Then Leave
    If boops Then
      Do
        Call Sound 40,.5
      End
  End
  If toread='' | (toread<>'+' & toread<>'-') Then Leave
  Call ScrClear 7,' ',2,1,23,80
  artibase=0
  If toread='+' Then
    Do
      localblock=localblock+1
      If localblock>topblock Then
        Do
          Call ScrWrite 25,1,Center('Sending next-block request . . . ',80),,,31
          If MakeQuery(nextblock,queryserver,-1,'G')=0 Then topblock=1+topblock
           Else localblock=localblock-1
        End
    End
   Else localblock=localblock-1
End
help=0
Return toread


PickSpecial:
Procedure Expose (global) (scancodes) (colors) loadsdir artibase queryserver hrefs. hits.
Call ScrWrite 1,1,Center('Articles in list:',80),,,31
localblock=0
topblock=0
Do Forever
  /*  Extract hits/hrefs and pointers from raw file.  */
  Call DosReName loadsdir'S0.HTM',loadsdir'S0.'localblock
  Call FileRead loadsdir'S0.'localblock,'artlist.'  /* get raw html articles list */
  hits.0=0
  hrefs.0=0
  art=0
  inset=-1
  nextblock=''
  Do line=1 to artlist.0
    If Pos('<UL>',artlist.line)>0 Then inset=inset+1
    If Pos('</UL>',artlist.line)>0 Then inset=inset-1
    If Pos('<LI>',artlist.line)>0 Then
      Do
        art=art+1
        hits.art=Copies(' ',3*inset)||DeHtml(artlist.line)
        hrefs.art=GetPointer(artlist.line)
      End
    If Pos('">Get next ',artlist.line)>0 & Pos('<A HREF="http://',artlist.line)>0 Then
      Do
        nextblock=GetPointer(artlist.line)
      End
  End
  thisload=art
  upto=localblock*100
  Call ScrWrite 1,1,Center('List Articles '1+upto'-'thisload+upto':',80),,,31
  hits.0=art
  hrefs.0=art
  help=5
  Do Forever
    toread=GetPickFromList(specpick,specpick)
    If (toread<>'+' & toread<>'-') | ,
       (toread='-' & localblock>0) | ,
       (toread='+' & nextblock<>'') Then Leave
    If boops Then
      Do
        Call Sound 40,.5
      End
  End
  If toread='' | (toread<>'+' & toread<>'-') Then Leave
  Call ScrClear 7,' ',2,1,23,80
  artibase=0
  If toread='+' Then
    Do
      localblock=localblock+1
      If localblock>topblock Then
        Do
          Call ScrWrite 25,1,Center('Sending next-block request . . . ',80),,,31
          If MakeQuery(nextblock,queryserver,-1,'S')=0 Then topblock=1+topblock
           Else localblock=localblock-1
        End
    End
   Else localblock=localblock-1
End
help=0
Return toread


ReadArticle:
Procedure Expose (global) loadsdir pointers.
Parse Arg aserial
Call FileRead loadsdir'A'aserial'.HTM','text.'
Call ScrWrite 25,1,Center('Converting 'text.0' HTML lines to straight text . . . ',80),,,31
Do ptr=1 To 5
  pointers.ptr=''
End
header.0=0
h=0
Do line=1 To text.0
  If Pos('[Next]',text.line)>0 Then pointers.!nextup=GetPointer(text.line)
  If Pos('[Previous]',text.line)>0 Then pointers.!oneback=GetPointer(text.line)
  If Pos('[Current Results]',text.line)>0 Then pointers.!hitlist=GetPointer(text.line)
  If Pos('[Get Thread]',text.line)>0 Then pointers.!thread=GetPointer(text.line)
  If Pos('[Author Profile]',text.line)>0 Then pointers.!author=GetPointer(text.line)
  If Pos('<HR><H3>',text.line)>0 Then Leave
End
dummy=line+1
/*  Now in first Header line  */
Do line=dummy To text.0
  If Strip(text.line)='</B>' | Pos('[More Headers]',text.line)>0 Then Leave
  h=h+1
  header.h=DeHtml(text.line)
End
header.0=h
dummy=line
If h>0 Then Call FileWrite loadsdir'H'aserial'.TXT','header.'
If Pos('[More Headers]',text.line)>0 Then 
  Do
    If Strip(text.line)='</B>' Then Leave
    dummy=dummy+1
  End
/*  Now in first Article line  */
article.0=0
a=0
Do line=dummy To text.0
  If Pos('</PRE>',text.line)>0 Then Leave
  a=a+1
  article.a=DeHtml(text.line)
End
article.0=a
If a>0 Then Call FileWrite loadsdir'A'aserial'.TXT','article.'
Return a


ViewArticle:
Procedure Expose (global) (scancodes) (artstuff) (poststuff) (colors) pointers.
Parse Arg aserial
Call FileRead loadsdir'A'aserial'.TXT','text.'
Call ScrWrite 1,1,Center('Article text:',80),,,31
answer=''
count=text.0
baseline=0
inset=0
done=0
temp=W_Open(2,1,23,80,artcolor)
help=6
Do Until done
  /*  Display 23-line window of text.  */
  top=baseline+23
  If top>count Then top=count
  Call ScrWrite 25,1,Center('Lines 'baseline+1' to 'top' of article.',80),,,31
  maxlength=0
  Do row=1 To top
    index=row+baseline
    Call W_ScrWrite temp,row,1,SubStr(text.index,1+inset,80)
    If Length(text.index)>maxlength Then maxlength=Length(text.index)
  End
  /*  Get a valid keypress.  */
  ok=0
  Do Until ok | done
    pressed=InKey()
    If Length(pressed)=1 Then 
      Do
        scancode=''
        If pressed=escape Then done=1
         Else 
          Do
            If boops Then Call Sound 40,.5
          End
      End
     Else 
      Do
        scancode=Right(pressed,1)
        pressed=''
        Select
          When scancode=pgup Then
            Do
              ok=1
              If baseline=0 Then 
                Do
                  If boops Then Call Sound 200,.1
                End
               Else baseline=baseline-23
            End
          When scancode=pgdn Then
            Do
              ok=1
              If baseline>=(count-23) Then 
                Do
                  If boops Then Call Sound 1300,.1
                End
               Else 
                Do
                  baseline=baseline+23
                  If (baseline+24)>count Then baseline=count-23
                End
            End
          When scancode=homekey Then 
            Do
              ok=1
              If baseline=0 Then 
                Do
                  If boops Then Call Sound 200,.1
                End
               Else baseline=0
            End
          When scancode=endkey Then 
            Do
              ok=1
              If baseline=count-23 Then 
                Do
                  If boops Then Call Sound 1300,.1
                End
               Else baseline=count-23
            End
          When scancode=leftkey Then
            Do
              ok=1
              If inset=0 Then 
                Do
                  If boops Then Call Sound 200,.1
                End
               Else inset=inset-10
            End
          When scancode=rightkey Then
            Do
              ok=1
              If inset>=(maxlength-80) Then 
                Do
                  If boops Then Call Sound 1300,.1
                End
               Else 
                Do
                  inset=inset+10
                  If (inset+80)>maxlength Then inset=maxlength-80
                End
            End
          When scancode=helpf1 Then 
            Do
              Call ShowHelp
            End
/*::::::::Special-call keys:::::::::::::::::::::::::::::::::::::::::::*/
          When scancode=D2C(31) Then  /* Alt-S save */
            Do
              ok=1
              Call SaveIt aserial
            End
          When scancode=D2C(19) Then  /* Alt-R reply */
            Do
              ok=1
              Call PostIt aserial,'R'
            End
          When scancode=D2C(20) Then  /* Alt-T thread */
            Do
              If pointers.!thread<>'' Then
                Do
                  done=1
                  If groupnumber<>0 Then 
                    Do
                      wason=groupnumber
                      oldbase=artibase
                    End
                  groupnumber=0
                  artibase=0
                  answer=''
                  Call KillAll 'S0.*'  /* delete all old list files */
                  Call MakeQuery pointers.!thread,queryserver,-1,'S'
                End
               Else 
                 Do
                   If boops Then Call Sound 40,.5
                 End
            End
          When scancode=D2C(25) Then  /* Alt-P post new */
            Do
              ok=1
              Call PostIt aserial,'P'
            End
          When scancode=D2C(30) Then  /* Alt-A author info */
            Do
              If pointers.!author<>'' Then
                Do
                  ok=1
                  Call Profile pointers.!author
                End
               Else 
                 Do
                   If boops Then Call Sound 40,.5
                 End
            End
          When scancode=D2C(33) Then  /* Alt-F forward */
            Do
              If pointers.!nextup<>'' Then
                Do
                  done=1
                  answer=pointers.!nextup
                End
               Else 
                 Do
                   If boops Then Call Sound 40,.5
                 End
            End
          When scancode=D2C(35) Then  /* Alt-H header */
            Do
              ok=1
              Call ShowHeader(aserial)
            End
          When scancode=D2C(38) Then  /* Alt-L list of hits */
            Do
NOP
/*
              If pointers.!hitlist<>'' Then
                Do
                  done=1
                  If groupnumber<>0 Then 
                    Do
                      wason=groupnumber
                      oldbase=artibase
                    End
                  groupnumber=0
                  artibase=0
                  answer=''
                  Call MakeQuery pointers.!hitlist,queryserver,-1,'S'
                End
               Else 
                 Do
                   If boops Then Call Sound 40,.5
                 End
*/
            End
          When scancode=D2C(48) Then  /* Alt-B back */
            Do
              If pointers.!oneback<>'' Then
                Do
                  done=1
                  answer=pointers.!oneback
                End
               Else 
                 Do
                   If boops Then Call Sound 40,.5
                 End
            End
          Otherwise 
            Do
              If boops Then Call Sound 40,.5
            End
        End  /* Select on scancode */
      If baseline<0 Then baseline=0
      If inset<0 Then inset=0
      End  /* scankey pressed */
  End  /* get & process keypress */
  If \ok & \done Then 
    Do
      If boops Then Call Sound 40,.5
    End
End
help=0
Call W_Close temp
Call CursorType ,,0
Call ScrWrite 13,1,Center('Rebuilding article list . . .',80)
Return answer


PowerSearch:
Procedure Expose (global) (criteria) queryserver loadsdir
Call ScrWrite 1,1,Center('Power Search:',80),,,31
If SearchSet() Then Return 0
Call ScrClear 7,' ',2,1,23,80
Call ScrWrite 25,1,Center('Enter the search-target word or words then press <Enter> (or <Esc> to abort).',80),,,31
Call ScrWrite  3,1,Center('In the entry box below, type in as many words as you want the system to look',80),,,14
Call ScrWrite  4,1,Center('for; case is completely immaterial.  If you just type in words, Deja News',80),,,14
Call ScrWrite  5,1,Center('will assume that you want *all* of them to be in each article found (an AND',80),,,14
Call ScrWrite  6,1,Center('search).  You can modify that behavior by using these special characters.',80),,,14
Call ScrWrite  8,1,' Search words can be separated by the following connectors:',80,,32
Call ScrWrite  9,1,' ',80,,32
Call ScrWrite 10,1,Center(' & meaning AND      | meaning OR      &! meaning AND NOT      ^ meaning "NEAR"',80),,,32
Call ScrWrite 13,1,' Search words can be combined or modified by the following symbols:',80,,48
Call ScrWrite 14,1,' ',80,,48
Call ScrWrite 15,1,Center(' "..." - Quote Marks   * ? - Wildcards   (...) - Parentheses   {...} - Braces',80),,,48
Call ScrWrite 18,1,' Search words can be preceded by the following context indicators:',80,,80
Call ScrWrite 19,1,' ',80,,80
Call ScrWrite 20,1,Center(' ~a = Author    ~s = Subject    ~g = Newsgroup    ~dc = Date of Creation',80),,,80
temp=W_Open(23,1,1,80,7)
raw=Upper(W_Get(temp,1,19,42,,112))
Call W_Close temp
Call CursorType ,,0
If raw='' Then Return 0
Call KillAll 'G0.*'
entry=''
Do byte=1 To Length(raw)
  test=SubStr(raw,byte,1)
  Select
    When test=' ' Then use='+'
    When test='&' Then use='%26'
    When test='|' Then use='%7C'
    When test='!' Then use='%21'
    When test='^' Then use='%5E'
    When test='"' Then use='%22'
    When test='?' Then use='%3F'
    When test='(' Then use='%28'
    When test=')' Then use='%29'
    When test='{' Then use='%7B'
    When test='}' Then use='%7D'
    When test='~' Then use='%7E'
    Otherwise use=test
  End
  entry=entry||use
End
query='/dnquery.xp?'||,
      'query='entry||,
      '&defaultOp=AND'||,
      '&svcclass='svcclass||,
      '&maxhits='msgmax||,
      '&format=terse'||,
      '&threaded=0'||,
      '&showsort='showsort||,
      '&agesign='agesign||,
      '&ageweight='ageweight
artlist=MakeQuery(query,queryserver,-1,'G')
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
MakeQuery gets the server's response and saves it in a
file named Gserial.HTM, updating GSERIAL as it does so;
it returns the updated GSERIAL or, for any failure, -1.
Here, the initial Gserial is forced to -1, yielding
a disk file of G0.HTM for all successes.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
If artlist<0 Then 
  Do
    success=0
    Call PopUp 'Search failed somehow.',5,'X'
  End
 Else success=1
Return success


SearchSet:
Procedure Expose (global) (criteria)
Call ScrClear 7,' ',2,1,23,80
Call ScrWrite 25,1,Center('Set up the search criteria, or press <Esc> to abort the search.',80),,,31
svcclass='dncurrent'
ageweight='1'
agesign='1'
showsort='score'
Call ScrWrite 4,1,Center('You can search in the current-articles database (the last 7 weeks or so)',80),,,14
Call ScrWrite 5,1,Center('or you can search in the archival database--all prior to current--which',80),,,14
Call ScrWrite 6,1,Center('for now goes back to early 1995; you cannot search both at one pass.  The',80),,,14
Call ScrWrite 7,1,Center('default is to search the current database; to accept that, press the <Enter>',80),,,14
Call ScrWrite 8,1,Center('key; to set the search for the archival database, press the letter "A" key.',80),,,14
Do Until pressed=escape | pressed='A' | pressed=cr
  pressed=Upper(InKey())
  If (pressed<>escape & pressed<>'A' & pressed<>cr) & boops Then Call Sound 40,.5
End
If pressed=escape Then Return 1
If pressed='A' Then 
  Do
    svcclass='dnold'
    Call ScrWrite 11,1,Center('Will search in ARCHIVAL articles database.',80),,,15
  End
 Else Call ScrWrite 11,1,Center('Will search in CURRENT articles database.',80),,,15
Call ScrWrite 4,1,Center('You can set the significance of article age in "scoring" hits to one of',80),,,14
Call ScrWrite 5,1,Center('three values: None, Some, or Great; the default is Some significance.',80),,,14
Call ScrWrite 6,1,Center('(This matters not unless you select sort hits by score later on this page.)',80),,,14
Call ScrWrite 7,1,Center('Press the <Enter> key to accept the default, or press the letter key',80),,,14
Call ScrWrite 8,1,Center('"N" for No significance of the letter key "G" for Great significance.',80),,,14
Do Until pressed=escape | pressed='G' | pressed='N' | pressed=cr
  pressed=Upper(InKey())
  If (pressed<>escape & pressed<>'N' & pressed<>'G' & pressed<>cr) & boops Then Call Sound 40,.5
End
If pressed=escape Then Return 1
Select
  When pressed='G' Then 
    Do
      ageweight='3'
      Call ScrWrite 14,1,Center('Article age will have GREAT scoring significance.',80),,,15
    End
  When pressed='N' Then 
    Do
      ageweight='0'
      Call ScrWrite 14,1,Center('Article age will have NO scoring significance.',80),,,15
    End
  Otherwise Call ScrWrite 14,1,Center('Article age will have SOME scoring significance.',80),,,15
End
Call ScrWrite 4,1,Center('Besides giving relative weight to article age, you can decide if that weight',80),,,14
Call ScrWrite 5,1,Center('will be positive or negative--that is, whether an article will be scored',80),,,14
Call ScrWrite 6,1,Center('higher if it is older, or lower if it is older.  The default is to score',80),,,14
Call ScrWrite 7,1,Center('newer articles more highly than older articles.  To accept that default,',80),,,14
Call ScrWrite 8,1,Center('press the <Enter> key; for Reverse age scoring, press the letter "R" key.',80),,,14
Do Until pressed=escape | pressed='R' | pressed=cr
  pressed=Upper(InKey())
  If (pressed<>escape & pressed<>'R' & pressed<>cr) & boops Then Call Sound 40,.5
End
If pressed=escape Then Return 1
If pressed='R' Then 
    Do
      agesign='-1'
      Call ScrWrite 17,1,Center('The older an article, the MORE highly it will be scored.',80),,,15
    End
 Else Call ScrWrite 17,1,Center('The older an article, the LESS highly it will be scored.',80),,,15
Call ScrWrite 4,1,Center('By default, found articles are listed by a "score" DN assigns in searching;',80),,,14
Call ScrWrite 5,1,Center('they can instead be listed by newsgroup, date, author, or topic (subject).',80),,,14
Call ScrWrite 6,1,Center('To accept score listing, just press the <Enter> key; otherwise, press the',80),,,14
Call ScrWrite 7,1,Center('appropriate letter key: "G" for by-group listing, "D" for by-date listing,',80),,,14
Call ScrWrite 8,1,Center('"A" for by-author listing, or "T" for by-topic (subject) listing.',80),,,14
Do Until pressed=escape | pressed='G' | pressed='D' | pressed='A' | pressed='T' | pressed=cr
  pressed=Upper(InKey())
  If (pressed<>escape & pressed<>'G' & pressed<>'D' & pressed<>'A' & pressed<>'T' & ,
      pressed<>cr) & boops Then Call Sound 40,.5
End
If pressed=escape Then Return 1
Select
  When pressed='G' Then 
    Do
      ageweight='group'
      Call ScrWrite 20,1,Center('Listings will be ordered by article NEWSGROUP.',80),,,15
    End
  When pressed='D' Then 
    Do
      ageweight='date'
      Call ScrWrite 20,1,Center('Listings will be ordered by article DATE.',80),,,15
    End
  When pressed='A' Then 
    Do
      ageweight='author'
      Call ScrWrite 20,1,Center('Listings will be ordered by article AUTHOR.',80),,,15
    End
  When pressed='T' Then 
    Do
      ageweight='subject'
      Call ScrWrite 20,1,Center('Listings will be ordered by article SUBJECT.',80),,,15
    End
  Otherwise Call ScrWrite 20,1,Center('Listings will be ordered by article SCORE.',80),,,15
End
Call Delay 1
Return 0


/*------Lesser Routines:----------------------------------*/

GetPickFromList:
Procedure Expose (global) (scancodes) (poststuff) hrefs. hits. artibase
Parse Arg scheme1,scheme2
/*  Display list and get choice.  */
art=hits.0
If art=0 Then Call PopUp 'There are NO articles available from this group or search.',3,'X'
If art=0 Then Return ''
Do Until picked
  /*  Display 22-line window of list selections.  */
  attr=scheme1
  Do row=3 To 24    
    inset=(row-2)+artibase  /* row 3 is "A" */
    If inset<=art Then
      Do
        If hrefs.inset='' Then
          Do
            leader='   '
            If attr=scheme1 Then attr=scheme2
             Else attr=scheme1
          End
         Else
          Do
            leader=D2C(row-2+alfabase)': '
            If Left(hits.inset,3)<>'   ' Then
              Do
                If attr=scheme1 Then attr=scheme2
                 Else attr=scheme1
              End
          End
        Call ScrWrite row,1,leader||Left(hits.inset,77),,,attr
        top=row
      End
     Else Call ScrWrite row,1,' ',80,' ',2
  End
  Call ScrWrite 2,1,Center('Local list lines 'artibase+1' To 'artibase+top-2' (of 'hits.0')',80),,,15
  /*  Get valid user choice.  */
  top=D2C(top-2+alfabase)
  allowed=XRange('A',top)
  Call ScrWrite 25,1,Center('Pick an Article by corresponding letter key.',80),,,31
  ok=0
  Do Until ok
    pressed=InKey()
    If Length(pressed)=1 Then 
      Do
        scancode=''
        pressed=Upper(pressed)
        If pressed=escape Then ok=1
        If Verify(pressed,allowed,'Match') Then 
          Do
            index=artibase+C2D(pressed)-alfabase
            If hrefs.index<>'' Then ok=1
          End
      End
     Else 
      Do
        scancode=Right(pressed,1)
        pressed=''
        If scancode=pgup | ,
           scancode=pgdn | ,
           scancode=homekey | ,
           scancode=endkey | ,
           scancode=helpf1 | ,
           scancode=D2C(25) | ,
           scancode=D2C(33) | ,
           scancode=D2C(48) Then ok=1
      End
    If \ok Then 
      Do
        If boops Then Call Sound 40,.5
      End
  End  /* of UNTIL OK loop */
  /*  Process choice as appropriate.  */
  picked=0
  If scancode<>'' Then
    Do
      Select
        /*  Screen-change keys.  */
        When scancode=pgup Then
          Do
            If artibase=0 Then 
              Do
                If boops Then Call Sound 200,.1
              End
             Else artibase=artibase-22
            If artibase<0 Then artibase=0
          End
        When scancode=pgdn Then
          Do
            If artibase>=art-22 Then 
              Do
                If boops Then Call Sound 1300,.1
              End
             Else artibase=artibase+22
            If (artibase+22)>=art Then artibase=art-22
          End
        When scancode=homekey Then 
          Do
            If artibase=0 Then 
              Do
                If boops Then Call Sound 200,.1
              End
             Else artibase=0
          End
        When scancode=endkey Then 
          Do
            If artibase>=art-22 Then 
              Do
                If boops Then Call Sound 1300,.1
              End
             Else artibase=art-22
            If artibase<0 Then artibase=0
          End
        When scancode=helpf1 Then 
          Do
            Call ShowHelp
          End
        When scancode=D2C(33) Then  /* Alt-F forward */
          Do
            picked=1
            toread='+'
          End
        When scancode=D2C(48) Then  /* Alt-B back */
          Do
            picked=1
            toread='-'
          End
        When scancode=D2C(25) Then  /* Alt-P post new */
          Do
            Call PostIt 0,'P'
          End
      End  /* Select scancode */
    End  /* nonascii key used */
   Else
    Do
      picked=1
      If pressed=escape Then toread=''
       Else toread=hrefs.index  /* calculated in appraising keypress validity */
    End
End
Return toread


NewHost:
Procedure Expose (global)
Parse Arg service
If SockGetHostByName(service,'host.!')=0 Then serveraddr=''
 Else serveraddr=host.!addr
Return serveraddr


NewGroup:
Procedure Expose (global) msgmax lookback queryserver loadsdir block.
Parse Arg groupname,gserial
query='/rn_print.xp?'||,
      'search=word'||,
      '&svcclass=dncurrent'||,
      '&threaded=1'||,
      '&maxhits='msgmax||,
      '&showsort=date'||,
      '&agesign=1'||,
      '&ageweight=3'||,
      '&days='lookback||,
      '&group='groupname
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
MakeQuery gets the server's response and saves it in a
file named Gserial.HTM, updating GSERIAL as it does so;
it returns the updated GSERIAL or, for any failure, -1.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
artlist=MakeQuery(query,queryserver,gserial,'G')  /* extant GSERIAL */
Return artlist


GetChoice:
Procedure Expose (global) (scancodes) (colors) choicebase choices. lookback
Parse Arg forblanks,attr
count=choices.0
If count>11 Then skip=1
 Else skip=2
pick=-1
Call ScrClear attr,' ',2,1,23,80
Do Until pick>=0
  /*  Display 23-line window of choices.  */
  top=choicebase+23
  If top>count Then top=count
  Do index=choicebase+1 To top
    row=1+((index-choicebase)*skip)
    If Strip(choices.index)='' Then Call ScrWrite row,1,Copies(forblanks,80)
     Else Call ScrWrite row,1,D2C(index-choicebase+alfabase)||': 'Left(choices.index,77),80,' ',attr
  End
  /*  Get a valid keypress.  */
  top=D2C(top-choicebase+alfabase)
  allowed=XRange('A',top)
  ok=0
  Do Until ok
    pressed=InKey()
    If Length(pressed)=1 Then 
      Do
        scancode=''
        pressed=Upper(pressed)
        If Verify(pressed,allowed,'Match') | pressed='+' | pressed=escape Then ok=1
        If forblanks=' ' & pressed='+' Then ok=0  /* only in group selection */
      End
     Else 
      Do
        scancode=Right(pressed,1)
        pressed=''
        Select
          When scancode=pgup |,
               scancode=pgdn |,
               scancode=homekey |,
               scancode=endkey |,
               scancode=helpf1 Then ok=1
          Otherwise ok=0
        End
      End
    If \ok Then 
      Do
        If boops Then Call Sound 40,.5
      End
  End
  /*  Process valid keypresses.  */
  If scancode<>'' Then
    Do
      Select
        When scancode=pgup Then
          Do
            If choicebase=0 Then 
              Do
                If boops Then Call Sound 200,.1
              End
             Else choicebase=choicebase-23
          End
        When scancode=pgdn Then
          Do
            If choicebase>=(count-23) Then 
              Do
                If boops Then Call Sound 1300,.1
              End
             Else 
              Do
                choicebase=choicebase+23
                If (choicebase+24)>count Then choicebase=count-23
              End
          End
        When scancode=homekey Then 
          Do
            If choicebase=0 Then 
              Do
                If boops Then Call Sound 200,.1
              End
             Else choicebase=0
          End
        When scancode=endkey Then 
          Do
            If choicebase=count-23 Then 
              Do
                If boops Then Call Sound 1300,.1
              End
             Else choicebase=count-23
          End
        When scancode=helpf1 Then 
          Do
            Call ShowHelp
          End
      End
      If choicebase<0 Then choicebase=0
    End
   Else
    Do
      Select
        When pressed=escape Then pick=0
        When pressed='+' Then lookback=HowFar(lookback)
        Otherwise pick=choicebase+(C2D(pressed))-alfabase
      End
    End
End
Return pick


SendLine:
Procedure Expose (global)
Parse Arg tosend,socket
data=tosend||crlf
Do Forever
  If SockSend(socket,data)=Length(data) Then Leave
   Else
    Do
      pressed=PopUp('Failure sending command line.  Retry?',3)
      If pressed='N' Then Call ItQuits 'Fatal error trying to send to server.',-8
    End
End
Return


GetALine:
/*  For NNTP use.  */
Procedure Expose (global)
Parse Arg socket
buffer=''
Do While Pos(crlf,buffer)=0
  rc=SockRecv(socket,'data',8000)
  If rc<>-1 Then buffer=buffer||data
End
cut=Pos(crlf,buffer)
If cut>0 Then 
  Do
    got=SubStr(buffer,1,cut-1)
    buffer=SubStr(buffer,cut+2)  /*  keep any excess for later  */
  End
 Else got='### BAD RECEIVE ###'
Return got


GetPointer:
Procedure Expose (global)
Parse Arg item
start=Pos('<A HREF="http://xp',item)
If start=0 Then Return ''
 Else start=start+16
cut=Pos('">',item,start)
If cut>0 Then 
  Do
    ref=SubStr(item,start,cut-start)
    If ref<>'' Then
      Do
        start=Pos('/',ref)
        query=SubStr(ref,start)
      End
  End
 Else query=''
Return query


DeHtml:
Procedure Expose (global)
Parse Arg item
Do While Pos('<',item)>0
  start=Pos('<',item)
  cut=Pos('>',item,start)
  If cut=0 Then item=Left(item,start-1)
   Else item=Left(item,start-1)||SubStr(item,cut+1)
End
Do While Pos('&lt;',item)>0
  start=Pos('&lt;',item)
  item=Left(item,start-1)||'<'||SubStr(item,start+4)
End
Do While Pos('&gt;',item)>0
  start=Pos('&gt;',item)
  item=Left(item,start-1)||'>'||SubStr(item,start+4)
End
Do While Pos('&quot;',item)>0
  start=Pos('&quot;',item)
  item=Left(item,start-1)||'"'||SubStr(item,start+6)
End
Do While Pos('&amp;',item)>0
  start=Pos('&amp;',item)
  item=Left(item,start-1)||'&'||SubStr(item,start+6)
End
Return item


LineValue:
Procedure Expose (global)
Parse Arg linevalue
start=Pos(':',linevalue)
linevalue=Strip(SubStr(linevalue,start+1))
Return linevalue


Profile:
Procedure Expose (global) (scancodes) queryserver loadsdir pointers.
Parse Arg query
Call ArrayCopy 'pointers.','holder.'  /* preserve... */
/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::
MakeQuery gets the server's response and saves it in a
file named P999.HTM; it returns 999 for success or,
for any failure, -1.  It must be fed 998 as dummy serial.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
ok=MakeQuery(query,queryserver,998,'P')  /* 998=dummy "serial" value */
Call ArrayCopy 'holder.','pointers.'  /* ...and restore */
If ok<1 Then Call PopUp 'Profile NOT returned.',7,'X'
 Else
  Do
    Call ScrWrite 25,1,Center('Parsing author profile . . . ',80),,,31
    text.0=0
    t=0
    Call FileRead loadsdir'P999.HTM','html.'
    inset=0
    Do line=1 To html.0
      If Pos('>UTHOR PROFILE: ',html.line)>0 Then 
        Do
          t=t+1
          build='  Author Profile, message '
          start=16+Pos('>UTHOR PROFILE: ',html.line)
          cut=Pos('<',html.line,start)
          snip=SubStr(html.line,start,cut-start)
          text.t=DeHtml(snip)
          t=t+1
          text.t=Copies('=',70)
        End
      If Pos('<UL>',html.line)>0 Then inset=inset+1
      If Pos('</UL>',html.line)>0 Then inset=inset-1
      If Pos('<LI>',html.line)>0 Then
        Do
          t=t+1
          text.t=Copies(' ',inset*3)||DeHtml(html.line)
        End
    End
    If t>0 Then
      Do
        Call ScrWrite 1,1,Center('Author profile:',80),,,31
        Call ScrWrite 25,1,Center(text.1,80),,,31
        t=t+1
        text.t=''
        text.0=t
        temp=W_Open(2,1,23,80,112)
        probase=2
        done=0
        help=7
        Do Until done
          Do row=1 To 23
            index=row+probase
            If index<text.0 Then Call W_ScrWrite temp,row,1,Left(text.index,80)
             Else Call W_ScrWrite temp,row,1,Copies(' ',80)
          End
          pressed=InKey()
          If Length(pressed)=1 Then 
            Do
              If pressed=escape Then done=1
               Else 
                 Do
                   If boops Then Call Sound 40,.5
                 End
            End
           Else           
            Do
              scancode=Right(pressed,1)
              Select
                When scancode=pgup Then
                  Do
                    ok=1
                    If probase=2 Then 
                      Do
                        If boops Then Call Sound 200,.1
                      End
                     Else probase=probase-23
                  End
                When scancode=pgdn Then
                  Do
                    ok=1
                    If probase>=(t-23) Then 
                      Do
                        If boops Then Call Sound 1300,.1
                      End
                     Else 
                      Do
                        probase=probase+23
                        If (probase+24)>t Then probase=t-23
                      End
                  End
                When scancode=homekey Then 
                  Do
                    ok=1
                    If probase=2 Then 
                      Do
                        If boops Then Call Sound 200,.1
                      End
                     Else probase=2
                  End
                When scancode=endkey Then 
                  Do
                    ok=1
                    If probase=t-23 Then 
                      Do
                        If boops Then Call Sound 1300,.1
                      End
                     Else probase=t-23
                  End
                When scancode=helpf1 Then 
                  Do
                    Call ShowHelp
                  End
                Otherwise 
                  Do
                    If boops Then Call Sound 40,.5
                  End
              End  /* select */
              If probase<2 Then probase=2
            End              
        End  /* display text */
        help=0
        Call W_Close temp
        Call CursorType ,,0
      End  /* parsed ok */
     Else Call PopUp 'Failed to find valid Profile info.',5,'X'
  End  /* received ok */
Return


ShowHeader:
Procedure Expose (global) loadsdir
Parse Arg aserial
Call FileRead loadsdir'H'aserial'.TXT','dummy.'
head.0=0
j=0
done=0
Do i=1 To dummy.0
  j=j+1
  If j>18 Then
    Do
      done=1
      j=18
      dummy.j=Center('[Header text overflowed allowed space--not all shown]',80)
    End
  If done Then Leave
  If Length(dummy.i)<=80 Then head.j=dummy.i
   Else
    Do
      head.j=Left(dummy.i,80)
      inset=1+Pos(':',dummy.i)
      balance=SubStr(dummy.i,81)
      allowed=79-inset
      Do While balance<>''
        j=j+1
        head.j=Copies(' ',inset)||Left(balance,allowed)
        balance=SubStr(balance,1+allowed)
      End
    End  
End
head.0=j
max=5+head.0
temp=W_Open(2,1,max,80,112)
Call W_ScrWrite temp,max-2,1,Center('(Press any key to dismiss header text.)',80)
Call W_ScrWrite temp,max,1,Copies(':',80)
row=1
Do line=1 To head.0
  row=row+1
  Call W_ScrWrite temp,row,1,head.line
End
Call InKey
Call W_Close temp
Call CursorType ,,0
Return


SaveIt:
Procedure Expose (global) loadsdir
Parse Arg serial
temp=W_Open(10,1,7,80,95)
Call W_Border temp
Call W_ScrWrite temp,3,2,Center('Enter the save-file name (or press <Esc> to abort):',78)
saveas=W_Get(temp,5,2,78,,15)
Call W_Close temp
Call CursorType ,,0
If saveas<>'' Then
  Do
    If ValidName(saveas) Then
      Do
        testdir=FileSpec('Drive',saveas)||Strip(FileSpec('Path',saveas),'T','\')
        If DosIsDir(testdir) Then 
          Do
            ec=DosCopy(loadsdir'H'serial'.TXT',saveas,'R')
            If ec=0 Then ec=DosCopy(loadsdir'A'serial'.TXT',saveas,'A')
            If ec<>0 Then Call PopUp 'Save failed! (rc='ec')',4,'X'
             Else 
               Do
                 If boops Then Call Sound 1200,.1
               End
          End
         Else Call PopUp 'That directory does not exist; not saved.',4,'X'
      End
     Else Call PopUp 'That is not a valid filespec.! (Not saved.)',4,'X'
  End
Call CursorType ,,0
Return


HowFar:
Procedure Expose (global)
Parse Arg oldback
temp=W_Open(10,1,7,80,95)
Call W_Border temp
Do Forever
  Call W_ScrWrite temp,3,2,Center('Enter a Look-Back period in days (or press <Esc> to abort):',78)
  lookback=W_Get(temp,5,11,3,,15)
  If lookback='' Then Leave
  If DataType(lookback)='NUM' Then lookback=Format(lookback,,0)
   Else lookback=0
  If lookback>0 Then Leave
  If boops Then Call Sound 40,.5
End
Call W_Close temp
Call CursorType ,,0
If lookback='' Then lookback=oldback
Return lookback


PopUp:
Procedure Expose (global)
Parse Arg text,color,mode
If mode='' Then second='Press Y for Yes or any other key for No.'
 Else second='Press any key to continue.'
width=6+Length(text)
If width<46 Then width=46
column=1+((80-width)%2)
If boops Then Call Sound 600,.2
handle=W_Open(10,column,7,width,(color+8)*16)
Call W_Border handle,1,1,1,1
Call W_ScrWrite handle,3,4,Center(text,width-6)
Call W_ScrWrite handle,5,4,Center(second,width-6)
pressed=Upper(InKey())
Call W_Close handle
Call CursorType ,,0
If pressed<>'Y' Then pressed='N'
Return pressed


GoodBye:
/*  For NNTP stuff.  */
Procedure Expose (global)
Parse Arg socket
Call SendLine 'QUIT',socket
Call ScrWrite 25,1,Center('Logging off 'poster'.',80),,,31
got=GetALine(socket)
got=SockSoClose(socket)
If got=-1 Then Call PopUp 'Error closing socket.',4,'X'
Return got


KillAll:
Procedure Expose (global) loadsdir
Parse Arg spec
Call SysFileTree loadsdir||spec,'dummy.','FO'
Do i=1 To dummy.0
  Call DosDel dummy.i
End
Return


BlockRen:
Procedure Expose (global) loadsdir
Parse Arg groupnumber,direc
If direc='HOLD' Then
  Do
    s='G'
    t='X'
  End
 Else
  Do
    s='X'
    t='G'
  End
Call SysFileTree loadsdir||s||groupnumber'.*','dummy.','FO'
Do i=1 To dummy.0
  ext=Word(ParseFN(dummy.i),4)
  Call DosRename dummy.i,loadsdir||t||groupnumber'.'ext
End
Return



/*------Help Screens:-------------------------------------*/

ShowHelp:
Procedure Expose (global)
temp=W_Open(2,1,24,80,31)
Call W_Border temp
Call W_ScrWrite temp,24,2,Center('(Press any key to dismiss this help screen.)',78,'')
Select
  /*  Pick a Cluster:  */
  When help=1 Then
    Do
      Call W_ScrWrite temp, 4,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 5,2,Center('to display more choices (if there are more).',78)
      Call W_ScrWrite temp, 9,2,Center('Press "A" to begin a cross-group search for',78)
      Call W_ScrWrite temp,10,2,Center('all messages containing one or more phrases you will specify.',78)
      Call W_ScrWrite temp,14,2,Center('Press any other letter shown to display',78)
      Call W_ScrWrite temp,15,2,Center('your groups list for that interest cluster.',78)
      Call W_ScrWrite temp,19,2,Center('Press the <Esc> key to exit this program.',78)
    End

  /*  Pick a Group:  */
  When help=2 Then
    Do
      Call W_ScrWrite temp, 6,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 7,2,Center('to display more choices (if there are more).',78)
      Call W_ScrWrite temp,11,2,Center('Press any letter shown to list',78)
      Call W_ScrWrite temp,12,2,Center('the current articles list for that group.',78)
      Call W_ScrWrite temp,16,2,Center('Press the + key to change the LookBack period in days.',78)
      Call W_ScrWrite temp,19,2,Center('Press the <Esc> key to select another interest cluster of groups.',78)
    End

  /*  Pick an Article:  */
  When help=3 Then
    Do
      Call W_ScrWrite temp, 5,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 6,2,Center('to display more choices (if there are more).',78)
      Call W_ScrWrite temp,10,2,Center('Press any letter shown to see that specific article.',78)
      Call W_ScrWrite temp,14,2,Center('Press Alt-F to list the next block of articles (if any) for this group.',78)
      Call W_ScrWrite temp,16,2,Center('Press Alt-B to list the previous block of articles (if any) for this group.',78)
      Call W_ScrWrite temp,20,2,Center('Press the <Esc> key to select another group in this interest cluster.',78)
    End

  /*  Pick a Search Hit:  */
  When help=4 Then
    Do
      Call W_ScrWrite temp, 5,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 6,2,Center('to see more choices (if there are more).',78)
      Call W_ScrWrite temp,10,2,Center('Press any letter shown to see that specific article.',78)
      Call W_ScrWrite temp,14,2,Center('Press Alt-F to list the next block of hits (if any) for this search.',78)
      Call W_ScrWrite temp,16,2,Center('Press Alt-B to list the previous block of hits (if any) for this search.',78)
      Call W_ScrWrite temp,20,2,Center('Press the <Esc> key to return to selecting interest clusters.',78)
    End

  /*  Pick an thread-list Article:  */
  When help=5 Then
    Do
      Call W_ScrWrite temp, 5,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 6,2,Center('to display more choices (if there are more).',78)
      Call W_ScrWrite temp,10,2,Center('Press any letter shown to see that specific article.',78)
      Call W_ScrWrite temp,14,2,Center('Press Alt-F to list the next block of articles (if any) for this thread.',78)
      Call W_ScrWrite temp,16,2,Center('Press Alt-B to list the previous block of articles (if any) for this thread.',78)
      Call W_ScrWrite temp,20,2,Center('Press the <Esc> key to select another group in this interest cluster.',78)
    End

  /*  View an Article:  */
  When help=6 Then
    Do
      Call W_ScrWrite temp, 2,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 3,2,Center('to see more text (if there is more).',78)
      Call W_ScrWrite temp, 5,2,Center('You can use the LeftArrow and RightArrow cursor keys.',78)
      Call W_ScrWrite temp, 6,2,Center('to shift the display sideways if text is off-screen.',78)
      Call W_ScrWrite temp, 8,2,Center('Press Alt-F to forward to the next article in the articles list.',78)
      Call W_ScrWrite temp, 9,2,Center('Press Alt-B to back up to the previous article in the articles list.',78)
      Call W_ScrWrite temp,11,2,Center('Press Alt-R to post a reply to this article.',78)
      Call W_ScrWrite temp,12,2,Center('Press Alt-P to post a new article in this newsgroup.',78)
      Call W_ScrWrite temp,14,2,Center('Press Alt-T to list all available articles in this thread.',78)
      Call W_ScrWrite temp,16,2,Center('Press Alt-A to see a posting profile of the author of this article.',78)
      Call W_ScrWrite temp,18,2,Center('Press Alt-H to see the header information for this article.',78)
      Call W_ScrWrite temp,20,2,Center('Press Alt-S to save this article/header to a specific file.',78)
      Call W_ScrWrite temp,22,2,Center('Press the <Esc> key to return to selecting articles.',78)
    End

  /*  View a Profile:  */
  When help=7 Then
    Do
      Call W_ScrWrite temp, 8,2,Center('You can use the <PgDn>, <PgUp>, <Home>, and <End> keys',78)
      Call W_ScrWrite temp, 9,2,Center('to see more text (if there is any more).',78)
      Call W_ScrWrite temp,16,2,Center('Press the <Esc> key to return to the original article.',78)
    End

  Otherwise
    Do
      Call W_ScrWrite temp,12,2,Center('No context-sensitive help is available for this screen.',78)
    End
End
Call InKey
Call W_Close temp
Call CursorType ,,0
Return


/*------Exit Routines:------------------------------------*/

SYNTAX:
which=rc
where=sigl
Do 3
  Call Sound 500,.2
  Call Sound 200,.1
End
Call ScrWrite 11,1,Center('A SYNTAX Trap was Signalled from Line 'where'.',80),,,79
Call ScrWrite 12,1,Center('The Error Number is: 'which', which means:',80),,,15
Call ScrWrite 13,1,Center(ErrorText(which),80),,,2
Call ScrWrite 14,1,Center('Operation cannot continue--press any key to exit.',80),,,79
Call Inkey
Call ItQuits 'Syntax Error 'which' on Line 'where'; type HELP REX'which' for details.',-9


HALT:
where=sigl
Do 3
  Call Sound 500,.2
  Call Sound 200,.1
End
Call ScrWrite 12,1,Center('A HALT was Signalled while in Line 'where'.',80),,,79
Call ScrWrite 13,1,Center('Operation cannot continue--press any key to exit.',80),,,79
Call Inkey
Call ItQuits 'HALT initiated while on Line 'where'.',-10


ItQuits:
Procedure Expose (global)
Parse Arg message,ec
Call CursorType ,,1
If rexxsock Then Call SockDropFuncs
If quercuswin Then Call W_Deregister
If quercuslib Then Call RexxLibDeregister
If rexxutils Then Call SysDropFuncs
If boops Then 
  Do
    Call Beep 400,200
    Call Beep 200,100
  End
'cls'
Say
Say '   'message
Say
Say
Exit ec


/* [end] */


