#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <malloc.h>
#include <fcntl.h>

int	fh;

void error(char *errstr)
{	printf(errstr);
	exit(1);	}

main(argc,argv)
int argc;
char *argv[];
{
	char texname[10], patname[10];
	char *pnames;
	long numtexs, numpats, dummy, i;
	int numpat, scuz, j, k;
	
	if (argc != 3)
		error("Usage: detex <pnames> <textures>\n");

	texname[8]='\0';
	patname[8]='\0';
	
	if (!(fh=open(argv[1], O_BINARY|O_RDONLY)))
		error("Can't open <pnames>.\n");
	read(fh, &numpats, 4);
	if ((pnames=(char *)malloc(8*numpats))==NULL) {
		close(fh);
		error("Can't allocate space for pnames.\n");
		}
	read(fh, pnames, 8*numpats);
	close(fh);

	if (!(fh=open(argv[2], O_BINARY|O_RDONLY)))
		error("Can't open <textures>.\n");

	printf("PATCHES\n");
	for (i=0; i<numpats; i++) {
		for (k=0; k<8; k++)
			patname[k]=*(pnames+8*i+k);
		printf("%ld\t%8s\n", i, &patname);
		}

	printf("TEXTURES\n");
	read(fh, &numtexs, 4);
	for (i=0; i<numtexs; i++)
		read(fh, &dummy, 4);
	for (i=0; i<numtexs; i++) {
		for (k=0; k<8; k++)
			read(fh, &texname[k], 1);
		printf("%8s ", &texname);
		for (j=0; j<6; j++) {
			read(fh, &scuz, 2);
			printf("%d ", scuz);
			}
		read(fh, &numpat, 2);
		printf("%d\n", numpat);
		for (j=0; j<numpat; j++) {
			for (k=0; k<3; k++) {
				read(fh, &scuz, 2);
				printf("\t%d", scuz);
				}
			for (k=0; k<8; k++)
				patname[k]=*(pnames+8*scuz+k);
			printf("\t%8s", &patname);
			for (k=0; k<2; k++) {
				read(fh, &scuz, 2);
				printf("\t%d", scuz);
				}
			printf("\n");
			}
		}
	close(fh);
	
	printf("EOF\n");
	free(pnames);

	exit(0);
}