program GetRootSample;

(*

 Every DOS disk has a root directory with entries that specify the volume's
 name, files, and other directories. This program reads the root directory
 sectors for the drive specified and displays the root directory entries.

*)

 uses crt, DMT;

 var
   RootDirBuffer    : array[ 1..16 ] of RootDirEntryStruct; { The RootDirEntry data type is defined in the DMT unit }

   LogDrvs          : ListOfDrvs;        { The ListOfDrvs data type is defined in the DMT unit }

   BPBbuffer        : DevParamsStruct;   { The DevParamsStruct data type is defined in the DMT unit }

   StartRootSector,
   Head,
   Track,
   Sect,
   SectCounter,
   NumOfRootSects,
   Count            : word;

   DrvsCount,
   Index            : byte;

   DrvLetter        : char;

begin
  fillchar( RootDirBuffer, sizeof( RootDirBuffer ), #0 );
  Color( 7, 0 );
  clrscr;

  GetDrvs( LogDrvs, DrvsCount );   { Call GetDrvs procedure }

  write( #13#10, 'Select drive ( ');

  for Index := 1 to DrvsCount do
    write( LogDrvs[ Index ], ': ' );

  write( ') [ :]' );
  gotoxy( wherex - 3, wherey );

  DrvLetter := upcase( readkey );
  writeln( DrvLetter );

  GetBPB( DrvLetter, BPBbuffer );    { Call GetBPB procedure }

  if ( ErrFlag ) then
    begin
      writeln( #7 );
      writeln( ShowError( GetErrCode ) );
    end
  else
    begin
      clrscr;
      writeln( '      ROOT DIRECTORY SECTOR ENTRIES ' );
      writeln;
      writeln( ' Filename            Size       Starting Cluster' );
      writeln;
      window( 1, 5, 80, 25 );

      with BPBbuffer do
        begin

          (* Determines the number of root directory sectors to read *)

          NumOfRootSects := ( MaxRootEntries * 32 ) div BytesPerSect;

          (* Determines the start of the first root directory sector *)

          StartRootSector := ( NumOfFATs * SectsPerFAT ) + HiddenSects + BootSects;

          for SectCounter := StartRootSector to ( StartRootSector + NumOfRootSects - 1 ) do
            begin

              (*
                 Translates a logical root directory sector number into a physical
                 sector consisting of head, track, and sector numbers.
              *)

              Head  := ( SectCounter div SectsPerTrack ) mod NumOfHeads;
              Track := SectCounter div ( SectsPerTrack * NumOfHeads );
              Sect  := SectCounter mod SectsPerTrack;


              (*
                 Reads a root directory sector from disk and place it into a
                 buffer.
              *)

              ReadSect( DrvLetter, Head, Track, Sect, 1, addr( RootDirBuffer ) );


              (* Displays 16 root directory entries *)

              for Count := 1 to 16 do
                begin

                  with RootDirBuffer[ Count ] do
                    if ( FileName[ 1 ] <> #0 ) then
                      begin
                        write( FileName, '.', Extension, InsComma( FileSize ):15, InsComma( FirstCluster ):15 );

                        if ( FileName[ 1 ] = chr( 229 ) ) then
                          write( 'File deleted!': 24 );

                         writeln;
                      end
                    else
                      begin
                        GetEnter;
                        exit;
                      end;

                  if ( wherey = 20 ) then
                    begin
                      write( #13#10, ' --- More ---' );
                      readln;
                      clrscr;
                    end;

                end;
            end;
        end;
    end;
  GetEnter;
end.

